/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.core.device;

import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import com.unity3d.splash.services.core.log.DeviceLog;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

@TargetApi(value=9)
public class AdvertisingId {
    private static final String ADVERTISING_ID_SERVICE_NAME = "com.google.android.gms.ads.identifier.internal.IAdvertisingIdService";
    private static AdvertisingId instance = null;
    private String advertisingIdentifier = null;
    private boolean limitedAdvertisingTracking = false;

    private static AdvertisingId getInstance() {
        if (instance == null) {
            instance = new AdvertisingId();
        }
        return instance;
    }

    public static void init(Context context) {
        AdvertisingId.getInstance().fetchAdvertisingId(context);
    }

    public static String getAdvertisingTrackingId() {
        return AdvertisingId.getInstance().advertisingIdentifier;
    }

    public static boolean getLimitedAdTracking() {
        return AdvertisingId.getInstance().limitedAdvertisingTracking;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void fetchAdvertisingId(Context context) {
        GoogleAdvertisingServiceConnection googleAdvertisingServiceConnection = new GoogleAdvertisingServiceConnection();
        Object object = new Intent("com.google.android.gms.ads.identifier.service.START");
        object.setPackage("com.google.android.gms");
        boolean bl = false;
        try {
            bl = context.bindService((Intent)object, (ServiceConnection)googleAdvertisingServiceConnection, 1);
        }
        catch (Exception exception) {
            DeviceLog.exception("Couldn't bind to identifier service intent", exception);
        }
        try {
            if (bl) {
                object = GoogleAdvertisingInfo.GoogleAdvertisingInfoBinder.create(googleAdvertisingServiceConnection.getBinder());
                this.advertisingIdentifier = object.getId();
                this.limitedAdvertisingTracking = object.getEnabled(true);
            }
            if (!bl) return;
        }
        catch (Exception exception) {
            DeviceLog.exception("Couldn't get advertising info", exception);
            return;
        }
        finally {
            if (!bl) return;
            context.unbindService((ServiceConnection)googleAdvertisingServiceConnection);
        }
        context.unbindService((ServiceConnection)googleAdvertisingServiceConnection);
        return;
    }

    private class GoogleAdvertisingServiceConnection
    implements ServiceConnection {
        boolean _consumed = false;
        private final BlockingQueue _binderQueue = new LinkedBlockingQueue();

        private GoogleAdvertisingServiceConnection() {
        }

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            try {
                this._binderQueue.put(iBinder);
                return;
            }
            catch (InterruptedException interruptedException) {
                DeviceLog.debug("Couldn't put service to binder que");
                return;
            }
        }

        public void onServiceDisconnected(ComponentName componentName) {
        }

        public IBinder getBinder() {
            if (this._consumed) {
                throw new IllegalStateException();
            }
            this._consumed = true;
            return (IBinder)this._binderQueue.take();
        }
    }

    private static interface GoogleAdvertisingInfo
    extends IInterface {
        public String getId();

        public boolean getEnabled(boolean var1);

        public static abstract class GoogleAdvertisingInfoBinder
        extends Binder
        implements GoogleAdvertisingInfo {
            public static GoogleAdvertisingInfo create(IBinder iBinder) {
                if (iBinder == null) {
                    return null;
                }
                IInterface iInterface = iBinder.queryLocalInterface(AdvertisingId.ADVERTISING_ID_SERVICE_NAME);
                if (iInterface != null && iInterface instanceof GoogleAdvertisingInfo) {
                    return (GoogleAdvertisingInfo)iInterface;
                }
                return new GoogleAdvertisingInfoImplementation(iBinder);
            }

            public boolean onTransact(int n2, Parcel parcel, Parcel parcel2, int n3) {
                switch (n2) {
                    case 1: {
                        parcel.enforceInterface(AdvertisingId.ADVERTISING_ID_SERVICE_NAME);
                        String string = this.getId();
                        parcel2.writeNoException();
                        parcel2.writeString(string);
                        return true;
                    }
                    case 2: {
                        parcel.enforceInterface(AdvertisingId.ADVERTISING_ID_SERVICE_NAME);
                        n2 = 0 != parcel.readInt() ? 1 : 0;
                        n2 = this.getEnabled(n2 != 0) ? 1 : 0;
                        parcel2.writeNoException();
                        parcel2.writeInt(n2 != 0 ? 1 : 0);
                        return true;
                    }
                }
                return super.onTransact(n2, parcel, parcel2, n3);
            }

            private static class GoogleAdvertisingInfoImplementation
            implements GoogleAdvertisingInfo {
                private final IBinder _binder;

                GoogleAdvertisingInfoImplementation(IBinder iBinder) {
                    this._binder = iBinder;
                }

                public IBinder asBinder() {
                    return this._binder;
                }

                @Override
                public String getId() {
                    String string;
                    Parcel parcel = Parcel.obtain();
                    Parcel parcel2 = Parcel.obtain();
                    try {
                        parcel.writeInterfaceToken(AdvertisingId.ADVERTISING_ID_SERVICE_NAME);
                        this._binder.transact(1, parcel, parcel2, 0);
                        parcel2.readException();
                        string = parcel2.readString();
                    }
                    finally {
                        parcel2.recycle();
                        parcel.recycle();
                    }
                    return string;
                }

                @Override
                public boolean getEnabled(boolean bl) {
                    Parcel parcel = Parcel.obtain();
                    Parcel parcel2 = Parcel.obtain();
                    try {
                        parcel.writeInterfaceToken(AdvertisingId.ADVERTISING_ID_SERVICE_NAME);
                        parcel.writeInt(bl ? 1 : 0);
                        this._binder.transact(2, parcel, parcel2, 0);
                        parcel2.readException();
                        bl = 0 != parcel2.readInt();
                    }
                    finally {
                        parcel2.recycle();
                        parcel.recycle();
                    }
                    return bl;
                }
            }
        }
    }
}

