/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.core.connectivity;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;
import com.unity3d.splash.services.core.connectivity.ConnectivityChangeReceiver;
import com.unity3d.splash.services.core.connectivity.ConnectivityEvent;
import com.unity3d.splash.services.core.connectivity.ConnectivityNetworkCallback;
import com.unity3d.splash.services.core.connectivity.IConnectivityListener;
import com.unity3d.splash.services.core.log.DeviceLog;
import com.unity3d.splash.services.core.properties.ClientProperties;
import com.unity3d.splash.services.core.webview.WebViewApp;
import com.unity3d.splash.services.core.webview.WebViewEventCategory;
import java.util.HashSet;
import java.util.Iterator;

public class ConnectivityMonitor {
    private static int _connected = -1;
    private static boolean _listening = false;
    private static boolean _webappMonitoring = false;
    private static boolean _wifi = false;
    private static int _networkType = -1;
    private static HashSet _listeners = null;

    public static void setConnectionMonitoring(boolean bl) {
        _webappMonitoring = bl;
        ConnectivityMonitor.updateListeningStatus();
    }

    public static void addListener(IConnectivityListener iConnectivityListener) {
        if (_listeners == null) {
            _listeners = new HashSet();
        }
        _listeners.add(iConnectivityListener);
        ConnectivityMonitor.updateListeningStatus();
    }

    public static void removeListener(IConnectivityListener iConnectivityListener) {
        if (_listeners == null) {
            return;
        }
        _listeners.remove(iConnectivityListener);
        ConnectivityMonitor.updateListeningStatus();
    }

    public static void stopAll() {
        _listeners = null;
        _webappMonitoring = false;
        ConnectivityMonitor.updateListeningStatus();
    }

    private static void updateListeningStatus() {
        if (_webappMonitoring || _listeners != null && !_listeners.isEmpty()) {
            ConnectivityMonitor.startListening();
            return;
        }
        ConnectivityMonitor.stopListening();
    }

    private static void startListening() {
        if (_listening) {
            return;
        }
        _listening = true;
        ConnectivityMonitor.initConnectionStatus();
        if (Build.VERSION.SDK_INT < 21) {
            ConnectivityChangeReceiver.register();
            return;
        }
        ConnectivityNetworkCallback.register();
    }

    private static void stopListening() {
        if (!_listening) {
            return;
        }
        _listening = false;
        if (Build.VERSION.SDK_INT < 21) {
            ConnectivityChangeReceiver.unregister();
            return;
        }
        ConnectivityNetworkCallback.unregister();
    }

    private static void initConnectionStatus() {
        ConnectivityManager connectivityManager = (ConnectivityManager)ClientProperties.getApplicationContext().getSystemService("connectivity");
        if (connectivityManager == null) {
            return;
        }
        if ((connectivityManager = connectivityManager.getActiveNetworkInfo()) != null && connectivityManager.isConnected()) {
            _connected = 1;
            _wifi = connectivityManager.getType() == 1;
            if (!_wifi) {
                _networkType = ((TelephonyManager)ClientProperties.getApplicationContext().getSystemService("phone")).getNetworkType();
                return;
            }
        } else {
            _connected = 0;
        }
    }

    public static void connected() {
        if (_connected == 1) {
            return;
        }
        DeviceLog.debug("Unity Ads connectivity change: connected");
        ConnectivityMonitor.initConnectionStatus();
        if (_listeners != null) {
            Iterator iterator = _listeners.iterator();
            while (iterator.hasNext()) {
                ((IConnectivityListener)iterator.next()).onConnected();
            }
        }
        ConnectivityMonitor.sendToWebview(ConnectivityEvent.CONNECTED, _wifi, _networkType);
    }

    public static void disconnected() {
        if (_connected == 0) {
            return;
        }
        _connected = 0;
        DeviceLog.debug("Unity Ads connectivity change: disconnected");
        if (_listeners != null) {
            Iterator iterator = _listeners.iterator();
            while (iterator.hasNext()) {
                ((IConnectivityListener)iterator.next()).onDisconnected();
            }
        }
        ConnectivityMonitor.sendToWebview(ConnectivityEvent.DISCONNECTED, false, 0);
    }

    public static void connectionStatusChanged() {
        if (_connected != 1) {
            return;
        }
        NetworkInfo networkInfo = ((ConnectivityManager)ClientProperties.getApplicationContext().getSystemService("connectivity")).getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected()) {
            boolean bl = networkInfo.getType() == 1;
            int n2 = ((TelephonyManager)ClientProperties.getApplicationContext().getSystemService("phone")).getNetworkType();
            if (bl == _wifi && (n2 == _networkType || _wifi)) {
                return;
            }
            _wifi = bl;
            _networkType = n2;
            DeviceLog.debug("Unity Ads connectivity change: network change");
            ConnectivityMonitor.sendToWebview(ConnectivityEvent.NETWORK_CHANGE, bl, n2);
        }
    }

    private static void sendToWebview(ConnectivityEvent connectivityEvent, boolean bl, int n2) {
        if (!_webappMonitoring) {
            return;
        }
        WebViewApp webViewApp = WebViewApp.getCurrentApp();
        if (webViewApp == null || !webViewApp.isWebAppLoaded()) {
            return;
        }
        switch (connectivityEvent) {
            case CONNECTED: {
                if (bl) {
                    webViewApp.sendEvent(WebViewEventCategory.CONNECTIVITY, ConnectivityEvent.CONNECTED, bl, 0);
                    return;
                }
                webViewApp.sendEvent(WebViewEventCategory.CONNECTIVITY, ConnectivityEvent.CONNECTED, bl, n2);
                return;
            }
            case DISCONNECTED: {
                webViewApp.sendEvent(WebViewEventCategory.CONNECTIVITY, ConnectivityEvent.DISCONNECTED, new Object[0]);
                return;
            }
            case NETWORK_CHANGE: {
                if (bl) {
                    webViewApp.sendEvent(WebViewEventCategory.CONNECTIVITY, ConnectivityEvent.NETWORK_CHANGE, bl, 0);
                    return;
                }
                webViewApp.sendEvent(WebViewEventCategory.CONNECTIVITY, ConnectivityEvent.NETWORK_CHANGE, bl, n2);
            }
        }
    }
}

