/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.core.configuration;

import android.os.Build;
import android.webkit.JavascriptInterface;
import com.unity3d.splash.services.core.log.DeviceLog;
import com.unity3d.splash.services.core.properties.SdkProperties;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;

public class EnvironmentCheck {
    public static boolean isEnvironmentOk() {
        return EnvironmentCheck.testProGuard() && EnvironmentCheck.testCacheDirectory();
    }

    public static boolean testProGuard() {
        try {
            GenericDeclaration genericDeclaration = Class.forName("com.unity3d.splash.services.core.webview.bridge.WebViewBridgeInterface");
            Method method = genericDeclaration.getMethod("handleInvocation", String.class);
            genericDeclaration = genericDeclaration.getMethod("handleCallback", String.class, String.class, String.class);
            if (EnvironmentCheck.hasJavascriptInterface(method) && EnvironmentCheck.hasJavascriptInterface(genericDeclaration)) {
                DeviceLog.debug("Unity Ads ProGuard check OK");
                return true;
            }
            DeviceLog.error("Unity Ads ProGuard check fail: missing @JavascriptInterface annotations in Unity Ads web bridge");
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            DeviceLog.exception("Unity Ads ProGuard check fail: Unity Ads web bridge class not found", classNotFoundException);
            return false;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            DeviceLog.exception("Unity Ads ProGuard check fail: Unity Ads web bridge methods not found", noSuchMethodException);
            return false;
        }
        catch (Exception exception) {
            DeviceLog.exception("Unknown exception during Unity Ads ProGuard check: " + exception.getMessage(), exception);
            return true;
        }
    }

    public static boolean testCacheDirectory() {
        if (SdkProperties.getCacheDirectory() != null) {
            DeviceLog.debug("Unity Ads cache directory check OK");
            return true;
        }
        DeviceLog.error("Unity Ads cache directory check fail: no working cache directory available");
        return false;
    }

    private static boolean hasJavascriptInterface(Method annotationArray) {
        if (Build.VERSION.SDK_INT < 17) {
            return true;
        }
        if ((annotationArray = annotationArray.getAnnotations()) != null) {
            int n2 = annotationArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!(annotationArray[i2] instanceof JavascriptInterface)) continue;
                return true;
            }
        }
        return false;
    }
}

