/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.core.configuration;

import android.content.SharedPreferences;
import com.unity3d.splash.services.core.configuration.IModuleConfiguration;
import com.unity3d.splash.services.core.properties.ClientProperties;
import com.unity3d.splash.services.core.properties.SdkProperties;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Configuration {
    private String _webViewUrl;
    private String _webViewHash;
    private String _webViewVersion;
    private String _webViewData;
    private String _url;
    private Map _moduleConfigurations;
    private String[] _moduleConfigurationList = new String[]{"com.unity3d.splash.services.core.configuration.CoreModuleConfiguration", "com.unity3d.splash.services.ads.configuration.AdsModuleConfiguration"};
    private Class[] _webAppApiClassList;

    public Configuration() {
    }

    public Configuration(String string) {
        this._url = string;
    }

    public void setConfigUrl(String string) {
        this._url = string;
    }

    public String getConfigUrl() {
        return this._url;
    }

    public Class[] getWebAppApiClassList() {
        if (this._webAppApiClassList == null) {
            this.createWebAppApiClassList();
        }
        return this._webAppApiClassList;
    }

    public String[] getModuleConfigurationList() {
        return this._moduleConfigurationList;
    }

    public String getWebViewUrl() {
        return this._webViewUrl;
    }

    public void setWebViewUrl(String string) {
        this._webViewUrl = string;
    }

    public String getWebViewHash() {
        return this._webViewHash;
    }

    public void setWebViewHash(String string) {
        this._webViewHash = string;
    }

    public String getWebViewVersion() {
        return this._webViewVersion;
    }

    public String getWebViewData() {
        return this._webViewData;
    }

    public void setWebViewData(String string) {
        this._webViewData = string;
    }

    public IModuleConfiguration getModuleConfiguration(String string) {
        if (this._moduleConfigurations != null && this._moduleConfigurations.containsKey(string)) {
            return (IModuleConfiguration)this._moduleConfigurations.get(string);
        }
        try {
            IModuleConfiguration iModuleConfiguration = (IModuleConfiguration)Class.forName(string).newInstance();
            if (iModuleConfiguration != null) {
                if (this._moduleConfigurations == null) {
                    this._moduleConfigurations = new HashMap();
                    this._moduleConfigurations.put(string, iModuleConfiguration);
                }
                return iModuleConfiguration;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String buildQueryString() {
        return "?ts=" + System.currentTimeMillis() + "&sdkVersion=" + SdkProperties.getVersionCode() + "&sdkVersionName=" + SdkProperties.getVersionName();
    }

    protected void makeRequest() {
        SharedPreferences sharedPreferences = ClientProperties.getApplicationContext().getSharedPreferences("game_detail", 0);
        this._webViewUrl = sharedPreferences.getString("url", null);
        this._webViewHash = sharedPreferences.getString("hash", null);
        this._webViewVersion = sharedPreferences.getString("version", null);
        if (this._webViewUrl == null || this._webViewUrl.isEmpty()) {
            throw new MalformedURLException("Invalid data. Web view URL is null or empty");
        }
    }

    private void createWebAppApiClassList() {
        ArrayList<Class> arrayList = new ArrayList<Class>();
        for (String string : this.getModuleConfigurationList()) {
            IModuleConfiguration object = this.getModuleConfiguration(string);
            if (object == null || object.getWebAppApiClassList() == null) continue;
            arrayList.addAll(Arrays.asList(object.getWebAppApiClassList()));
        }
        this._webAppApiClassList = arrayList.toArray(new Class[arrayList.size()]);
    }
}

