/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.core.api;

import com.unity3d.splash.services.core.configuration.InitializationNotificationCenter;
import com.unity3d.splash.services.core.configuration.InitializeThread;
import com.unity3d.splash.services.core.log.DeviceLog;
import com.unity3d.splash.services.core.properties.ClientProperties;
import com.unity3d.splash.services.core.properties.SdkProperties;
import com.unity3d.splash.services.core.webview.WebViewApp;
import com.unity3d.splash.services.core.webview.bridge.WebViewCallback;
import com.unity3d.splash.services.core.webview.bridge.WebViewExposed;
import java.util.Date;

public class Sdk {
    @WebViewExposed
    public static void loadComplete(WebViewCallback webViewCallback) {
        DeviceLog.info("Web Application loaded at " + new Date().getTime());
        WebViewApp.getCurrentApp().setWebAppLoaded(true);
        Object[] objectArray = new Object[]{ClientProperties.getGameId(), SdkProperties.isTestMode(), ClientProperties.getAppName(), ClientProperties.getAppVersion(), SdkProperties.getVersionCode(), SdkProperties.getVersionName(), ClientProperties.isAppDebuggable(), WebViewApp.getCurrentApp().getConfiguration().getConfigUrl(), WebViewApp.getCurrentApp().getConfiguration().getWebViewUrl(), WebViewApp.getCurrentApp().getConfiguration().getWebViewHash(), WebViewApp.getCurrentApp().getConfiguration().getWebViewVersion(), SdkProperties.getInitializationTime(), SdkProperties.isReinitialized(), SdkProperties.isPerPlacementLoadEnabled()};
        webViewCallback.invoke(objectArray);
    }

    @WebViewExposed
    public static void initComplete(WebViewCallback webViewCallback) {
        DeviceLog.info("Web Application initialized at " + new Date().getTime());
        SdkProperties.setInitialized(true);
        WebViewApp.getCurrentApp().setWebAppInitialized(true);
        InitializationNotificationCenter.getInstance().triggerOnSdkInitialized();
        webViewCallback.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void initError(String string, int n2, WebViewCallback webViewCallback) {
        InitializationNotificationCenter.getInstance().triggerOnSdkInitializationFailed(string, n2);
        webViewCallback.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void setDebugMode(Boolean bl, WebViewCallback webViewCallback) {
        SdkProperties.setDebugMode(bl);
        webViewCallback.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void getDebugMode(WebViewCallback webViewCallback) {
        webViewCallback.invoke(SdkProperties.getDebugMode());
    }

    @WebViewExposed
    public static void logError(String string, WebViewCallback webViewCallback) {
        DeviceLog.error(string);
        webViewCallback.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void logWarning(String string, WebViewCallback webViewCallback) {
        DeviceLog.warning(string);
        webViewCallback.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void logInfo(String string, WebViewCallback webViewCallback) {
        DeviceLog.info(string);
        webViewCallback.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void logDebug(String string, WebViewCallback webViewCallback) {
        DeviceLog.debug(string);
        webViewCallback.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void reinitialize(WebViewCallback webViewCallback) {
        SdkProperties.setReinitialized(true);
        InitializeThread.initialize(WebViewApp.getCurrentApp().getConfiguration());
    }
}

