/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.core.api;

import android.annotation.TargetApi;
import android.content.Context;
import com.unity3d.splash.services.ads.adunit.AdUnitError;
import com.unity3d.splash.services.ads.api.AdUnit;
import com.unity3d.splash.services.core.api.PermissionsError;
import com.unity3d.splash.services.core.device.DeviceError;
import com.unity3d.splash.services.core.properties.ClientProperties;
import com.unity3d.splash.services.core.webview.bridge.WebViewCallback;
import com.unity3d.splash.services.core.webview.bridge.WebViewExposed;
import java.util.ArrayList;
import org.json.JSONArray;

public class Permissions {
    @WebViewExposed
    public static void getPermissions(WebViewCallback webViewCallback) {
        if (ClientProperties.getApplicationContext() == null) {
            webViewCallback.error(DeviceError.APPLICATION_CONTEXT_NULL, new Object[0]);
            return;
        }
        try {
            JSONArray jSONArray = new JSONArray();
            String[] stringArray = ClientProperties.getApplicationContext();
            stringArray = stringArray.getPackageManager().getPackageInfo(stringArray.getPackageName(), 4096);
            if (stringArray.requestedPermissions != null) {
                stringArray = stringArray.requestedPermissions;
                int n2 = stringArray.requestedPermissions.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    String string = stringArray[i2];
                    jSONArray.put((Object)string);
                }
                webViewCallback.invoke(jSONArray);
                return;
            }
            webViewCallback.error(PermissionsError.NO_REQUESTED_PERMISSIONS, new Object[0]);
            return;
        }
        catch (Exception exception) {
            webViewCallback.error(PermissionsError.COULDNT_GET_PERMISSIONS, exception.getMessage());
            return;
        }
    }

    @WebViewExposed
    public static void checkPermission(String string, WebViewCallback webViewCallback) {
        if (ClientProperties.getApplicationContext() == null) {
            webViewCallback.error(DeviceError.APPLICATION_CONTEXT_NULL, new Object[0]);
            return;
        }
        try {
            Context context = ClientProperties.getApplicationContext();
            int n2 = context.getPackageManager().checkPermission(string, context.getPackageName());
            webViewCallback.invoke(n2);
            return;
        }
        catch (Exception exception) {
            webViewCallback.error(PermissionsError.ERROR_CHECKING_PERMISSION, exception.getMessage());
            return;
        }
    }

    @WebViewExposed
    @TargetApi(value=23)
    public static void requestPermissions(JSONArray jSONArray, Integer n2, WebViewCallback webViewCallback) {
        if (AdUnit.getAdUnitActivity() == null) {
            webViewCallback.error(AdUnitError.ADUNIT_NULL, new Object[0]);
            return;
        }
        if (jSONArray == null || jSONArray.length() <= 0) {
            webViewCallback.error(PermissionsError.NO_REQUESTED_PERMISSIONS, new Object[0]);
            return;
        }
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                arrayList.add(jSONArray.getString(i2));
            }
            String[] stringArray = new String[arrayList.size()];
            AdUnit.getAdUnitActivity().requestPermissions(arrayList.toArray(stringArray), n2);
            webViewCallback.invoke(new Object[0]);
            return;
        }
        catch (Exception exception) {
            webViewCallback.error(PermissionsError.ERROR_REQUESTING_PERMISSIONS, exception.getMessage());
            return;
        }
    }
}

