/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.core.api;

import android.app.Activity;
import android.net.Uri;
import com.unity3d.splash.services.core.log.DeviceLog;
import com.unity3d.splash.services.core.properties.ClientProperties;
import com.unity3d.splash.services.core.webview.bridge.WebViewCallback;
import com.unity3d.splash.services.core.webview.bridge.WebViewExposed;
import java.lang.ref.WeakReference;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Intent {
    private static WeakReference _activeActivity;

    @WebViewExposed
    public static void launch(JSONObject jSONObject, WebViewCallback webViewCallback) {
        String string = (String)jSONObject.opt("className");
        String string2 = (String)jSONObject.opt("packageName");
        String string3 = (String)jSONObject.opt("action");
        String string4 = (String)jSONObject.opt("uri");
        String string5 = (String)jSONObject.opt("mimeType");
        JSONArray jSONArray = (JSONArray)jSONObject.opt("categories");
        Integer n2 = (Integer)jSONObject.opt("flags");
        JSONArray jSONArray2 = (JSONArray)jSONObject.opt("extras");
        if (string2 != null && string == null && string3 == null && string5 == null) {
            jSONObject = ClientProperties.getApplicationContext().getPackageManager().getLaunchIntentForPackage(string2);
            if (jSONObject != null && n2 >= 0) {
                jSONObject.addFlags(n2.intValue());
            }
        } else {
            jSONObject = new android.content.Intent();
            if (string != null && string2 != null) {
                jSONObject.setClassName(string2, string);
            }
            if (string3 != null) {
                jSONObject.setAction(string3);
            }
            if (string4 != null && string5 != null) {
                jSONObject.setDataAndType(Uri.parse((String)string4), string5);
            } else if (string4 != null) {
                jSONObject.setData(Uri.parse((String)string4));
            } else if (string5 != null) {
                jSONObject.setType(string5);
            }
            if (n2 != null && n2 >= 0) {
                jSONObject.setFlags(n2.intValue());
            }
            if (!Intent.setCategories((android.content.Intent)jSONObject, jSONArray)) {
                webViewCallback.error(IntentError.COULDNT_PARSE_CATEGORIES, jSONArray);
            }
            if (!Intent.setExtras((android.content.Intent)jSONObject, jSONArray2)) {
                webViewCallback.error(IntentError.COULDNT_PARSE_EXTRAS, jSONArray2);
            }
        }
        if (jSONObject != null) {
            if (Intent.getStartingActivity() != null) {
                Intent.getStartingActivity().startActivity((android.content.Intent)jSONObject);
                webViewCallback.invoke(new Object[0]);
                return;
            }
            webViewCallback.error(IntentError.ACTIVITY_WAS_NULL, new Object[0]);
            return;
        }
        webViewCallback.error(IntentError.INTENT_WAS_NULL, new Object[0]);
    }

    private static boolean setCategories(android.content.Intent intent, JSONArray jSONArray) {
        if (jSONArray != null && jSONArray.length() > 0) {
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                try {
                    intent.addCategory(jSONArray.getString(i2));
                    continue;
                }
                catch (Exception exception) {
                    DeviceLog.exception("Couldn't parse categories for intent", exception);
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean setExtras(android.content.Intent intent, JSONArray jSONArray) {
        if (jSONArray != null) {
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                String string;
                Object object;
                try {
                    object = jSONArray.getJSONObject(i2);
                    string = object.getString("key");
                    object = object.get("value");
                }
                catch (Exception exception) {
                    DeviceLog.exception("Couldn't parse extras", exception);
                    return false;
                }
                if (Intent.setExtra(intent, string, object)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean setExtra(android.content.Intent intent, String string, Object object) {
        if (object instanceof String) {
            intent.putExtra(string, (String)object);
        } else if (object instanceof Integer) {
            intent.putExtra(string, ((Integer)object).intValue());
        } else if (object instanceof Double) {
            intent.putExtra(string, ((Double)object).doubleValue());
        } else if (object instanceof Boolean) {
            intent.putExtra(string, ((Boolean)object).booleanValue());
        } else {
            DeviceLog.error("Unable to parse launch intent extra " + string);
            return false;
        }
        return true;
    }

    private static Activity getStartingActivity() {
        Activity activity = null;
        if (_activeActivity != null && _activeActivity.get() != null) {
            activity = (Activity)_activeActivity.get();
        } else if (ClientProperties.getActivity() != null) {
            activity = ClientProperties.getActivity();
        }
        return activity;
    }

    public static void setActiveActivity(Activity activity) {
        if (activity == null) {
            _activeActivity = null;
            return;
        }
        _activeActivity = new WeakReference<Activity>(activity);
    }

    public static void removeActiveActivity(Activity activity) {
        if (_activeActivity != null && _activeActivity.get() != null && activity != null && activity.equals(_activeActivity.get())) {
            _activeActivity = null;
        }
    }

    @WebViewExposed
    public static void canOpenIntent(JSONObject jSONObject, WebViewCallback webViewCallback) {
        try {
            boolean bl = Intent.checkIntentResolvable(Intent.intentFromMetadata(jSONObject));
            webViewCallback.invoke(bl);
            return;
        }
        catch (IntentException intentException) {
            DeviceLog.exception("Couldn't resolve intent", intentException);
            webViewCallback.error(intentException.getError(), intentException.getField());
            return;
        }
    }

    @WebViewExposed
    public static void canOpenIntents(JSONArray jSONArray, WebViewCallback webViewCallback) {
        JSONObject jSONObject = new JSONObject();
        int n2 = jSONArray.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            JSONObject jSONObject2 = jSONArray.optJSONObject(i2);
            String string = jSONObject2.optString("id");
            try {
                boolean bl = Intent.checkIntentResolvable(Intent.intentFromMetadata(jSONObject2));
                jSONObject.put(string, bl);
                continue;
            }
            catch (IntentException intentException) {
                DeviceLog.exception("Exception parsing intent", intentException);
                webViewCallback.error(intentException.getError(), intentException.getField());
                return;
            }
            catch (JSONException jSONException) {
                webViewCallback.error(IntentError.JSON_EXCEPTION, jSONException.getMessage());
                return;
            }
        }
        webViewCallback.invoke(jSONObject);
    }

    private static boolean checkIntentResolvable(android.content.Intent intent) {
        return ClientProperties.getApplicationContext().getPackageManager().resolveActivity(intent, 0) != null;
    }

    private static android.content.Intent intentFromMetadata(JSONObject jSONObject) {
        String string = (String)jSONObject.opt("className");
        String string2 = (String)jSONObject.opt("packageName");
        String string3 = (String)jSONObject.opt("action");
        String string4 = (String)jSONObject.opt("uri");
        String string5 = (String)jSONObject.opt("mimeType");
        JSONArray jSONArray = (JSONArray)jSONObject.opt("categories");
        Integer n2 = (Integer)jSONObject.opt("flags");
        JSONArray jSONArray2 = (JSONArray)jSONObject.opt("extras");
        if (string2 != null && string == null && string3 == null && string5 == null) {
            jSONObject = ClientProperties.getApplicationContext().getPackageManager().getLaunchIntentForPackage(string2);
            if (jSONObject != null && n2 >= 0) {
                jSONObject.addFlags(n2.intValue());
            }
        } else {
            jSONObject = new android.content.Intent();
            if (string != null && string2 != null) {
                jSONObject.setClassName(string2, string);
            }
            if (string3 != null) {
                jSONObject.setAction(string3);
            }
            if (string4 != null) {
                jSONObject.setData(Uri.parse((String)string4));
            }
            if (string5 != null) {
                jSONObject.setType(string5);
            }
            if (n2 != null && n2 >= 0) {
                jSONObject.setFlags(n2.intValue());
            }
            if (!Intent.setCategories((android.content.Intent)jSONObject, jSONArray)) {
                throw new IntentException(IntentError.COULDNT_PARSE_CATEGORIES, jSONArray);
            }
            if (!Intent.setExtras((android.content.Intent)jSONObject, jSONArray2)) {
                throw new IntentException(IntentError.COULDNT_PARSE_EXTRAS, jSONArray2);
            }
        }
        return jSONObject;
    }

    private static class IntentException
    extends Exception {
        private IntentError error;
        private Object field;

        public IntentException(IntentError intentError, Object object) {
            this.error = intentError;
            this.field = object;
        }

        public IntentError getError() {
            return this.error;
        }

        public Object getField() {
            return this.field;
        }
    }

    public static enum IntentError {
        COULDNT_PARSE_EXTRAS,
        COULDNT_PARSE_CATEGORIES,
        INTENT_WAS_NULL,
        JSON_EXCEPTION,
        ACTIVITY_WAS_NULL;

    }
}

