/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.core.api;

import android.annotation.SuppressLint;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.hardware.Sensor;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.SparseArray;
import com.unity3d.splash.services.core.api.PermissionsError;
import com.unity3d.splash.services.core.device.Device;
import com.unity3d.splash.services.core.device.DeviceError;
import com.unity3d.splash.services.core.device.IVolumeChangeListener;
import com.unity3d.splash.services.core.device.VolumeChange;
import com.unity3d.splash.services.core.log.DeviceLog;
import com.unity3d.splash.services.core.properties.ClientProperties;
import com.unity3d.splash.services.core.webview.WebViewApp;
import com.unity3d.splash.services.core.webview.WebViewEventCategory;
import com.unity3d.splash.services.core.webview.bridge.WebViewCallback;
import com.unity3d.splash.services.core.webview.bridge.WebViewExposed;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DeviceInfo {
    private static SparseArray _volumeChangeListeners;

    @WebViewExposed
    public static void getAndroidId(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.getAndroidId());
    }

    @WebViewExposed
    public static void getAdvertisingTrackingId(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.getAdvertisingTrackingId());
    }

    @WebViewExposed
    public static void getLimitAdTrackingFlag(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.isLimitAdTrackingEnabled());
    }

    @WebViewExposed
    public static void getOpenAdvertisingTrackingId(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.getOpenAdvertisingTrackingId());
    }

    @WebViewExposed
    public static void getLimitOpenAdTrackingFlag(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.isLimitOpenAdTrackingEnabled());
    }

    @WebViewExposed
    public static void getApiLevel(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.getApiLevel());
    }

    @WebViewExposed
    public static void getOsVersion(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.getOsVersion());
    }

    @WebViewExposed
    public static void getManufacturer(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.getManufacturer());
    }

    @WebViewExposed
    public static void getModel(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.getModel());
    }

    @WebViewExposed
    public static void getScreenLayout(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.getScreenLayout());
    }

    @WebViewExposed
    public static void getScreenDensity(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.getScreenDensity());
    }

    @WebViewExposed
    public static void getScreenWidth(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.getScreenWidth());
    }

    @WebViewExposed
    public static void getScreenHeight(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.getScreenHeight());
    }

    @WebViewExposed
    public static void getTimeZone(Boolean bl, WebViewCallback webViewCallback) {
        webViewCallback.invoke(TimeZone.getDefault().getDisplayName(bl, 0, Locale.US));
    }

    @WebViewExposed
    public static void getTimeZoneOffset(WebViewCallback webViewCallback) {
        webViewCallback.invoke(TimeZone.getDefault().getOffset(System.currentTimeMillis()) / 1000);
    }

    @WebViewExposed
    public static void getConnectionType(WebViewCallback webViewCallback) {
        String string = Device.isUsingWifi() ? "wifi" : (Device.isActiveNetworkConnected() ? "cellular" : "none");
        webViewCallback.invoke(string);
    }

    @WebViewExposed
    public static void getNetworkType(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.getNetworkType());
    }

    @WebViewExposed
    public static void getNetworkMetered(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.getNetworkMetered());
    }

    @WebViewExposed
    public static void getNetworkOperator(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.getNetworkOperator());
    }

    @WebViewExposed
    public static void getNetworkOperatorName(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.getNetworkOperatorName());
    }

    @WebViewExposed
    public static void getNetworkCountryISO(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.getNetworkCountryISO());
    }

    @WebViewExposed
    public static void isAppInstalled(String string, WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.isAppInstalled(string));
    }

    @WebViewExposed
    public static void isRooted(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.isRooted());
    }

    @WebViewExposed
    public static void isAdbEnabled(WebViewCallback webViewCallback) {
        Boolean bl = Device.isAdbEnabled();
        if (bl != null) {
            webViewCallback.invoke(bl);
            return;
        }
        webViewCallback.error(DeviceError.COULDNT_GET_ADB_STATUS, new Object[0]);
    }

    @WebViewExposed
    public static void getInstalledPackages(boolean bl, WebViewCallback webViewCallback) {
        List list = Device.getInstalledPackages(bl);
        list = new JSONArray((Collection)list);
        webViewCallback.invoke(list);
    }

    @WebViewExposed
    public static void getPackageInfo(String string, WebViewCallback webViewCallback) {
        if (ClientProperties.getApplicationContext() != null) {
            PackageInfo packageInfo;
            PackageManager packageManager = ClientProperties.getApplicationContext().getPackageManager();
            try {
                packageInfo = packageManager.getPackageInfo(string, 0);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                webViewCallback.error(DeviceError.APPLICATION_INFO_NOT_AVAILABLE, string);
                return;
            }
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("installer", (Object)packageManager.getInstallerPackageName(string));
                jSONObject.put("firstInstallTime", packageInfo.firstInstallTime);
                jSONObject.put("lastUpdateTime", packageInfo.lastUpdateTime);
                jSONObject.put("versionCode", packageInfo.versionCode);
                jSONObject.put("versionName", (Object)packageInfo.versionName);
                jSONObject.put("packageName", (Object)packageInfo.packageName);
            }
            catch (JSONException jSONException) {
                webViewCallback.error(DeviceError.JSON_ERROR, jSONException.getMessage());
                return;
            }
            webViewCallback.invoke(jSONObject);
            return;
        }
        webViewCallback.error(DeviceError.APPLICATION_CONTEXT_NULL, new Object[0]);
    }

    @WebViewExposed
    public static void getUniqueEventId(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.getUniqueEventId());
    }

    @WebViewExposed
    public static void getHeadset(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.isWiredHeadsetOn());
    }

    @WebViewExposed
    public static void getSystemProperty(String string, String string2, WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.getSystemProperty(string, string2));
    }

    @WebViewExposed
    public static void getRingerMode(WebViewCallback webViewCallback) {
        int n2 = Device.getRingerMode();
        if (n2 >= 0) {
            webViewCallback.invoke(n2);
            return;
        }
        switch (n2) {
            case -1: {
                webViewCallback.error(DeviceError.APPLICATION_CONTEXT_NULL, n2);
                return;
            }
            case -2: {
                webViewCallback.error(DeviceError.AUDIOMANAGER_NULL, n2);
                return;
            }
        }
        DeviceLog.error("Unhandled ringerMode error: " + n2);
    }

    @WebViewExposed
    public static void getSystemLanguage(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Locale.getDefault().toString());
    }

    @WebViewExposed
    public static void getDeviceVolume(Integer n2, WebViewCallback webViewCallback) {
        int n3 = Device.getStreamVolume(n2);
        if (n3 >= 0) {
            webViewCallback.invoke(n3);
            return;
        }
        switch (n3) {
            case -1: {
                webViewCallback.error(DeviceError.APPLICATION_CONTEXT_NULL, n3);
                return;
            }
            case -2: {
                webViewCallback.error(DeviceError.AUDIOMANAGER_NULL, n3);
                return;
            }
        }
        DeviceLog.error("Unhandled deviceVolume error: " + n3);
    }

    @WebViewExposed
    public static void getDeviceMaxVolume(Integer n2, WebViewCallback webViewCallback) {
        int n3 = Device.getStreamMaxVolume(n2);
        if (n3 >= 0) {
            webViewCallback.invoke(n3);
            return;
        }
        switch (n3) {
            case -1: {
                webViewCallback.error(DeviceError.APPLICATION_CONTEXT_NULL, n3);
                return;
            }
            case -2: {
                webViewCallback.error(DeviceError.AUDIOMANAGER_NULL, n3);
                return;
            }
        }
        DeviceLog.error("Unhandled deviceMaxVolume error: " + n3);
    }

    @WebViewExposed
    public static void registerVolumeChangeListener(final Integer n2, WebViewCallback webViewCallback) {
        if (_volumeChangeListeners == null) {
            _volumeChangeListeners = new SparseArray();
        }
        if (_volumeChangeListeners.get(n2.intValue()) == null) {
            IVolumeChangeListener iVolumeChangeListener = new IVolumeChangeListener(){
                private int _streamType;
                {
                    this._streamType = n2;
                }

                @Override
                public final void onVolumeChanged(int n22) {
                    WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.DEVICEINFO, DeviceInfoEvent.VOLUME_CHANGED, this.getStreamType(), n22, Device.getStreamMaxVolume(this._streamType));
                }

                @Override
                public final int getStreamType() {
                    return this._streamType;
                }
            };
            _volumeChangeListeners.append(n2.intValue(), (Object)iVolumeChangeListener);
            VolumeChange.registerListener(iVolumeChangeListener);
        }
        webViewCallback.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void unregisterVolumeChangeListener(Integer n2, WebViewCallback webViewCallback) {
        if (_volumeChangeListeners != null && _volumeChangeListeners.get(n2.intValue()) != null) {
            VolumeChange.unregisterListener((IVolumeChangeListener)_volumeChangeListeners.get(n2.intValue()));
            _volumeChangeListeners.remove(n2.intValue());
        }
        webViewCallback.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void getScreenBrightness(WebViewCallback webViewCallback) {
        int n2 = Device.getScreenBrightness();
        if (n2 >= 0) {
            webViewCallback.invoke(n2);
            return;
        }
        switch (n2) {
            case -1: {
                webViewCallback.error(DeviceError.APPLICATION_CONTEXT_NULL, n2);
                return;
            }
        }
        DeviceLog.error("Unhandled screenBrightness error: " + n2);
    }

    private static StorageType getStorageTypeFromString(String string) {
        StorageType storageType;
        try {
            storageType = StorageType.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DeviceLog.exception("Illegal argument: " + string, illegalArgumentException);
            return null;
        }
        return storageType;
    }

    private static File getFileForStorageType(StorageType storageType) {
        switch (storageType) {
            case INTERNAL: {
                return ClientProperties.getApplicationContext().getCacheDir();
            }
            case EXTERNAL: {
                return ClientProperties.getApplicationContext().getExternalCacheDir();
            }
        }
        DeviceLog.error("Unhandled storagetype: " + (Object)((Object)storageType));
        return null;
    }

    @WebViewExposed
    public static void getFreeSpace(String string, WebViewCallback webViewCallback) {
        StorageType storageType = DeviceInfo.getStorageTypeFromString(string);
        if (storageType == null) {
            webViewCallback.error(DeviceError.INVALID_STORAGETYPE, string);
            return;
        }
        long l2 = Device.getFreeSpace(DeviceInfo.getFileForStorageType(storageType));
        if (l2 > -1L) {
            webViewCallback.invoke(l2);
            return;
        }
        webViewCallback.error(DeviceError.COULDNT_GET_STORAGE_LOCATION, l2);
    }

    @WebViewExposed
    public static void getTotalSpace(String string, WebViewCallback webViewCallback) {
        StorageType storageType = DeviceInfo.getStorageTypeFromString(string);
        if (storageType == null) {
            webViewCallback.error(DeviceError.INVALID_STORAGETYPE, string);
            return;
        }
        long l2 = Device.getTotalSpace(DeviceInfo.getFileForStorageType(storageType));
        if (l2 > -1L) {
            webViewCallback.invoke(l2);
            return;
        }
        webViewCallback.error(DeviceError.COULDNT_GET_STORAGE_LOCATION, l2);
    }

    @WebViewExposed
    public static void getBatteryLevel(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Float.valueOf(Device.getBatteryLevel()));
    }

    @WebViewExposed
    public static void getBatteryStatus(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.getBatteryStatus());
    }

    @WebViewExposed
    public static void getFreeMemory(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.getFreeMemory());
    }

    @WebViewExposed
    public static void getTotalMemory(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.getTotalMemory());
    }

    @WebViewExposed
    public static void getApkDigest(WebViewCallback webViewCallback) {
        try {
            webViewCallback.invoke(Device.getApkDigest());
            return;
        }
        catch (Exception exception) {
            webViewCallback.error(DeviceError.COULDNT_GET_DIGEST, exception.toString());
            return;
        }
    }

    @WebViewExposed
    public static void getCertificateFingerprint(WebViewCallback webViewCallback) {
        String string = Device.getCertificateFingerprint();
        if (string != null) {
            webViewCallback.invoke(string);
            return;
        }
        webViewCallback.error(DeviceError.COULDNT_GET_FINGERPRINT, new Object[0]);
    }

    @WebViewExposed
    public static void getBoard(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.getBoard());
    }

    @WebViewExposed
    public static void getBootloader(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.getBootloader());
    }

    @WebViewExposed
    public static void getBrand(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.getBrand());
    }

    @WebViewExposed
    public static void getDevice(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.getDevice());
    }

    @WebViewExposed
    public static void getHardware(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.getHardware());
    }

    @WebViewExposed
    public static void getHost(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.getHost());
    }

    @WebViewExposed
    public static void getProduct(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.getProduct());
    }

    @WebViewExposed
    public static void getFingerprint(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.getFingerprint());
    }

    @WebViewExposed
    public static void getSupportedAbis(WebViewCallback webViewCallback) {
        JSONArray jSONArray = new JSONArray();
        for (String string : Device.getSupportedAbis()) {
            jSONArray.put((Object)string);
        }
        webViewCallback.invoke(jSONArray);
    }

    @WebViewExposed
    public static void getSensorList(WebViewCallback webViewCallback) {
        JSONArray jSONArray = new JSONArray();
        Object object = Device.getSensorList();
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                Sensor sensor = (Sensor)object.next();
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("name", (Object)sensor.getName());
                    jSONObject.put("type", sensor.getType());
                    jSONObject.put("vendor", (Object)sensor.getVendor());
                    jSONObject.put("maximumRange", (double)sensor.getMaximumRange());
                    jSONObject.put("power", (double)sensor.getPower());
                    jSONObject.put("version", sensor.getVersion());
                    jSONObject.put("resolution", (double)sensor.getResolution());
                    jSONObject.put("minDelay", sensor.getMinDelay());
                }
                catch (JSONException jSONException) {
                    webViewCallback.error(DeviceError.JSON_ERROR, jSONException.getMessage());
                    return;
                }
                jSONArray.put((Object)jSONObject);
            }
        }
        webViewCallback.invoke(jSONArray);
    }

    @WebViewExposed
    public static void getProcessInfo(WebViewCallback webViewCallback) {
        JSONObject jSONObject = new JSONObject();
        Map map = Device.getProcessInfo();
        if (map != null) {
            try {
                if (map.containsKey("stat")) {
                    jSONObject.put("stat", map.get("stat"));
                }
                if (map.containsKey("uptime")) {
                    jSONObject.put("uptime", map.get("uptime"));
                }
            }
            catch (Exception exception) {
                DeviceLog.exception("Error while constructing process info", exception);
            }
        }
        webViewCallback.invoke(jSONObject);
    }

    @WebViewExposed
    public static void isUSBConnected(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.isUSBConnected());
    }

    @WebViewExposed
    public static void getCPUCount(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.getCPUCount());
    }

    @WebViewExposed
    public static void getUptime(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.getUptime());
    }

    @WebViewExposed
    public static void getElapsedRealtime(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.getElapsedRealtime());
    }

    @WebViewExposed
    public static void getBuildId(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.getBuildId());
    }

    @WebViewExposed
    public static void getBuildVersionIncremental(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.getBuildVersionIncremental());
    }

    @WebViewExposed
    @SuppressLint(value={"MissingPermission"})
    public static void getDeviceIdWithSlot(Integer n2, WebViewCallback webViewCallback) {
        DeviceInfo.getDeviceIdCommon(n2, webViewCallback);
    }

    @WebViewExposed
    public static void getDeviceId(WebViewCallback webViewCallback) {
        DeviceInfo.getDeviceIdCommon(null, webViewCallback);
    }

    @SuppressLint(value={"MissingPermission"})
    private static void getDeviceIdCommon(Integer n2, WebViewCallback webViewCallback) {
        if (ClientProperties.getApplicationContext() == null) {
            webViewCallback.error(DeviceError.APPLICATION_CONTEXT_NULL, new Object[0]);
            return;
        }
        if (ClientProperties.getApplicationContext().checkCallingOrSelfPermission("android.permission.READ_PHONE_STATE") != 0) {
            webViewCallback.error(PermissionsError.PERMISSION_NOT_GRANTED, new Object[0]);
            return;
        }
        TelephonyManager telephonyManager = (TelephonyManager)ClientProperties.getApplicationContext().getSystemService("phone");
        if (telephonyManager != null) {
            if (Build.VERSION.SDK_INT >= 26) {
                if (n2 == null) {
                    webViewCallback.invoke(telephonyManager.getImei());
                    return;
                }
                webViewCallback.invoke(telephonyManager.getImei(n2.intValue()));
                return;
            }
            if (Build.VERSION.SDK_INT >= 23) {
                if (n2 == null) {
                    webViewCallback.invoke(telephonyManager.getDeviceId());
                    return;
                }
                webViewCallback.invoke(telephonyManager.getDeviceId(n2.intValue()));
                return;
            }
            if (n2 == null) {
                webViewCallback.invoke(telephonyManager.getDeviceId());
                return;
            }
            webViewCallback.error(DeviceError.API_LEVEL_ERROR, Build.VERSION.SDK_INT);
        }
    }

    public static enum DeviceInfoEvent {
        VOLUME_CHANGED;

    }

    public static enum StorageType {
        EXTERNAL,
        INTERNAL;

    }
}

