/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.core.api;

import android.annotation.TargetApi;
import android.media.MediaMetadataRetriever;
import android.util.Base64;
import android.util.SparseArray;
import com.unity3d.splash.services.core.api.Request;
import com.unity3d.splash.services.core.cache.CacheDirectory;
import com.unity3d.splash.services.core.cache.CacheError;
import com.unity3d.splash.services.core.cache.CacheThread;
import com.unity3d.splash.services.core.device.Device;
import com.unity3d.splash.services.core.log.DeviceLog;
import com.unity3d.splash.services.core.misc.Utilities;
import com.unity3d.splash.services.core.properties.ClientProperties;
import com.unity3d.splash.services.core.properties.SdkProperties;
import com.unity3d.splash.services.core.request.WebRequestError;
import com.unity3d.splash.services.core.webview.bridge.WebViewCallback;
import com.unity3d.splash.services.core.webview.bridge.WebViewExposed;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Cache {
    @WebViewExposed
    public static void download(String string, String string2, JSONArray object, Boolean bl, WebViewCallback webViewCallback) {
        if (CacheThread.isActive()) {
            webViewCallback.error(CacheError.FILE_ALREADY_CACHING, new Object[0]);
            return;
        }
        if (!Device.isActiveNetworkConnected()) {
            webViewCallback.error(CacheError.NO_INTERNET, new Object[0]);
            return;
        }
        try {
            object = Request.getHeadersMap(object);
        }
        catch (Exception exception) {
            DeviceLog.exception("Error mapping headers for the request", exception);
            webViewCallback.error(WebRequestError.MAPPING_HEADERS_FAILED, string, string2);
            return;
        }
        CacheThread.download(string, Cache.fileIdToFilename(string2), (HashMap)object, bl);
        webViewCallback.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void stop(WebViewCallback webViewCallback) {
        if (!CacheThread.isActive()) {
            webViewCallback.error(CacheError.NOT_CACHING, new Object[0]);
            return;
        }
        CacheThread.cancel();
        webViewCallback.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void isCaching(WebViewCallback webViewCallback) {
        webViewCallback.invoke(CacheThread.isActive());
    }

    @WebViewExposed
    public static void getFileContent(String object, String string, WebViewCallback webViewCallback) {
        String string2 = Cache.fileIdToFilename((String)object);
        Object object2 = new File(string2);
        if (!((File)object2).exists()) {
            webViewCallback.error(CacheError.FILE_NOT_FOUND, object, string2);
            return;
        }
        try {
            object2 = Utilities.readFileBytes((File)object2);
        }
        catch (IOException iOException) {
            webViewCallback.error(CacheError.FILE_IO_ERROR, object, string2, iOException.getMessage() + ", " + iOException.getClass().getName());
            return;
        }
        if (string == null) {
            webViewCallback.error(CacheError.UNSUPPORTED_ENCODING, object, string2, string);
            return;
        }
        if (string.equals("UTF-8")) {
            object = ByteBuffer.wrap((byte[])object2);
            string = Charset.forName("UTF-8").decode((ByteBuffer)object).toString();
        } else if (string.equals("Base64")) {
            string = Base64.encodeToString((byte[])object2, (int)2);
        } else {
            webViewCallback.error(CacheError.UNSUPPORTED_ENCODING, object, string2, string);
            return;
        }
        webViewCallback.invoke(string);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WebViewExposed
    public static void setFileContent(String string, String string2, String string3, WebViewCallback webViewCallback) {
        boolean bl;
        block22: {
            byte[] byArray;
            String string4 = Cache.fileIdToFilename(string);
            FileOutputStream fileOutputStream = null;
            bl = false;
            try {
                byArray = string3.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                webViewCallback.error(CacheError.UNSUPPORTED_ENCODING, string, string4, string2);
                return;
            }
            if (string2 != null && string2.length() > 0) {
                if (string2.equals("Base64")) {
                    byArray = Base64.decode((String)string3, (int)2);
                } else if (!string2.equals("UTF-8")) {
                    webViewCallback.error(CacheError.UNSUPPORTED_ENCODING, string, string4, string2);
                    return;
                }
            }
            try {
                fileOutputStream = new FileOutputStream(string4);
                fileOutputStream.write(byArray);
                fileOutputStream.flush();
                bl = true;
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    DeviceLog.exception("Error closing FileOutputStream", exception);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                webViewCallback.error(CacheError.FILE_NOT_FOUND, string, string4, string2);
                break block22;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    webViewCallback.error(CacheError.FILE_IO_ERROR, string, string4, string2);
                }
            }
            finally {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (Exception exception) {
                    DeviceLog.exception("Error closing FileOutputStream", exception);
                }
            }
        }
        if (!bl) return;
        webViewCallback.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void getFiles(WebViewCallback webViewCallback) {
        File[] fileArray = SdkProperties.getCacheDirectory();
        if (fileArray == null) {
            return;
        }
        DeviceLog.debug("Unity Ads cache: checking app directory for Unity Ads cached files");
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public final boolean accept(File file, String string) {
                return string.startsWith(SdkProperties.getCacheFilePrefix());
            }
        };
        fileArray = fileArray.listFiles(filenameFilter);
        if (fileArray == null || fileArray.length == 0) {
            webViewCallback.invoke(new JSONArray());
        }
        try {
            filenameFilter = new JSONArray();
            for (File file : fileArray) {
                String string = file.getName().substring(SdkProperties.getCacheFilePrefix().length());
                DeviceLog.debug("Unity Ads cache: found " + string + ", " + file.length() + " bytes");
                filenameFilter.put(Cache.getFileJson(string));
            }
            webViewCallback.invoke(filenameFilter);
            return;
        }
        catch (JSONException jSONException) {
            DeviceLog.exception("Error creating JSON", (Exception)((Object)jSONException));
            webViewCallback.error(CacheError.JSON_ERROR, new Object[0]);
            return;
        }
    }

    @WebViewExposed
    public static void getFileInfo(String string, WebViewCallback webViewCallback) {
        try {
            string = Cache.getFileJson(string);
            webViewCallback.invoke(string);
            return;
        }
        catch (JSONException jSONException) {
            DeviceLog.exception("Error creating JSON", (Exception)((Object)jSONException));
            webViewCallback.error(CacheError.JSON_ERROR, new Object[0]);
            return;
        }
    }

    @WebViewExposed
    public static void getFilePath(String string, WebViewCallback webViewCallback) {
        if (new File(Cache.fileIdToFilename(string)).exists()) {
            webViewCallback.invoke(Cache.fileIdToFilename(string));
            return;
        }
        webViewCallback.error(CacheError.FILE_NOT_FOUND, new Object[0]);
    }

    @WebViewExposed
    public static void deleteFile(String string, WebViewCallback webViewCallback) {
        if (new File(Cache.fileIdToFilename(string)).delete()) {
            webViewCallback.invoke(new Object[0]);
            return;
        }
        webViewCallback.error(CacheError.FILE_IO_ERROR, new Object[0]);
    }

    @WebViewExposed
    public static void getHash(String string, WebViewCallback webViewCallback) {
        webViewCallback.invoke(Utilities.Sha256(string));
    }

    @WebViewExposed
    public static void setTimeouts(Integer n2, Integer n3, WebViewCallback webViewCallback) {
        CacheThread.setConnectTimeout(n2);
        CacheThread.setReadTimeout(n3);
        webViewCallback.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void getTimeouts(WebViewCallback webViewCallback) {
        webViewCallback.invoke(CacheThread.getConnectTimeout(), CacheThread.getReadTimeout());
    }

    @WebViewExposed
    public static void setProgressInterval(Integer n2, WebViewCallback webViewCallback) {
        CacheThread.setProgressInterval(n2);
        webViewCallback.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void getProgressInterval(WebViewCallback webViewCallback) {
        webViewCallback.invoke(CacheThread.getProgressInterval());
    }

    @WebViewExposed
    public static void getFreeSpace(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.getFreeSpace(SdkProperties.getCacheDirectory()));
    }

    @WebViewExposed
    public static void getTotalSpace(WebViewCallback webViewCallback) {
        webViewCallback.invoke(Device.getTotalSpace(SdkProperties.getCacheDirectory()));
    }

    @WebViewExposed
    public static void getMetaData(String string, JSONArray jSONArray, WebViewCallback webViewCallback) {
        string = Cache.fileIdToFilename(string);
        try {
            string = Cache.getMetaData(string, jSONArray);
        }
        catch (JSONException jSONException) {
            webViewCallback.error(CacheError.JSON_ERROR, jSONException.getMessage());
            return;
        }
        catch (RuntimeException runtimeException) {
            webViewCallback.error(CacheError.INVALID_ARGUMENT, runtimeException.getMessage());
            return;
        }
        catch (IOException iOException) {
            webViewCallback.error(CacheError.FILE_IO_ERROR, iOException.getMessage());
            return;
        }
        jSONArray = new JSONArray();
        for (int i2 = 0; i2 < string.size(); ++i2) {
            JSONArray jSONArray2 = new JSONArray();
            jSONArray2.put(string.keyAt(i2));
            jSONArray2.put(string.valueAt(i2));
            jSONArray.put((Object)jSONArray2);
        }
        webViewCallback.invoke(jSONArray);
    }

    @WebViewExposed
    public static void getCacheDirectoryType(WebViewCallback webViewCallback) {
        Object object = SdkProperties.getCacheDirectoryObject();
        if (object == null || ((CacheDirectory)object).getCacheDirectory(ClientProperties.getApplicationContext()) == null) {
            webViewCallback.error(CacheError.CACHE_DIRECTORY_NULL, new Object[0]);
            return;
        }
        if (!((CacheDirectory)object).getCacheDirectory(ClientProperties.getApplicationContext()).exists()) {
            webViewCallback.error(CacheError.CACHE_DIRECTORY_DOESNT_EXIST, new Object[0]);
            return;
        }
        if ((object = ((CacheDirectory)object).getType()) == null) {
            webViewCallback.error(CacheError.CACHE_DIRECTORY_TYPE_NULL, new Object[0]);
            return;
        }
        webViewCallback.invoke(((Enum)object).name());
    }

    @WebViewExposed
    public static void getCacheDirectoryExists(WebViewCallback webViewCallback) {
        File file = SdkProperties.getCacheDirectory();
        if (file == null) {
            webViewCallback.error(CacheError.CACHE_DIRECTORY_NULL, new Object[0]);
            return;
        }
        webViewCallback.invoke(file.exists());
    }

    @WebViewExposed
    public static void recreateCacheDirectory(WebViewCallback webViewCallback) {
        if (SdkProperties.getCacheDirectory().exists()) {
            webViewCallback.error(CacheError.CACHE_DIRECTORY_EXISTS, new Object[0]);
            return;
        }
        SdkProperties.setCacheDirectory(null);
        if (SdkProperties.getCacheDirectory() == null) {
            webViewCallback.error(CacheError.CACHE_DIRECTORY_NULL, new Object[0]);
            return;
        }
        webViewCallback.invoke(new Object[0]);
    }

    @TargetApi(value=10)
    private static SparseArray getMetaData(String object, JSONArray jSONArray) {
        object = new File((String)object);
        SparseArray sparseArray = new SparseArray();
        if (((File)object).exists()) {
            MediaMetadataRetriever mediaMetadataRetriever = new MediaMetadataRetriever();
            mediaMetadataRetriever.setDataSource(((File)object).getAbsolutePath());
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                int n2 = jSONArray.getInt(i2);
                String string = mediaMetadataRetriever.extractMetadata(n2);
                if (string == null) continue;
                sparseArray.put(n2, (Object)string);
            }
        } else {
            throw new IOException("File: " + ((File)object).getAbsolutePath() + " doesn't exist");
        }
        return sparseArray;
    }

    private static String fileIdToFilename(String string) {
        return SdkProperties.getCacheDirectory() + "/" + SdkProperties.getCacheFilePrefix() + string;
    }

    private static JSONObject getFileJson(String object) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("id", object);
        object = new File(Cache.fileIdToFilename((String)object));
        if (((File)object).exists()) {
            jSONObject.put("found", true);
            jSONObject.put("size", ((File)object).length());
            jSONObject.put("mtime", ((File)object).lastModified());
        } else {
            jSONObject.put("found", false);
        }
        return jSONObject;
    }
}

