/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.ads.video;

import android.content.Context;
import android.media.MediaPlayer;
import android.os.Build;
import android.widget.VideoView;
import com.unity3d.splash.services.ads.video.VideoPlayerEvent;
import com.unity3d.splash.services.core.log.DeviceLog;
import com.unity3d.splash.services.core.webview.WebViewApp;
import com.unity3d.splash.services.core.webview.WebViewEventCategory;
import java.util.Timer;
import java.util.TimerTask;

public class VideoPlayerView
extends VideoView {
    private String _videoUrl;
    private Timer _videoTimer;
    private Timer _prepareTimer;
    private int _progressEventInterval = 500;
    private MediaPlayer _mediaPlayer = null;
    private Float _volume = null;
    private boolean _infoListenerEnabled = true;

    public VideoPlayerView(Context context) {
        super(context);
    }

    private void startVideoProgressTimer() {
        this._videoTimer = new Timer();
        this._videoTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                boolean bl = false;
                try {
                    bl = VideoPlayerView.this.isPlaying();
                    WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.VIDEOPLAYER, VideoPlayerEvent.PROGRESS, VideoPlayerView.this.getCurrentPosition());
                    return;
                }
                catch (IllegalStateException illegalStateException) {
                    DeviceLog.exception("Exception while sending current position to webapp", illegalStateException);
                    WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.VIDEOPLAYER, VideoPlayerEvent.ILLEGAL_STATE, new Object[]{VideoPlayerEvent.PROGRESS, VideoPlayerView.this._videoUrl, bl});
                    return;
                }
            }
        }, this._progressEventInterval, (long)this._progressEventInterval);
    }

    public void stopVideoProgressTimer() {
        if (this._videoTimer != null) {
            this._videoTimer.cancel();
            this._videoTimer.purge();
            this._videoTimer = null;
        }
    }

    private void startPrepareTimer(long l2) {
        this._prepareTimer = new Timer();
        this._prepareTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (!VideoPlayerView.this.isPlaying()) {
                    WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.VIDEOPLAYER, VideoPlayerEvent.PREPARE_TIMEOUT, VideoPlayerView.this._videoUrl);
                    DeviceLog.error("Video player prepare timeout: " + VideoPlayerView.this._videoUrl);
                }
            }
        }, l2);
    }

    public void stopPrepareTimer() {
        if (this._prepareTimer != null) {
            this._prepareTimer.cancel();
            this._prepareTimer.purge();
            this._prepareTimer = null;
        }
    }

    public boolean prepare(String string, final float f2, int n2) {
        DeviceLog.entered();
        this._videoUrl = string;
        this.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mediaPlayer) {
                VideoPlayerView.this.stopPrepareTimer();
                if (mediaPlayer != null) {
                    VideoPlayerView.this._mediaPlayer = mediaPlayer;
                }
                VideoPlayerView.this.setVolume(Float.valueOf(f2));
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.VIDEOPLAYER, VideoPlayerEvent.PREPARED, VideoPlayerView.this._videoUrl, mediaPlayer.getDuration(), mediaPlayer.getVideoWidth(), mediaPlayer.getVideoHeight());
            }
        });
        this.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            public boolean onError(MediaPlayer mediaPlayer, int n2, int n3) {
                VideoPlayerView.this.stopPrepareTimer();
                if (mediaPlayer != null) {
                    VideoPlayerView.this._mediaPlayer = mediaPlayer;
                }
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.VIDEOPLAYER, VideoPlayerEvent.GENERIC_ERROR, VideoPlayerView.this._videoUrl, n2, n3);
                VideoPlayerView.this.stopVideoProgressTimer();
                return true;
            }
        });
        this.setInfoListenerEnabled(this._infoListenerEnabled);
        if (n2 > 0) {
            this.startPrepareTimer(n2);
        }
        try {
            this.setVideoPath(this._videoUrl);
        }
        catch (Exception exception) {
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.VIDEOPLAYER, VideoPlayerEvent.PREPARE_ERROR, this._videoUrl);
            DeviceLog.exception("Error preparing video: " + this._videoUrl, exception);
            return false;
        }
        return true;
    }

    public void play() {
        DeviceLog.entered();
        this.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mediaPlayer) {
                if (mediaPlayer != null) {
                    VideoPlayerView.this._mediaPlayer = mediaPlayer;
                }
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.VIDEOPLAYER, VideoPlayerEvent.COMPLETED, VideoPlayerView.this._videoUrl);
                VideoPlayerView.this.stopVideoProgressTimer();
            }
        });
        this.start();
        this.stopVideoProgressTimer();
        this.startVideoProgressTimer();
        WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.VIDEOPLAYER, VideoPlayerEvent.PLAY, this._videoUrl);
    }

    public void setInfoListenerEnabled(boolean bl) {
        this._infoListenerEnabled = bl;
        if (Build.VERSION.SDK_INT > 16) {
            if (this._infoListenerEnabled) {
                this.setOnInfoListener(new MediaPlayer.OnInfoListener(){

                    public boolean onInfo(MediaPlayer mediaPlayer, int n2, int n3) {
                        WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.VIDEOPLAYER, VideoPlayerEvent.INFO, VideoPlayerView.this._videoUrl, n2, n3);
                        return true;
                    }
                });
                return;
            }
            this.setOnInfoListener(null);
        }
    }

    public void pause() {
        try {
            super.pause();
        }
        catch (Exception exception) {
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.VIDEOPLAYER, VideoPlayerEvent.PAUSE_ERROR, this._videoUrl);
            DeviceLog.exception("Error pausing video", exception);
            return;
        }
        this.stopVideoProgressTimer();
        WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.VIDEOPLAYER, VideoPlayerEvent.PAUSE, this._videoUrl);
    }

    public void seekTo(int n2) {
        try {
            super.seekTo(n2);
        }
        catch (Exception exception) {
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.VIDEOPLAYER, VideoPlayerEvent.SEEKTO_ERROR, this._videoUrl);
            DeviceLog.exception("Error seeking video", exception);
            return;
        }
        WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.VIDEOPLAYER, VideoPlayerEvent.SEEKTO, this._videoUrl);
    }

    public void stop() {
        this.stopPlayback();
        this.stopVideoProgressTimer();
        WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.VIDEOPLAYER, VideoPlayerEvent.STOP, this._videoUrl);
    }

    public float getVolume() {
        return this._volume.floatValue();
    }

    public void setVolume(Float f2) {
        try {
            this._mediaPlayer.setVolume(f2.floatValue(), f2.floatValue());
            this._volume = f2;
            return;
        }
        catch (Exception exception) {
            DeviceLog.exception("MediaPlayer generic error", exception);
            return;
        }
    }

    public void setProgressEventInterval(int n2) {
        this._progressEventInterval = n2;
        if (this._videoTimer != null) {
            this.stopVideoProgressTimer();
            this.startVideoProgressTimer();
        }
    }

    public int getProgressEventInterval() {
        return this._progressEventInterval;
    }

    public int[] getVideoViewRectangle() {
        int[] nArray = new int[2];
        this.getLocationInWindow(nArray);
        return new int[]{nArray[0], nArray[1], this.getMeasuredWidth(), this.getMeasuredHeight()};
    }
}

