/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.ads.configuration;

import android.os.ConditionVariable;
import com.unity3d.splash.IUnityAdsListener;
import com.unity3d.splash.UnityAds;
import com.unity3d.splash.services.ads.adunit.VideoPlayerHandler;
import com.unity3d.splash.services.ads.adunit.WebPlayerHandler;
import com.unity3d.splash.services.ads.adunit.WebViewHandler;
import com.unity3d.splash.services.ads.api.AdUnit;
import com.unity3d.splash.services.ads.api.Listener;
import com.unity3d.splash.services.ads.api.Placement;
import com.unity3d.splash.services.ads.api.VideoPlayer;
import com.unity3d.splash.services.ads.configuration.IAdsModuleConfiguration;
import com.unity3d.splash.services.ads.properties.AdsProperties;
import com.unity3d.splash.services.ads.webplayer.api.WebPlayer;
import com.unity3d.splash.services.core.configuration.Configuration;
import com.unity3d.splash.services.core.log.DeviceLog;
import com.unity3d.splash.services.core.misc.Utilities;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class AdsModuleConfiguration
implements IAdsModuleConfiguration {
    private InetAddress _address;

    @Override
    public Class[] getWebAppApiClassList() {
        return new Class[]{AdUnit.class, Listener.class, VideoPlayer.class, Placement.class, WebPlayer.class, com.unity3d.splash.services.ads.api.AdsProperties.class};
    }

    @Override
    public boolean resetState(Configuration configuration) {
        com.unity3d.splash.services.ads.placement.Placement.reset();
        return true;
    }

    @Override
    public boolean initModuleState(Configuration object) {
        DeviceLog.debug("Unity Ads init: checking for ad blockers");
        try {
            object = new URL(((Configuration)object).getConfigUrl()).getHost();
        }
        catch (MalformedURLException malformedURLException) {
            return true;
        }
        ConditionVariable conditionVariable = new ConditionVariable();
        new Thread((String)object, conditionVariable){
            final /* synthetic */ String val$configHost;
            final /* synthetic */ ConditionVariable val$cv;
            {
                this.val$configHost = string;
                this.val$cv = conditionVariable;
            }

            @Override
            public void run() {
                try {
                    AdsModuleConfiguration.this._address = InetAddress.getByName(this.val$configHost);
                    this.val$cv.open();
                    return;
                }
                catch (Exception exception) {
                    DeviceLog.exception("Couldn't get address. Host: " + this.val$configHost, exception);
                    this.val$cv.open();
                    return;
                }
            }
        }.start();
        if (conditionVariable.block(2000L) && this._address != null && this._address.isLoopbackAddress()) {
            DeviceLog.error("Unity Ads init: halting init because Unity Ads config resolves to loopback address (due to ad blocker?)");
            Utilities.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    Iterator iterator = AdsProperties.getListeners().iterator();
                    while (iterator.hasNext()) {
                        ((IUnityAdsListener)iterator.next()).onUnityAdsError(UnityAds.UnityAdsError.AD_BLOCKER_DETECTED, "Unity Ads config server resolves to loopback address (due to ad blocker?)");
                    }
                }
            });
            return false;
        }
        return true;
    }

    @Override
    public boolean initErrorState(Configuration object, String string, String string2) {
        object = "Init failed in " + string;
        Utilities.runOnUiThread(new Runnable((String)object){
            final /* synthetic */ String val$message;
            {
                this.val$message = string;
            }

            @Override
            public void run() {
                Iterator iterator = AdsProperties.getListeners().iterator();
                while (iterator.hasNext()) {
                    ((IUnityAdsListener)iterator.next()).onUnityAdsError(UnityAds.UnityAdsError.INITIALIZE_FAILED, this.val$message);
                }
            }
        });
        return true;
    }

    @Override
    public boolean initCompleteState(Configuration configuration) {
        return true;
    }

    @Override
    public Map getAdUnitViewHandlers() {
        HashMap<String, Class<WebViewHandler>> hashMap = new HashMap<String, Class<WebViewHandler>>();
        hashMap.put("videoplayer", VideoPlayerHandler.class);
        hashMap.put("webplayer", WebPlayerHandler.class);
        hashMap.put("webview", WebViewHandler.class);
        return hashMap;
    }
}

