/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services.ads.api;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.unity3d.splash.services.ads.adunit.AdUnitActivity;
import com.unity3d.splash.services.ads.adunit.AdUnitError;
import com.unity3d.splash.services.ads.adunit.AdUnitMotionEvent;
import com.unity3d.splash.services.ads.adunit.AdUnitSoftwareActivity;
import com.unity3d.splash.services.ads.adunit.AdUnitTransparentActivity;
import com.unity3d.splash.services.ads.adunit.AdUnitTransparentSoftwareActivity;
import com.unity3d.splash.services.core.log.DeviceLog;
import com.unity3d.splash.services.core.misc.Utilities;
import com.unity3d.splash.services.core.properties.ClientProperties;
import com.unity3d.splash.services.core.webview.bridge.WebViewCallback;
import com.unity3d.splash.services.core.webview.bridge.WebViewExposed;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AdUnit {
    private static AdUnitActivity _adUnitActivity;
    private static int _currentActivityId;

    private AdUnit() {
    }

    public static void setAdUnitActivity(AdUnitActivity adUnitActivity) {
        _adUnitActivity = adUnitActivity;
    }

    public static AdUnitActivity getAdUnitActivity() {
        return _adUnitActivity;
    }

    public static int getCurrentAdUnitActivityId() {
        return _currentActivityId;
    }

    public static void setCurrentAdUnitActivityId(int n2) {
        _currentActivityId = n2;
    }

    @WebViewExposed
    public static void open(Integer n2, JSONArray jSONArray, Integer n3, WebViewCallback webViewCallback) {
        AdUnit.open(n2, jSONArray, n3, null, webViewCallback);
    }

    @WebViewExposed
    public static void open(Integer n2, JSONArray jSONArray, Integer n3, JSONArray jSONArray2, WebViewCallback webViewCallback) {
        AdUnit.open(n2, jSONArray, n3, jSONArray2, 0, true, webViewCallback);
    }

    @WebViewExposed
    public static void open(Integer n2, JSONArray jSONArray, Integer n3, JSONArray jSONArray2, Integer n4, Boolean bl, WebViewCallback webViewCallback) {
        AdUnit.open(n2, jSONArray, n3, jSONArray2, n4, bl, false, webViewCallback);
    }

    @WebViewExposed
    public static void open(Integer n2, JSONArray jSONArray, Integer n3, JSONArray jSONArray2, Integer n4, Boolean bl, Boolean bl2, WebViewCallback webViewCallback) {
        AdUnit.open(n2, jSONArray, n3, jSONArray2, n4, bl, bl2, 0, webViewCallback);
    }

    @WebViewExposed
    public static void open(Integer n2, JSONArray jSONArray, Integer n3, JSONArray jSONArray2, Integer n4, Boolean bl, Boolean bl2, Integer n5, WebViewCallback webViewCallback) {
        if (!bl.booleanValue() && bl2.booleanValue()) {
            DeviceLog.debug("Unity Ads opening new transparent ad unit activity, hardware acceleration disabled");
            bl = new Intent((Context)ClientProperties.getActivity(), AdUnitTransparentSoftwareActivity.class);
        } else if (bl.booleanValue() && !bl2.booleanValue()) {
            DeviceLog.debug("Unity Ads opening new hardware accelerated ad unit activity");
            bl = new Intent((Context)ClientProperties.getActivity(), AdUnitActivity.class);
        } else if (bl.booleanValue() && bl2.booleanValue()) {
            DeviceLog.debug("Unity Ads opening new hardware accelerated transparent ad unit activity");
            bl = new Intent((Context)ClientProperties.getActivity(), AdUnitTransparentActivity.class);
        } else {
            DeviceLog.debug("Unity Ads opening new ad unit activity, hardware acceleration disabled");
            bl = new Intent((Context)ClientProperties.getActivity(), AdUnitSoftwareActivity.class);
        }
        bl.addFlags(0x10010000);
        if (n2 != null) {
            try {
                bl.putExtra("activityId", n2);
            }
            catch (Exception exception) {
                DeviceLog.exception("Could not set activityId for intent", exception);
                webViewCallback.error(AdUnitError.ACTIVITY_ID, (int)n2, exception.getMessage());
                return;
            }
        } else {
            DeviceLog.error("Activity ID is NULL");
            webViewCallback.error(AdUnitError.ACTIVITY_ID, "Activity ID NULL");
            return;
        }
        AdUnit.setCurrentAdUnitActivityId(n2);
        try {
            bl.putExtra("views", AdUnit.getViewList(jSONArray));
        }
        catch (Exception exception) {
            DeviceLog.exception("Error parsing views from viewList", exception);
            webViewCallback.error(AdUnitError.CORRUPTED_VIEWLIST, jSONArray, exception.getMessage());
            return;
        }
        if (jSONArray2 != null) {
            try {
                bl.putExtra("keyEvents", AdUnit.getKeyEventList(jSONArray2));
            }
            catch (Exception exception) {
                DeviceLog.exception("Error parsing views from viewList", exception);
                webViewCallback.error(AdUnitError.CORRUPTED_KEYEVENTLIST, jSONArray2, exception.getMessage());
                return;
            }
        }
        bl.putExtra("systemUiVisibility", n4);
        bl.putExtra("orientation", n3);
        bl.putExtra("displayCutoutMode", n5);
        ClientProperties.getActivity().startActivity((Intent)bl);
        DeviceLog.debug("Opened AdUnitActivity with: " + jSONArray.toString());
        webViewCallback.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void close(WebViewCallback webViewCallback) {
        if (AdUnit.getAdUnitActivity() != null) {
            AdUnit.getAdUnitActivity().finish();
            webViewCallback.invoke(new Object[0]);
            return;
        }
        webViewCallback.error(AdUnitError.ADUNIT_NULL, new Object[0]);
    }

    @WebViewExposed
    public static void setViews(final JSONArray jSONArray, WebViewCallback webViewCallback) {
        boolean bl = false;
        try {
            AdUnit.getViewList(jSONArray);
        }
        catch (JSONException jSONException) {
            webViewCallback.error(AdUnitError.CORRUPTED_VIEWLIST, jSONArray);
            bl = true;
        }
        if (!bl) {
            Utilities.runOnUiThread(new Runnable(){

                @Override
                public final void run() {
                    if (AdUnit.getAdUnitActivity() != null) {
                        try {
                            AdUnit.getAdUnitActivity().setViews(AdUnit.getViewList(jSONArray));
                            return;
                        }
                        catch (Exception exception) {
                            DeviceLog.exception("Corrupted viewlist", exception);
                        }
                    }
                }
            });
        }
        if (AdUnit.getAdUnitActivity() != null) {
            webViewCallback.invoke(jSONArray);
            return;
        }
        webViewCallback.error(AdUnitError.ADUNIT_NULL, new Object[0]);
    }

    @WebViewExposed
    public static void getViews(WebViewCallback webViewCallback) {
        if (AdUnit.getAdUnitActivity() != null) {
            String[] stringArray = AdUnit.getAdUnitActivity().getViews();
            webViewCallback.invoke(new JSONArray(Arrays.asList(stringArray)));
            return;
        }
        webViewCallback.error(AdUnitError.ADUNIT_NULL, new Object[0]);
    }

    @WebViewExposed
    public static void setOrientation(final Integer n2, WebViewCallback webViewCallback) {
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (AdUnit.getAdUnitActivity() != null) {
                    AdUnit.getAdUnitActivity().setOrientation(n2);
                }
            }
        });
        if (AdUnit.getAdUnitActivity() != null) {
            webViewCallback.invoke(n2);
            return;
        }
        webViewCallback.error(AdUnitError.ADUNIT_NULL, new Object[0]);
    }

    @WebViewExposed
    public static void getOrientation(WebViewCallback webViewCallback) {
        if (AdUnit.getAdUnitActivity() != null) {
            webViewCallback.invoke(AdUnit.getAdUnitActivity().getRequestedOrientation());
            return;
        }
        webViewCallback.error(AdUnitError.ADUNIT_NULL, new Object[0]);
    }

    @WebViewExposed
    public static void setKeepScreenOn(final Boolean bl, WebViewCallback webViewCallback) {
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (AdUnit.getAdUnitActivity() != null) {
                    AdUnit.getAdUnitActivity().setKeepScreenOn(bl);
                }
            }
        });
        if (AdUnit.getAdUnitActivity() != null) {
            webViewCallback.invoke(new Object[0]);
            return;
        }
        webViewCallback.error(AdUnitError.ADUNIT_NULL, new Object[0]);
    }

    @WebViewExposed
    public static void setSystemUiVisibility(final Integer n2, WebViewCallback webViewCallback) {
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (AdUnit.getAdUnitActivity() != null) {
                    AdUnit.getAdUnitActivity().setSystemUiVisibility(n2);
                }
            }
        });
        if (AdUnit.getAdUnitActivity() != null) {
            webViewCallback.invoke(n2);
            return;
        }
        webViewCallback.error(AdUnitError.ADUNIT_NULL, new Object[0]);
    }

    @WebViewExposed
    public static void setKeyEventList(JSONArray jSONArray, WebViewCallback webViewCallback) {
        if (AdUnit.getAdUnitActivity() != null) {
            try {
                AdUnit.getAdUnitActivity().setKeyEventList(AdUnit.getKeyEventList(jSONArray));
                webViewCallback.invoke(jSONArray);
                return;
            }
            catch (Exception exception) {
                DeviceLog.exception("Error parsing views from viewList", exception);
                webViewCallback.error(AdUnitError.CORRUPTED_KEYEVENTLIST, jSONArray, exception.getMessage());
                return;
            }
        }
        webViewCallback.error(AdUnitError.ADUNIT_NULL, new Object[0]);
    }

    @WebViewExposed
    public static void setViewFrame(final String string, final Integer n2, final Integer n3, final Integer n4, final Integer n5, WebViewCallback webViewCallback) {
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (AdUnit.getAdUnitActivity() != null) {
                    AdUnit.getAdUnitActivity().setViewFrame(string, n2, n3, n4, n5);
                }
            }
        });
        if (AdUnit.getAdUnitActivity() != null) {
            webViewCallback.invoke(new Object[0]);
            return;
        }
        webViewCallback.error(AdUnitError.ADUNIT_NULL, new Object[0]);
    }

    @WebViewExposed
    public static void getViewFrame(String object, WebViewCallback webViewCallback) {
        if (AdUnit.getAdUnitActivity() != null) {
            if (AdUnit.getAdUnitActivity().getViewFrame((String)object) != null) {
                object = AdUnit.getAdUnitActivity().getViewFrame((String)object);
                webViewCallback.invoke(object.get("x"), object.get("y"), object.get("width"), object.get("height"));
                return;
            }
            webViewCallback.error(AdUnitError.UNKNOWN_VIEW, new Object[0]);
            return;
        }
        webViewCallback.error(AdUnitError.ADUNIT_NULL, new Object[0]);
    }

    @WebViewExposed
    public static void startMotionEventCapture(Integer n2, WebViewCallback webViewCallback) {
        if (AdUnit.getAdUnitActivity() != null) {
            if (AdUnit.getAdUnitActivity().getLayout() != null) {
                AdUnit.getAdUnitActivity().getLayout().startCapture(n2);
                webViewCallback.invoke(new Object[0]);
                return;
            }
            webViewCallback.error(AdUnitError.LAYOUT_NULL, new Object[0]);
            return;
        }
        webViewCallback.error(AdUnitError.ADUNIT_NULL, new Object[0]);
    }

    @WebViewExposed
    public static void endMotionEventCapture(WebViewCallback webViewCallback) {
        if (AdUnit.getAdUnitActivity() != null) {
            if (AdUnit.getAdUnitActivity().getLayout() != null) {
                AdUnit.getAdUnitActivity().getLayout().endCapture();
                webViewCallback.invoke(new Object[0]);
                return;
            }
            webViewCallback.error(AdUnitError.LAYOUT_NULL, new Object[0]);
            return;
        }
        webViewCallback.error(AdUnitError.ADUNIT_NULL, new Object[0]);
    }

    @WebViewExposed
    public static void clearMotionEventCapture(WebViewCallback webViewCallback) {
        if (AdUnit.getAdUnitActivity() != null) {
            if (AdUnit.getAdUnitActivity().getLayout() != null) {
                AdUnit.getAdUnitActivity().getLayout().clearCapture();
                webViewCallback.invoke(new Object[0]);
                return;
            }
            webViewCallback.error(AdUnitError.LAYOUT_NULL, new Object[0]);
            return;
        }
        webViewCallback.error(AdUnitError.ADUNIT_NULL, new Object[0]);
    }

    @WebViewExposed
    public static void getMotionEventCount(JSONArray jSONArray, WebViewCallback webViewCallback) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            try {
                arrayList.add(jSONArray.getInt(i2));
                continue;
            }
            catch (Exception exception) {
                DeviceLog.exception("Error retrieving int from eventTypes", exception);
            }
        }
        if (AdUnit.getAdUnitActivity() != null) {
            if (AdUnit.getAdUnitActivity().getLayout() != null) {
                if (AdUnit.getAdUnitActivity().getLayout().getCurrentEventCount() >= AdUnit.getAdUnitActivity().getLayout().getMaxEventCount()) {
                    webViewCallback.error(AdUnitError.MAX_MOTION_EVENT_COUNT_REACHED, new Object[0]);
                    return;
                }
                SparseIntArray sparseIntArray = AdUnit.getAdUnitActivity().getLayout().getEventCount(arrayList);
                JSONObject jSONObject = new JSONObject();
                for (int i3 = 0; i3 < sparseIntArray.size(); ++i3) {
                    int n2 = sparseIntArray.keyAt(i3);
                    int n3 = sparseIntArray.get(n2);
                    try {
                        jSONObject.put(Integer.toString(n2), n3);
                        continue;
                    }
                    catch (Exception exception) {
                        DeviceLog.exception("Error building response JSON", exception);
                    }
                }
                webViewCallback.invoke(jSONObject);
                return;
            }
            webViewCallback.error(AdUnitError.LAYOUT_NULL, new Object[0]);
            return;
        }
        webViewCallback.error(AdUnitError.ADUNIT_NULL, new Object[0]);
    }

    @WebViewExposed
    public static void getMotionEventData(JSONObject jSONObject, WebViewCallback webViewCallback) {
        String string;
        Iterator iterator = jSONObject.keys();
        SparseArray sparseArray = new SparseArray();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            int n2 = Integer.parseInt(string);
            if (sparseArray.get(n2) == null) {
                sparseArray.put(n2, new ArrayList());
            }
            JSONArray jSONArray = null;
            try {
                jSONArray = jSONObject.getJSONArray(string);
            }
            catch (Exception exception) {
                DeviceLog.exception("Couldn't fetch keyIndices", exception);
            }
            if (jSONArray == null) continue;
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                try {
                    ((ArrayList)sparseArray.get(n2)).add(jSONArray.getInt(i2));
                    continue;
                }
                catch (Exception exception) {
                    DeviceLog.exception("Couldn't add value to requested infos", exception);
                }
            }
        }
        if (AdUnit.getAdUnitActivity() != null) {
            if (AdUnit.getAdUnitActivity().getLayout() != null) {
                if (AdUnit.getAdUnitActivity().getLayout().getCurrentEventCount() >= AdUnit.getAdUnitActivity().getLayout().getMaxEventCount()) {
                    webViewCallback.error(AdUnitError.MAX_MOTION_EVENT_COUNT_REACHED, new Object[0]);
                    return;
                }
                string = AdUnit.getAdUnitActivity().getLayout().getEvents(sparseArray);
                JSONObject jSONObject2 = new JSONObject();
                for (int i3 = 0; i3 < string.size(); ++i3) {
                    int n3 = string.keyAt(i3);
                    SparseArray sparseArray2 = (SparseArray)string.get(n3);
                    jSONObject = new JSONObject();
                    for (int i4 = 0; i4 < sparseArray2.size(); ++i4) {
                        sparseArray = new JSONObject();
                        int n4 = sparseArray2.keyAt(i4);
                        AdUnitMotionEvent adUnitMotionEvent = (AdUnitMotionEvent)sparseArray2.get(n4);
                        try {
                            sparseArray.put("action", adUnitMotionEvent.getAction());
                            sparseArray.put("isObscured", adUnitMotionEvent.isObscured());
                            sparseArray.put("toolType", adUnitMotionEvent.getToolType());
                            sparseArray.put("source", adUnitMotionEvent.getSource());
                            sparseArray.put("deviceId", adUnitMotionEvent.getDeviceId());
                            sparseArray.put("x", (double)adUnitMotionEvent.getX());
                            sparseArray.put("y", (double)adUnitMotionEvent.getY());
                            sparseArray.put("eventTime", adUnitMotionEvent.getEventTime());
                            sparseArray.put("pressure", (double)adUnitMotionEvent.getPressure());
                            sparseArray.put("size", (double)adUnitMotionEvent.getSize());
                            jSONObject.put(Integer.toString(n4), (Object)sparseArray);
                            continue;
                        }
                        catch (Exception exception) {
                            DeviceLog.debug("Couldn't construct event info", exception);
                        }
                    }
                    try {
                        jSONObject2.put(Integer.toString(n3), (Object)jSONObject);
                        continue;
                    }
                    catch (Exception exception) {
                        DeviceLog.debug("Couldn't construct info object", exception);
                    }
                }
                webViewCallback.invoke(jSONObject2);
                return;
            }
            webViewCallback.error(AdUnitError.LAYOUT_NULL, new Object[0]);
            return;
        }
        webViewCallback.error(AdUnitError.ADUNIT_NULL, new Object[0]);
    }

    @WebViewExposed
    public static void getCurrentMotionEventCount(WebViewCallback webViewCallback) {
        if (AdUnit.getAdUnitActivity() != null) {
            if (AdUnit.getAdUnitActivity().getLayout() != null) {
                webViewCallback.invoke(AdUnit.getAdUnitActivity().getLayout().getCurrentEventCount());
                return;
            }
            webViewCallback.error(AdUnitError.LAYOUT_NULL, new Object[0]);
            return;
        }
        webViewCallback.error(AdUnitError.ADUNIT_NULL, new Object[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WebViewExposed
    public static void getSafeAreaInsets(WebViewCallback webViewCallback) {
        if (AdUnit.getAdUnitActivity() != null && AdUnit.getAdUnitActivity().getLayout() != null) {
            if (Build.VERSION.SDK_INT < 28) {
                webViewCallback.error(AdUnitError.API_LEVEL_ERROR, new Object[0]);
                return;
            }
            Object object = AdUnit.getAdUnitActivity().getLayout().getRootWindowInsets();
            if (object == null) {
                webViewCallback.error(AdUnitError.NO_DISPLAY_CUTOUT_AVAILABLE, new Object[0]);
                return;
            }
            JSONObject jSONObject = new JSONObject();
            try {
                object = object.getClass().getMethod("getDisplayCutout", new Class[0]).invoke(object, new Object[0]);
                if (object != null) {
                    Object object2 = object.getClass().getMethod("getSafeInsetTop", new Class[0]).invoke(object, new Object[0]);
                    Object object3 = object.getClass().getMethod("getSafeInsetRight", new Class[0]).invoke(object, new Object[0]);
                    Object object4 = object.getClass().getMethod("getSafeInsetBottom", new Class[0]).invoke(object, new Object[0]);
                    object = object.getClass().getMethod("getSafeInsetLeft", new Class[0]).invoke(object, new Object[0]);
                    jSONObject.put("top", object2);
                    jSONObject.put("right", object3);
                    jSONObject.put("bottom", object4);
                    jSONObject.put("left", object);
                    webViewCallback.invoke(jSONObject);
                    return;
                }
                webViewCallback.error(AdUnitError.NO_DISPLAY_CUTOUT_AVAILABLE, new Object[0]);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                webViewCallback.error(AdUnitError.DISPLAY_CUTOUT_METHOD_NOT_AVAILABLE, new Object[0]);
                DeviceLog.debug("Method getDisplayCutout not found", noSuchMethodException);
                return;
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                webViewCallback.error(AdUnitError.DISPLAY_CUTOUT_INVOKE_FAILED, new Object[0]);
                DeviceLog.debug("Error while calling displayCutout getter", reflectiveOperationException);
                return;
            }
            catch (JSONException jSONException) {
                webViewCallback.error(AdUnitError.DISPLAY_CUTOUT_JSON_ERROR, new Object[0]);
                DeviceLog.debug("JSON error while constructing display cutout object", new Object[]{jSONException});
                return;
            }
        }
        webViewCallback.error(AdUnitError.ADUNIT_NULL, new Object[0]);
    }

    @WebViewExposed
    public static void setLayoutInDisplayCutoutMode(final Integer n2, WebViewCallback webViewCallback) {
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (AdUnit.getAdUnitActivity() != null) {
                    AdUnit.getAdUnitActivity().setLayoutInDisplayCutoutMode(n2);
                }
            }
        });
        if (AdUnit.getAdUnitActivity() != null) {
            webViewCallback.invoke(n2);
            return;
        }
        webViewCallback.error(AdUnitError.ADUNIT_NULL, new Object[0]);
    }

    private static String[] getViewList(JSONArray jSONArray) {
        String[] stringArray = new String[jSONArray.length()];
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            stringArray[i2] = jSONArray.getString(i2);
        }
        return stringArray;
    }

    private static ArrayList getKeyEventList(JSONArray jSONArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Integer n2 = 0;
        while (n2 < jSONArray.length()) {
            arrayList.add(jSONArray.getInt(n2.intValue()));
            n2 = n2 + 1;
        }
        return arrayList;
    }

    static {
        _currentActivityId = -1;
    }
}

