/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.splash.services;

import android.app.Activity;
import android.os.Build;
import com.unity3d.splash.services.IUnityServicesListener;
import com.unity3d.splash.services.core.configuration.Configuration;
import com.unity3d.splash.services.core.configuration.EnvironmentCheck;
import com.unity3d.splash.services.core.configuration.InitializeThread;
import com.unity3d.splash.services.core.log.DeviceLog;
import com.unity3d.splash.services.core.properties.ClientProperties;
import com.unity3d.splash.services.core.properties.SdkProperties;
import java.util.Date;

public class UnityServices {
    private static boolean _configurationInitialized = false;

    public static void initialize(Activity activity, String string, IUnityServicesListener iUnityServicesListener, boolean bl, boolean bl2) {
        DeviceLog.entered();
        if (_configurationInitialized) {
            if (ClientProperties.getGameId() != null && !ClientProperties.getGameId().equals(string)) {
                DeviceLog.warning("You are trying to re-initialize with a different gameId");
            }
            return;
        }
        _configurationInitialized = true;
        if (!UnityServices.isSupported()) {
            DeviceLog.error("Error while initializing Unity Services: device is not supported");
            return;
        }
        DeviceLog.info("Application start initializing at " + new Date().getTime());
        SdkProperties.setInitializationTime(System.currentTimeMillis());
        if (string == null || string.length() == 0) {
            DeviceLog.error("Error while initializing Unity Services: empty game ID, halting Unity Ads init");
            if (iUnityServicesListener != null) {
                iUnityServicesListener.onUnityServicesError(UnityServicesError.INVALID_ARGUMENT, "Empty game ID");
            }
            return;
        }
        if (activity == null) {
            DeviceLog.error("Error while initializing Unity Services: null activity, halting Unity Ads init");
            if (iUnityServicesListener != null) {
                iUnityServicesListener.onUnityServicesError(UnityServicesError.INVALID_ARGUMENT, "Null activity");
            }
            return;
        }
        if (bl) {
            DeviceLog.info("Initializing Unity Services " + SdkProperties.getVersionName() + " (" + SdkProperties.getVersionCode() + ") with game id " + string + " in test mode");
        } else {
            DeviceLog.info("Initializing Unity Services " + SdkProperties.getVersionName() + " (" + SdkProperties.getVersionCode() + ") with game id " + string + " in production mode");
        }
        SdkProperties.setDebugMode(SdkProperties.getDebugMode());
        SdkProperties.setListener(iUnityServicesListener);
        ClientProperties.setGameId(string);
        ClientProperties.setApplicationContext(activity.getApplicationContext());
        ClientProperties.setApplication(activity.getApplication());
        SdkProperties.setPerPlacementLoadEnabled(bl2);
        SdkProperties.setTestMode(bl);
        if (!EnvironmentCheck.isEnvironmentOk()) {
            DeviceLog.error("Error during Unity Services environment check, halting Unity Services init");
            if (iUnityServicesListener != null) {
                iUnityServicesListener.onUnityServicesError(UnityServicesError.INIT_SANITY_CHECK_FAIL, "Unity Services init environment check failed");
            }
            return;
        }
        DeviceLog.info("Unity Services environment check OK");
        InitializeThread.initialize(new Configuration());
    }

    public static boolean isSupported() {
        return Build.VERSION.SDK_INT >= 16;
    }

    public static boolean isInitialized() {
        return SdkProperties.isInitialized();
    }

    public static String getVersion() {
        return SdkProperties.getVersionName();
    }

    public static void setDebugMode(boolean bl) {
        SdkProperties.setDebugMode(bl);
    }

    public static boolean getDebugMode() {
        return SdkProperties.getDebugMode();
    }

    public static enum UnityServicesError {
        INVALID_ARGUMENT,
        INIT_SANITY_CHECK_FAIL;

    }
}

