/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.player;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.OrientationEventListener;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowManager;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import com.unity3d.player.AudioVolumeHandler;
import com.unity3d.player.Camera2Wrapper;
import com.unity3d.player.GoogleARCoreApi;
import com.unity3d.player.HFPStatus;
import com.unity3d.player.IUnityPlayerLifecycleEvents;
import com.unity3d.player.NativeLoader;
import com.unity3d.player.NetworkConnectivity;
import com.unity3d.player.PlatformSupport;
import com.unity3d.player.UnityPermissions;
import com.unity3d.player.h;
import com.unity3d.player.i;
import com.unity3d.player.j;
import com.unity3d.player.k;
import com.unity3d.player.l;
import com.unity3d.player.n;
import com.unity3d.splash.UnityAds;
import com.unity3d.splash.services.core.device.Device;
import com.unity3d.splash.services.core.device.StorageManager;
import com.unity3d.splash.services.core.log.DeviceLog;
import com.unity3d.splash.services.core.misc.JsonStorage;
import com.unity3d.splash.services.core.request.WebRequest;
import java.io.UnsupportedEncodingException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

public class UnityPlayer
extends FrameLayout
implements IUnityPlayerLifecycleEvents {
    public static Activity currentActivity = null;
    private int mInitialScreenOrientation = -1;
    private boolean mMainDisplayOverride = false;
    private boolean mIsFullscreen = true;
    private l mState = new l();
    private final ConcurrentLinkedQueue m_Events = new ConcurrentLinkedQueue();
    private BroadcastReceiver mKillingIsMyBusiness = null;
    private OrientationEventListener mOrientationListener = null;
    private int mNaturalOrientation;
    private static final int ANR_TIMEOUT_SECONDS = 4;
    private static final int RUN_STATE_CHANGED_MSG_CODE = 2269;
    f m_MainThread = new f(0);
    private boolean m_AddPhoneCallListener = false;
    private c m_PhoneCallListener = new c(0);
    private TelephonyManager m_TelephonyManager;
    private ClipboardManager m_ClipboardManager;
    private j m_SplashScreen;
    private com.unity3d.player.f m_PersistentUnitySurface;
    private GoogleARCoreApi m_ARCoreApi = null;
    private a m_FakeListener = new a();
    private Camera2Wrapper m_Camera2Wrapper = null;
    private HFPStatus m_HFPStatus = null;
    private AudioVolumeHandler m_AudioVolumeHandler = null;
    private Uri m_launchUri = null;
    private NetworkConnectivity m_NetworkConnectivity = null;
    private i m_splashAdsScreen;
    private boolean finishLaunchScreenAds = false;
    private boolean shouldShowLaunchScreenAds = false;
    private IUnityPlayerLifecycleEvents m_UnityPlayerLifecycleEvents = null;
    private Context mContext;
    private SurfaceView mGlView;
    private boolean mQuitting;
    private boolean mProcessKillRequested = true;
    private n mVideoPlayerProxy;
    com.unity3d.player.g mSoftInputDialog = null;
    private static final String SPLASH_ENABLE_METADATA_NAME = "unity.splash-enable";
    private static final String SPLASH_MODE_METADATA_NAME = "unity.splash-mode";
    private static final String ARCORE_ENABLE_METADATA_NAME = "unity.arcore-enable";
    private static final String SPLASH_ADS_GAME_ID = "unity.splash-ads-game-id";
    private static final String SPLASH_ADS_SLOGAN = "unity.splash-ads-slogan";
    private static final String SPLASH_ADS_SLOGAN_HEIGHT = "unity.splash-ads-slogan-height";
    private static final String UNITY_BUILDER_ID = "unity.builder";
    AlertDialog ad = null;
    private Handler mHanlder = null;
    private Timer timer = new Timer();
    private TimerTask timerTask = null;

    public UnityPlayer(Context context) {
        this(context, null);
    }

    public UnityPlayer(Context object, IUnityPlayerLifecycleEvents object2) {
        super(object);
        IUnityPlayerLifecycleEvents iUnityPlayerLifecycleEvents = this.m_UnityPlayerLifecycleEvents = object2 != null ? object2 : this;
        if (object instanceof Activity) {
            currentActivity = (Activity)object;
            this.mInitialScreenOrientation = currentActivity.getRequestedOrientation();
            this.m_launchUri = currentActivity.getIntent().getData();
        }
        this.EarlyEnableFullScreenIfVrLaunched(currentActivity);
        this.mContext = object;
        object2 = this.getResources().getConfiguration();
        this.mNaturalOrientation = this.getNaturalOrientation(((Configuration)object2).orientation);
        if (currentActivity != null && this.getSplashEnabled()) {
            this.m_SplashScreen = new j(this.mContext, j.a.a()[this.getSplashMode()]);
            this.addView(this.m_SplashScreen);
        }
        this.hideStatusBar();
        if (currentActivity != null) {
            this.m_PersistentUnitySurface = new com.unity3d.player.f(this.mContext);
        }
        object2 = UnityPlayer.loadNative(UnityPlayer.getUnityNativeLibraryPath(object));
        if (!l.c()) {
            object = "Your hardware does not support this application.";
            com.unity3d.player.d.Log(6, (String)object);
            object = new AlertDialog.Builder(this.mContext).setTitle((CharSequence)"Failure to initialize!").setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

                public final void onClick(DialogInterface dialogInterface, int n2) {
                    UnityPlayer.this.finish();
                }
            }).setMessage((CharSequence)((String)object + "\n\n" + (String)object2 + "\n\n Press OK to quit.")).create();
            object.setCancelable(false);
            object.show();
            return;
        }
        this.initJni((Context)object);
        this.mState.c(true);
        if (this.shouldRegisterLaunch((Context)object)) {
            this.registerLaunch();
        }
        this.mGlView = this.CreateGlView();
        this.mGlView.setContentDescription((CharSequence)this.GetGlViewContentDescription((Context)object));
        this.addView((View)this.mGlView);
        if (this.shouldShowLaunchScreenAds) {
            this.m_splashAdsScreen = this.generateSplashView(this.mContext);
            if (this.m_splashAdsScreen != null) {
                this.addView((View)this.m_splashAdsScreen);
            } else {
                this.finishLaunchScreenAds = true;
            }
        }
        if (this.m_SplashScreen != null) {
            this.bringChildToFront(this.m_SplashScreen);
        }
        this.mQuitting = false;
        this.hideStatusBar();
        this.m_TelephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        this.m_ClipboardManager = (ClipboardManager)this.mContext.getSystemService("clipboard");
        this.m_Camera2Wrapper = new Camera2Wrapper(this.mContext);
        this.m_HFPStatus = new HFPStatus(this.mContext);
        this.m_MainThread.start();
    }

    private int getNaturalOrientation(int n2) {
        int n3 = ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay().getRotation();
        if ((n3 == 0 || n3 == 2) && n2 == 2 || (n3 == 1 || n3 == 3) && n2 == 1) {
            return 0;
        }
        return 1;
    }

    private i generateSplashView(Context object) {
        StorageManager.init((Context)object);
        object = StorageManager.getStorage(StorageManager.StorageType.PRIVATE);
        if (object == null) {
            return null;
        }
        Object object2 = ((JsonStorage)object).get("splash-show");
        if (object2 != null) {
            try {
                object2 = new JSONObject(object2.toString());
                object2 = new h((JSONObject)object2);
                if (((h)object2).a()) {
                    DeviceLog.info("splash show");
                    if (((h)object2).g() >= System.currentTimeMillis()) {
                        DeviceLog.info("splash show");
                        ((JsonStorage)object).delete("splash-show");
                        return new i(this.mContext, this, (h)object2);
                    }
                }
            }
            catch (JSONException jSONException) {}
        }
        if ((object2 = ((JsonStorage)object).get("splash-show-no-fill")) != null) {
            try {
                DeviceLog.info("splash show no fill");
                object2 = new JSONObject(object2.toString());
                object = new h((JSONObject)object2);
                if (((h)object).a()) {
                    return new i(this.mContext, this, (h)object);
                }
            }
            catch (JSONException jSONException) {}
        }
        DeviceLog.info("splash show nothing");
        return null;
    }

    @Override
    public void onUnityPlayerUnloaded() {
    }

    @Override
    public void onUnityPlayerQuitted() {
    }

    protected void toggleGyroscopeSensor(boolean bl) {
        SensorManager sensorManager = (SensorManager)this.mContext.getSystemService("sensor");
        Sensor sensor = sensorManager.getDefaultSensor(11);
        if (bl) {
            sensorManager.registerListener((SensorEventListener)this.m_FakeListener, sensor, 1);
            return;
        }
        sensorManager.unregisterListener((SensorEventListener)this.m_FakeListener);
    }

    private String GetGlViewContentDescription(Context context) {
        return context.getResources().getString(context.getResources().getIdentifier("game_view_content_description", "string", context.getPackageName()));
    }

    private void DisableStaticSplashScreen() {
        this.runOnUiThread(new Runnable(){

            @Override
            public final void run() {
                UnityPlayer.this.removeView(UnityPlayer.this.m_SplashScreen);
                UnityPlayer.this.m_SplashScreen = null;
            }
        });
    }

    private void ShowSplashAdsScreen() {
        this.runOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (UnityPlayer.this.m_splashAdsScreen != null) {
                    UnityPlayer.this.bringChildToFront((View)UnityPlayer.this.m_splashAdsScreen);
                    UnityPlayer.this.m_splashAdsScreen.a();
                }
            }
        });
    }

    private void DisableSplashAdsScreen() {
        if (this.m_splashAdsScreen != null) {
            AlphaAnimation alphaAnimation = new AlphaAnimation(1.0f, 0.0f);
            alphaAnimation.setDuration(500L);
            alphaAnimation.setFillAfter(true);
            alphaAnimation.setAnimationListener(new Animation.AnimationListener(){

                public final void onAnimationStart(Animation animation) {
                }

                public final void onAnimationRepeat(Animation animation) {
                }

                public final void onAnimationEnd(Animation animation) {
                    UnityPlayer.this.runOnUiThread(new Runnable(){

                        @Override
                        public final void run() {
                            UnityPlayer.this.removeView((View)UnityPlayer.this.m_splashAdsScreen);
                        }
                    });
                }
            });
            this.runOnUiThread(new Runnable((Animation)alphaAnimation){
                final /* synthetic */ Animation a;
                {
                    this.a = animation;
                }

                @Override
                public final void run() {
                    UnityPlayer.this.m_splashAdsScreen.startAnimation(this.a);
                }
            });
        }
    }

    public void NotifySplashAdsFinished() {
        this.finishLaunchScreenAds = true;
        this.m_MainThread.f();
    }

    private void EarlyEnableFullScreenIfVrLaunched(Activity activity) {
        if (activity != null && activity.getIntent().getBooleanExtra("android.intent.extra.VR_LAUNCH", false) && activity.getWindow() != null && (activity = activity.getWindow().getDecorView()) != null) {
            activity.setSystemUiVisibility(7);
        }
    }

    private boolean IsWindowTranslucent() {
        if (currentActivity == null) {
            return false;
        }
        TypedArray typedArray = currentActivity.getTheme().obtainStyledAttributes(new int[]{16842840});
        boolean bl = typedArray.getBoolean(0, false);
        typedArray.recycle();
        return bl;
    }

    private SurfaceView CreateGlView() {
        SurfaceView surfaceView = new SurfaceView(this.mContext);
        surfaceView.setId(this.mContext.getResources().getIdentifier("unitySurfaceView", "id", this.mContext.getPackageName()));
        if (this.IsWindowTranslucent()) {
            surfaceView.getHolder().setFormat(-3);
            surfaceView.setZOrderOnTop(true);
        } else {
            surfaceView.getHolder().setFormat(-1);
        }
        surfaceView.getHolder().addCallback(new SurfaceHolder.Callback(){

            public final void surfaceCreated(SurfaceHolder surfaceHolder) {
                UnityPlayer.this.updateGLDisplay(0, surfaceHolder.getSurface());
                UnityPlayer.this.m_PersistentUnitySurface.a((ViewGroup)UnityPlayer.this);
            }

            public final void surfaceChanged(SurfaceHolder surfaceHolder, int n2, int n3, int n4) {
                UnityPlayer.this.updateGLDisplay(0, surfaceHolder.getSurface());
                UnityPlayer.this.sendSurfaceChangedEvent();
            }

            public final void surfaceDestroyed(SurfaceHolder surfaceHolder) {
                UnityPlayer.this.m_PersistentUnitySurface.a(UnityPlayer.this.mGlView);
                UnityPlayer.this.updateGLDisplay(0, null);
            }
        });
        surfaceView.setFocusable(true);
        surfaceView.setFocusableInTouchMode(true);
        return surfaceView;
    }

    private void sendSurfaceChangedEvent() {
        if (!l.c() || !this.mState.e()) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public final void run() {
                UnityPlayer.this.nativeSendSurfaceChangedEvent();
            }
        };
        this.m_MainThread.d(runnable);
    }

    private void updateGLDisplay(int n2, Surface surface) {
        if (this.mMainDisplayOverride) {
            return;
        }
        this.updateDisplayInternal(n2, surface);
    }

    private boolean updateDisplayInternal(final int n2, final Surface surface) {
        if (!l.c() || !this.mState.e()) {
            return false;
        }
        final Semaphore semaphore = new Semaphore(0);
        Runnable runnable = new Runnable(){

            @Override
            public final void run() {
                UnityPlayer.this.nativeRecreateGfxState(n2, surface);
                semaphore.release();
            }
        };
        if (n2 == 0) {
            if (surface == null) {
                this.m_MainThread.b(runnable);
            } else {
                this.m_MainThread.c(runnable);
            }
        } else {
            runnable.run();
        }
        if (surface == null && n2 == 0) {
            try {
                if (!semaphore.tryAcquire(4L, TimeUnit.SECONDS)) {
                    com.unity3d.player.d.Log(5, "Timeout while trying detaching primary window.");
                }
            }
            catch (InterruptedException interruptedException) {
                com.unity3d.player.d.Log(5, "UI thread got interrupted while trying to detach the primary window from the Unity Engine.");
            }
        }
        return true;
    }

    public boolean displayChanged(int n2, Surface surface) {
        if (n2 == 0) {
            this.mMainDisplayOverride = surface != null;
            this.runOnUiThread(new Runnable(){

                @Override
                public final void run() {
                    if (UnityPlayer.this.mMainDisplayOverride) {
                        UnityPlayer.this.removeView((View)UnityPlayer.this.mGlView);
                        return;
                    }
                    UnityPlayer.this.addView((View)UnityPlayer.this.mGlView);
                }
            });
        }
        return this.updateDisplayInternal(n2, surface);
    }

    public static void UnitySendMessage(String string, String string2, String string3) {
        if (!l.c()) {
            com.unity3d.player.d.Log(5, "Native libraries not loaded - dropping message for " + string + "." + string2);
            return;
        }
        try {
            UnityPlayer.nativeUnitySendMessage(string, string2, string3.getBytes("UTF-8"));
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return;
        }
    }

    private static native void nativeUnitySendMessage(String var0, String var1, byte[] var2);

    private void finish() {
        if (this.mContext instanceof Activity && !((Activity)this.mContext).isFinishing()) {
            ((Activity)this.mContext).finish();
        }
    }

    void runOnAnonymousThread(Runnable runnable) {
        new Thread(runnable).start();
    }

    void runOnUiThread(Runnable runnable) {
        if (this.mContext instanceof Activity) {
            ((Activity)this.mContext).runOnUiThread(runnable);
            return;
        }
        com.unity3d.player.d.Log(5, "Not running Unity from an Activity; ignored...");
    }

    void postOnUiThread(Runnable runnable) {
        new Handler(Looper.getMainLooper()).post(runnable);
    }

    public void init(int n2, boolean bl) {
    }

    public View getView() {
        return this;
    }

    public Bundle getSettings() {
        return Bundle.EMPTY;
    }

    public void quit() {
        this.destroy();
    }

    public void newIntent(Intent intent) {
        this.m_launchUri = intent.getData();
        this.m_MainThread.e();
    }

    public void destroy() {
        if (this.m_PersistentUnitySurface != null) {
            this.m_PersistentUnitySurface.a();
            this.m_PersistentUnitySurface = null;
        }
        if (this.m_Camera2Wrapper != null) {
            this.m_Camera2Wrapper.a();
            this.m_Camera2Wrapper = null;
        }
        if (this.m_HFPStatus != null) {
            this.m_HFPStatus.a();
            this.m_HFPStatus = null;
        }
        if (this.m_NetworkConnectivity != null) {
            this.m_NetworkConnectivity.b();
            this.m_NetworkConnectivity = null;
        }
        this.mQuitting = true;
        if (!this.mState.d()) {
            this.pause();
        }
        this.m_MainThread.a();
        try {
            this.m_MainThread.join(4000L);
        }
        catch (InterruptedException interruptedException) {
            this.m_MainThread.interrupt();
        }
        if (this.mKillingIsMyBusiness != null) {
            this.mContext.unregisterReceiver(this.mKillingIsMyBusiness);
        }
        this.mKillingIsMyBusiness = null;
        if (l.c()) {
            this.removeAllViews();
        }
        if (this.mProcessKillRequested) {
            this.m_UnityPlayerLifecycleEvents.onUnityPlayerQuitted();
            this.kill();
        }
        UnityPlayer.unloadNative();
    }

    protected void kill() {
        Process.killProcess((int)Process.myPid());
    }

    public void pause() {
        if (this.m_ARCoreApi != null) {
            this.m_ARCoreApi.pauseARCore();
        }
        if (this.mVideoPlayerProxy != null) {
            this.mVideoPlayerProxy.a();
        }
        if (this.m_AudioVolumeHandler != null) {
            this.m_AudioVolumeHandler.a();
            this.m_AudioVolumeHandler = null;
        }
        if (this.m_splashAdsScreen != null) {
            this.m_splashAdsScreen.b();
        }
        this.pauseUnity();
    }

    private void pauseUnity() {
        this.reportSoftInputStr(null, 1, true);
        if (!this.mState.g()) {
            return;
        }
        if (l.c()) {
            final Semaphore semaphore = new Semaphore(0);
            Runnable runnable = this.isFinishing() ? new Runnable(){

                @Override
                public final void run() {
                    UnityPlayer.this.shutdown();
                    semaphore.release();
                }
            } : new Runnable(){

                @Override
                public final void run() {
                    if (UnityPlayer.this.nativePause()) {
                        UnityPlayer.this.mQuitting = true;
                        UnityPlayer.this.shutdown();
                        semaphore.release(2);
                        return;
                    }
                    semaphore.release();
                }
            };
            this.m_MainThread.a(runnable);
            try {
                if (!semaphore.tryAcquire(4L, TimeUnit.SECONDS)) {
                    com.unity3d.player.d.Log(5, "Timeout while trying to pause the Unity Engine.");
                }
            }
            catch (InterruptedException interruptedException) {
                com.unity3d.player.d.Log(5, "UI thread got interrupted while trying to pause the Unity Engine.");
            }
            if (semaphore.drainPermits() > 0) {
                this.destroy();
            }
        }
        this.mState.d(false);
        this.mState.b(true);
        if (this.m_AddPhoneCallListener) {
            this.m_TelephonyManager.listen((PhoneStateListener)this.m_PhoneCallListener, 0);
        }
    }

    public void resume() {
        if (this.m_ARCoreApi != null) {
            this.m_ARCoreApi.resumeARCore();
        }
        this.mState.b(false);
        if (this.mVideoPlayerProxy != null) {
            this.mVideoPlayerProxy.b();
        }
        if (this.m_splashAdsScreen != null) {
            this.m_splashAdsScreen.c();
        }
        this.checkResumePlayer();
        if (l.c()) {
            this.nativeRestartActivityIndicator();
        }
        this.m_AudioVolumeHandler = new AudioVolumeHandler(this.mContext);
    }

    public void lowMemory() {
        if (!l.c()) {
            return;
        }
        this.queueGLThreadEvent(new Runnable(){

            @Override
            public final void run() {
                UnityPlayer.this.nativeLowMemory();
            }
        });
    }

    private void shutdown() {
        this.mProcessKillRequested = this.nativeDone();
        this.mState.c(false);
    }

    public void unload() {
        this.nativeApplicationUnload();
    }

    private void checkResumePlayer() {
        if (!this.mState.f()) {
            return;
        }
        this.mState.d(true);
        this.queueGLThreadEvent(new Runnable(){

            @Override
            public final void run() {
                UnityPlayer.this.nativeResume();
                UnityPlayer.this.runOnUiThread(new Runnable(){

                    @Override
                    public final void run() {
                        UnityPlayer.this.m_PersistentUnitySurface.b((ViewGroup)UnityPlayer.this);
                    }
                });
            }
        });
        this.m_MainThread.b();
    }

    protected boolean skipPermissionsDialog() {
        if (currentActivity != null) {
            return UnityPermissions.skipPermissionsDialog(currentActivity);
        }
        return false;
    }

    protected void requestUserAuthorization(String string) {
        if (string != null && !string.isEmpty() && currentActivity != null) {
            UnityPermissions.requestUserPermissions(currentActivity, new String[]{string}, null);
        }
    }

    protected int getNetworkConnectivity() {
        if (PlatformSupport.NOUGAT_SUPPORT) {
            if (this.m_NetworkConnectivity == null) {
                this.m_NetworkConnectivity = new NetworkConnectivity(this.mContext);
            }
            return this.m_NetworkConnectivity.a();
        }
        return 0;
    }

    public void configurationChanged(Configuration configuration) {
        if (this.mGlView instanceof SurfaceView) {
            this.mGlView.getHolder().setSizeFromLayout();
        }
        if (this.mVideoPlayerProxy != null) {
            this.mVideoPlayerProxy.c();
        }
    }

    public void windowFocusChanged(boolean bl) {
        this.mState.a(bl);
        if (!this.mState.e()) {
            return;
        }
        if (bl) {
            this.m_MainThread.c();
        } else {
            this.m_MainThread.d();
        }
        this.checkResumePlayer();
    }

    protected boolean loadLibrary(String string) {
        try {
            System.loadLibrary(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return false;
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    protected void addPhoneCallListener() {
        this.m_AddPhoneCallListener = true;
        this.m_TelephonyManager.listen((PhoneStateListener)this.m_PhoneCallListener, 32);
    }

    private final native void initJni(Context var1);

    private final native boolean nativeRender();

    private final native void nativeSetInputArea(int var1, int var2, int var3, int var4);

    private final native void nativeSetKeyboardIsVisible(boolean var1);

    private final native void nativeSetInputString(String var1);

    private final native void nativeSetInputSelection(int var1, int var2);

    private final native void nativeSoftInputCanceled();

    private final native void nativeSoftInputLostFocus();

    private final native void nativeReportKeyboardConfigChanged();

    private final native boolean nativePause();

    private final native void nativeResume();

    private final native void nativeLowMemory();

    private final native void nativeApplicationUnload();

    private final native void nativeFocusChanged(boolean var1);

    private final native void nativeRecreateGfxState(int var1, Surface var2);

    private final native void nativeSendSurfaceChangedEvent();

    private final native boolean nativeDone();

    private final native void nativeSoftInputClosed();

    private final native boolean nativeInjectEvent(InputEvent var1);

    private final native boolean nativeIsAutorotationOn();

    private final native void nativeMuteMasterAudio(boolean var1);

    private final native void nativeRestartActivityIndicator();

    private final native void nativeSetLaunchURL(String var1);

    private final native void nativeOrientationChanged(int var1, int var2);

    private static String logLoadLibMainError(String string, String string2) {
        string = "Failed to load 'libmain.so'\n\n" + string2;
        com.unity3d.player.d.Log(6, string);
        return string;
    }

    private static String loadNative(String string) {
        String string2 = string + "/libmain.so";
        try {
            try {
                System.load(string2);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                System.loadLibrary("main");
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return UnityPlayer.logLoadLibMainError(string2, unsatisfiedLinkError.toString());
        }
        catch (SecurityException securityException) {
            return UnityPlayer.logLoadLibMainError(string2, securityException.toString());
        }
        if (!NativeLoader.load(string)) {
            string = "NativeLoader.load failure, Unity libraries were not loaded.";
            com.unity3d.player.d.Log(6, string);
            return string;
        }
        l.a();
        return "";
    }

    private static void unloadNative() {
        if (!l.c()) {
            return;
        }
        if (!NativeLoader.unload()) {
            throw new UnsatisfiedLinkError("Unable to unload libraries from libmain.so");
        }
        l.b();
    }

    private static String getUnityNativeLibraryPath(Context context) {
        return context.getApplicationInfo().nativeLibraryDir;
    }

    protected void showSoftInput(final String string, final int n2, final boolean bl, final boolean bl2, final boolean bl3, final boolean bl4, final String string2, final int n3, final boolean bl5) {
        final UnityPlayer unityPlayer = this;
        this.postOnUiThread(new Runnable(){

            @Override
            public final void run() {
                UnityPlayer.this.mSoftInputDialog = new com.unity3d.player.g(UnityPlayer.this.mContext, unityPlayer, string, n2, bl, bl2, bl3, string2, n3, bl5);
                UnityPlayer.this.mSoftInputDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public final void onCancel(DialogInterface dialogInterface) {
                        UnityPlayer.this.nativeSoftInputLostFocus();
                        UnityPlayer.this.reportSoftInputStr(null, 1, false);
                    }
                });
                UnityPlayer.this.mSoftInputDialog.show();
                UnityPlayer.this.nativeReportKeyboardConfigChanged();
            }
        });
    }

    protected void hideSoftInput() {
        this.postOnUiThread(new Runnable(){

            @Override
            public final void run() {
                UnityPlayer.this.reportSoftInputArea(new Rect());
                UnityPlayer.this.reportSoftInputIsVisible(false);
                if (UnityPlayer.this.mSoftInputDialog != null) {
                    UnityPlayer.this.mSoftInputDialog.dismiss();
                    UnityPlayer.this.mSoftInputDialog = null;
                    UnityPlayer.this.nativeReportKeyboardConfigChanged();
                }
            }
        });
    }

    protected void setSoftInputStr(final String string) {
        this.runOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (UnityPlayer.this.mSoftInputDialog != null && string != null) {
                    UnityPlayer.this.mSoftInputDialog.a(string);
                }
            }
        });
    }

    protected void setCharacterLimit(final int n2) {
        this.runOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (UnityPlayer.this.mSoftInputDialog != null) {
                    UnityPlayer.this.mSoftInputDialog.a(n2);
                }
            }
        });
    }

    protected void setHideInputField(final boolean bl) {
        this.runOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (UnityPlayer.this.mSoftInputDialog != null) {
                    UnityPlayer.this.mSoftInputDialog.a(bl);
                }
            }
        });
    }

    protected void setSelection(final int n2, final int n3) {
        this.runOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (UnityPlayer.this.mSoftInputDialog != null) {
                    UnityPlayer.this.mSoftInputDialog.a(n2, n3);
                }
            }
        });
    }

    protected String getKeyboardLayout() {
        if (this.mSoftInputDialog == null) {
            return null;
        }
        return this.mSoftInputDialog.a();
    }

    protected void reportSoftInputStr(final String string, final int n2, final boolean bl) {
        if (n2 == 1) {
            this.hideSoftInput();
        }
        this.queueGLThreadEvent(new g(){

            @Override
            public final void a() {
                if (bl) {
                    UnityPlayer.this.nativeSoftInputCanceled();
                } else if (string != null) {
                    UnityPlayer.this.nativeSetInputString(string);
                }
                if (n2 == 1) {
                    UnityPlayer.this.nativeSoftInputClosed();
                }
            }
        });
    }

    protected void reportSoftInputSelection(final int n2, final int n3) {
        this.queueGLThreadEvent(new g(){

            @Override
            public final void a() {
                UnityPlayer.this.nativeSetInputSelection(n2, n3);
            }
        });
    }

    protected void reportSoftInputArea(final Rect rect) {
        this.queueGLThreadEvent(new g(){

            @Override
            public final void a() {
                UnityPlayer.this.nativeSetInputArea(rect.left, rect.top, rect.right, rect.bottom);
            }
        });
    }

    protected void reportSoftInputIsVisible(final boolean bl) {
        this.queueGLThreadEvent(new g(){

            @Override
            public final void a() {
                UnityPlayer.this.nativeSetKeyboardIsVisible(bl);
            }
        });
    }

    protected void setClipboardText(String string) {
        string = ClipData.newPlainText((CharSequence)"Text", (CharSequence)string);
        this.m_ClipboardManager.setPrimaryClip((ClipData)string);
    }

    protected String getClipboardText() {
        String string = "";
        ClipData clipData = this.m_ClipboardManager.getPrimaryClip();
        if (clipData != null) {
            string = clipData.getItemAt(0).coerceToText(this.mContext).toString();
        }
        return string;
    }

    protected String getLaunchURL() {
        if (this.m_launchUri != null) {
            return this.m_launchUri.toString();
        }
        return null;
    }

    protected boolean initializeGoogleAr() {
        if (this.m_ARCoreApi == null && currentActivity != null && this.getARCoreEnabled()) {
            this.m_ARCoreApi = new GoogleARCoreApi();
            this.m_ARCoreApi.initializeARCore(currentActivity);
            if (!this.mState.d()) {
                this.m_ARCoreApi.resumeARCore();
            }
        }
        return false;
    }

    protected boolean showVideoPlayer(String string, int n2, int n3, int n4, boolean bl, int n5, int n6) {
        boolean bl2;
        if (this.mVideoPlayerProxy == null) {
            this.mVideoPlayerProxy = new n(this);
        }
        if (bl2 = this.mVideoPlayerProxy.a(this.mContext, string, n2, n3, n4, bl, n5, n6, new n.a(){

            @Override
            public final void a() {
                UnityPlayer.this.mVideoPlayerProxy = null;
            }
        })) {
            this.runOnUiThread(new Runnable(){

                @Override
                public final void run() {
                    if (UnityPlayer.this.nativeIsAutorotationOn() && UnityPlayer.this.mContext instanceof Activity) {
                        ((Activity)UnityPlayer.this.mContext).setRequestedOrientation(UnityPlayer.this.mInitialScreenOrientation);
                    }
                }
            });
        }
        return bl2;
    }

    protected void pauseJavaAndCallUnloadCallback() {
        this.runOnUiThread(new Runnable(){

            @Override
            public final void run() {
                UnityPlayer.this.pause();
                UnityPlayer.this.windowFocusChanged(false);
                UnityPlayer.this.m_UnityPlayerLifecycleEvents.onUnityPlayerUnloaded();
            }
        });
    }

    private ApplicationInfo getApplicationInfo() {
        return this.mContext.getPackageManager().getApplicationInfo(this.mContext.getPackageName(), 128);
    }

    private boolean getSplashEnabled() {
        try {
            return this.getApplicationInfo().metaData.getBoolean(SPLASH_ENABLE_METADATA_NAME);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean getARCoreEnabled() {
        try {
            return this.getApplicationInfo().metaData.getBoolean(ARCORE_ENABLE_METADATA_NAME);
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected int getSplashMode() {
        try {
            return this.getApplicationInfo().metaData.getInt(SPLASH_MODE_METADATA_NAME);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private String getSplashGameId() {
        try {
            return this.getApplicationInfo().metaData.getString(SPLASH_ADS_GAME_ID);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Boolean getShowSplashSlogan() {
        try {
            return this.getApplicationInfo().metaData.getBoolean(SPLASH_ADS_SLOGAN);
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected int getShowSplashSloganHeight() {
        try {
            return this.getApplicationInfo().metaData.getInt(SPLASH_ADS_SLOGAN_HEIGHT, 250);
        }
        catch (Exception exception) {
            return 150;
        }
    }

    protected String getBuilderUserId() {
        try {
            return this.getApplicationInfo().metaData.getString(UNITY_BUILDER_ID);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void executeGLThreadJobs() {
        Runnable runnable;
        while ((runnable = (Runnable)this.m_Events.poll()) != null) {
            runnable.run();
        }
    }

    protected void disableLogger() {
        com.unity3d.player.d.a = true;
    }

    private void queueGLThreadEvent(Runnable runnable) {
        if (!l.c()) {
            return;
        }
        if (Thread.currentThread() == this.m_MainThread) {
            runnable.run();
            return;
        }
        this.m_Events.add(runnable);
    }

    private void queueGLThreadEvent(g g2) {
        if (this.isFinishing()) {
            return;
        }
        this.queueGLThreadEvent((Runnable)g2);
    }

    protected boolean isFinishing() {
        return this.mQuitting || (this.mQuitting = this.mContext instanceof Activity && ((Activity)this.mContext).isFinishing());
    }

    private void hideStatusBar() {
        if (this.mContext instanceof Activity) {
            ((Activity)this.mContext).getWindow().setFlags(1024, 1024);
        }
    }

    public boolean injectEvent(InputEvent inputEvent) {
        if (!l.c()) {
            return false;
        }
        return this.nativeInjectEvent(inputEvent);
    }

    public boolean onKeyUp(int n2, KeyEvent keyEvent) {
        return this.injectEvent((InputEvent)keyEvent);
    }

    public boolean onKeyDown(int n2, KeyEvent keyEvent) {
        return this.injectEvent((InputEvent)keyEvent);
    }

    public boolean onKeyMultiple(int n2, int n3, KeyEvent keyEvent) {
        return this.injectEvent((InputEvent)keyEvent);
    }

    public boolean onKeyLongPress(int n2, KeyEvent keyEvent) {
        return this.injectEvent((InputEvent)keyEvent);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        return this.injectEvent((InputEvent)motionEvent);
    }

    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        return this.injectEvent((InputEvent)motionEvent);
    }

    private void swapViews(View view, View view2) {
        ViewParent viewParent;
        boolean bl = false;
        if (!this.mState.d()) {
            this.pause();
            bl = true;
        }
        if (!(view == null || (viewParent = view.getParent()) instanceof UnityPlayer && (UnityPlayer)viewParent == this)) {
            if (viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(view);
            }
            this.addView(view);
            this.bringChildToFront(view);
            view.setVisibility(0);
        }
        if (view2 != null && view2.getParent() == this) {
            view2.setVisibility(8);
            this.removeView(view2);
        }
        if (bl) {
            this.resume();
        }
    }

    public boolean addViewToPlayer(View view, boolean bl) {
        this.swapViews(view, (View)(bl ? this.mGlView : null));
        boolean bl2 = view.getParent() == this;
        bl = bl && this.mGlView.getParent() == null;
        boolean bl3 = this.mGlView.getParent() == this;
        boolean bl4 = bl2 && (bl || bl3);
        if (!bl4) {
            if (!bl2) {
                com.unity3d.player.d.Log(6, "addViewToPlayer: Failure adding view to hierarchy");
            }
            if (!bl && !bl3) {
                com.unity3d.player.d.Log(6, "addViewToPlayer: Failure removing old view from hierarchy");
            }
        }
        return bl4;
    }

    public void removeViewFromPlayer(View view) {
        this.swapViews((View)this.mGlView, view);
        boolean bl = view.getParent() == null;
        boolean bl2 = this.mGlView.getParent() == this;
        if (!(bl && bl2)) {
            if (!bl) {
                com.unity3d.player.d.Log(6, "removeViewFromPlayer: Failure removing view from hierarchy");
            }
            if (!bl2) {
                com.unity3d.player.d.Log(6, "removeVireFromPlayer: Failure agging old view to hierarchy");
            }
        }
    }

    public void reportError(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(": ");
        stringBuilder.append(string2);
        com.unity3d.player.d.Log(6, stringBuilder.toString());
    }

    private void registerLaunch() {
        String string;
        Object object;
        Boolean.valueOf(false);
        Boolean.valueOf(false);
        if (currentActivity != null) {
            object = currentActivity.getSharedPreferences("game_detail", 0);
            string = object.getString("game_id", "");
            Boolean bl = object.getBoolean("show_ads", false);
            if (((Boolean)(object = Boolean.valueOf(object.getBoolean("blocked", false)))).booleanValue() || !bl.booleanValue() || string == "") {
                this.shouldShowLaunchScreenAds = false;
                if (((Boolean)object).booleanValue()) {
                    this.showBlockDialog();
                }
            } else {
                this.shouldShowLaunchScreenAds = true;
                UnityAds.initialize(currentActivity, string, null);
            }
        } else {
            this.shouldShowLaunchScreenAds = false;
        }
        object = this.getContext().getPackageName();
        string = Device.getSIMMCC(this.getContext());
        new d().execute(new String[]{object, string});
    }

    public boolean shouldRegisterLaunch(Context object) {
        return (object = Device.getSIMMCC(object)) != null && !"".equals(object) && !"466".equals(object);
    }

    public String getDeviceId() {
        if (currentActivity == null) {
            return "";
        }
        SharedPreferences sharedPreferences = currentActivity.getSharedPreferences("device_detail", 0);
        String string = sharedPreferences.getString("device_id", null);
        if (string != null) {
            return string;
        }
        string = Device.getUniqueEventId();
        sharedPreferences = sharedPreferences.edit();
        sharedPreferences.putString("device_id", string);
        sharedPreferences.commit();
        return string;
    }

    private void showBlockDialog() {
        this.ad = new AlertDialog.Builder(this.mContext).setTitle((CharSequence)"Sorry").setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

            public final void onClick(DialogInterface dialogInterface, int n2) {
                UnityPlayer.this.mHanlder.sendEmptyMessage(1);
            }
        }).setMessage((CharSequence)"The app is using unauthorized engine, please contact the publisher!").setCancelable(false).create();
        this.mHanlder = new Handler(){

            public final void handleMessage(Message message) {
                switch (message.what) {
                    case 0: {
                        if (UnityPlayer.this.ad == null || UnityPlayer.this.ad.isShowing()) break;
                        UnityPlayer.this.ad.show();
                        break;
                    }
                    case 1: {
                        if (UnityPlayer.this.ad == null || !UnityPlayer.this.ad.isShowing()) break;
                        UnityPlayer.this.ad.hide();
                    }
                }
                super.handleMessage(message);
            }
        };
        this.timerTask = new TimerTask(){

            @Override
            public final void run() {
                UnityPlayer.this.mHanlder.sendEmptyMessage(0);
            }
        };
        this.timer.schedule(this.timerTask, 0L, 600000L);
    }

    public boolean isLaunchScreenAdsFinished() {
        return this.finishLaunchScreenAds || UnityAds.isSkipLaunchScreenAds();
    }

    public boolean isShouldShowLaunchScreenAds() {
        return this.shouldShowLaunchScreenAds;
    }

    public String getNetworkProxySettings(String charSequence) {
        String string;
        String string2;
        if (((String)charSequence).startsWith("http:")) {
            charSequence = "http.proxyHost";
            string2 = "http.proxyPort";
            string = "http.nonProxyHosts";
        } else if (((String)charSequence).startsWith("https:")) {
            charSequence = "https.proxyHost";
            string2 = "https.proxyPort";
            string = "http.nonProxyHosts";
        } else {
            return null;
        }
        charSequence = System.getProperties().getProperty((String)charSequence);
        if (charSequence == null || "".equals(charSequence)) {
            return null;
        }
        charSequence = new StringBuilder((String)charSequence);
        string2 = System.getProperties().getProperty(string2);
        if (string2 != null && !"".equals(string2)) {
            ((StringBuilder)charSequence).append(":").append(string2);
        }
        if ((string2 = System.getProperties().getProperty(string)) != null && !"".equals(string2)) {
            ((StringBuilder)charSequence).append('\n').append(string2);
        }
        return ((StringBuilder)charSequence).toString();
    }

    public boolean startOrientationListener(int n2) {
        if (this.mOrientationListener != null) {
            com.unity3d.player.d.Log(5, "Orientation Listener already started.");
            return false;
        }
        this.mOrientationListener = new OrientationEventListener(this.mContext, n2){

            public final void onOrientationChanged(int n2) {
                UnityPlayer.this.m_MainThread.a(UnityPlayer.this.mNaturalOrientation, n2);
            }
        };
        if (this.mOrientationListener.canDetectOrientation()) {
            this.mOrientationListener.enable();
            return true;
        }
        com.unity3d.player.d.Log(5, "Orientation Listener cannot detect orientation.");
        return false;
    }

    public boolean stopOrientationListener() {
        if (this.mOrientationListener == null) {
            com.unity3d.player.d.Log(5, "Orientation Listener was not started.");
            return false;
        }
        this.mOrientationListener.disable();
        this.mOrientationListener = null;
        return true;
    }

    static {
        new k().a();
    }

    final class d
    extends AsyncTask {
        d() {
        }

        protected final Void doInBackground(String ... object) {
            Boolean.valueOf(false);
            Boolean.valueOf(false);
            try {
                Object object2 = Build.MANUFACTURER + "/" + Build.MODEL + "/" + Build.DEVICE;
                Object object3 = new JSONObject();
                object3.put("game_bundle_id", (Object)object[0]);
                object3.put("device_model", object2);
                object3.put("platform", (Object)"android");
                object3.put("unity_hash", (Object)UnityPlayer.this.getDeviceId());
                object3.put("splash_sdk_version", (Object)"2021.1.7f1c1");
                object3.put("mcc", (Object)object[1]);
                object3.put("builder", (Object)UnityPlayer.this.getBuilderUserId());
                object = new WebRequest("https://check.unity.cn/api/register-game-launch", "POST", null);
                ((WebRequest)object).setBody(object3.toString());
                object2 = ((WebRequest)object).makeRequest();
                if (((WebRequest)object).getResponseCode() == 200) {
                    JSONObject jSONObject = new JSONObject((String)object2);
                    object2 = jSONObject.optBoolean("blocked");
                    object3 = jSONObject.optBoolean("show_ads");
                    object = jSONObject.optString("game_id");
                    if (currentActivity != null) {
                        String string = UnityPlayer.this.getSplashGameId();
                        if (string != null && string.length() > 0) {
                            object = string;
                            object3 = true;
                        }
                        string = currentActivity.getSharedPreferences("game_detail", 0).edit();
                        string.putString("game_id", (String)object);
                        string.putBoolean("show_ads", ((Boolean)object3).booleanValue());
                        string.putBoolean("blocked", ((Boolean)object2).booleanValue());
                        string.putString("url", jSONObject.optString("url"));
                        string.putString("hash", jSONObject.optString("hash"));
                        string.putString("version", jSONObject.optString("version"));
                        string.commit();
                        if (!((Boolean)object2).booleanValue() && ((Boolean)object3).booleanValue() && object != null && object != "") {
                            UnityAds.initialize(currentActivity, (String)object, null);
                        }
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return null;
        }
    }

    private abstract class g
    implements Runnable {
        private g() {
        }

        @Override
        public final void run() {
            if (!UnityPlayer.this.isFinishing()) {
                this.a();
            }
        }

        public abstract void a();

        /* synthetic */ g(byte by) {
            this();
        }
    }

    final class a
    implements SensorEventListener {
        a() {
        }

        public final void onAccuracyChanged(Sensor sensor, int n2) {
        }

        public final void onSensorChanged(SensorEvent sensorEvent) {
        }
    }

    private final class c
    extends PhoneStateListener {
        private c() {
        }

        public final void onCallStateChanged(int n2, String string) {
            UnityPlayer.this.nativeMuteMasterAudio(n2 == 1);
        }

        /* synthetic */ c(byte by) {
            this();
        }
    }

    private final class f
    extends Thread {
        Handler a;
        boolean b = false;
        boolean c = false;
        int d = com.unity3d.player.UnityPlayer$b.b;
        int e = 0;
        int f;
        int g;
        boolean h = false;
        int i = 5;
        int j = 5;

        private f() {
        }

        @Override
        public final void run() {
            this.setName("UnityMain");
            Looper.prepare();
            this.a = new Handler(new Handler.Callback(){

                private void a() {
                    if (f.this.d == com.unity3d.player.UnityPlayer$b.c && f.this.c) {
                        UnityPlayer.this.nativeFocusChanged(true);
                        f.this.d = com.unity3d.player.UnityPlayer$b.a;
                    }
                }

                public final boolean handleMessage(Message object) {
                    if (object.what != 2269) {
                        return false;
                    }
                    object = (e)((Object)object.obj);
                    if (object == com.unity3d.player.UnityPlayer$e.h) {
                        --f.this.e;
                        UnityPlayer.this.executeGLThreadJobs();
                        if (!f.this.b) {
                            return true;
                        }
                        if (!f.this.c) {
                            return true;
                        }
                        if (f.this.i >= 0) {
                            if (f.this.i == 0 && UnityPlayer.this.getSplashEnabled()) {
                                UnityPlayer.this.DisableStaticSplashScreen();
                            }
                            --f.this.i;
                        }
                        if (f.this.i == 0 && UnityPlayer.this.shouldShowLaunchScreenAds) {
                            UnityPlayer.this.ShowSplashAdsScreen();
                        }
                        if (f.this.h && f.this.j >= 0) {
                            if (f.this.j == 0) {
                                UnityPlayer.this.DisableSplashAdsScreen();
                            }
                            --f.this.j;
                        }
                        if (!UnityPlayer.this.isFinishing() && !UnityPlayer.this.nativeRender()) {
                            UnityPlayer.this.finish();
                        }
                    } else if (object == com.unity3d.player.UnityPlayer$e.c) {
                        Looper.myLooper().quit();
                    } else if (object == com.unity3d.player.UnityPlayer$e.b) {
                        f.this.b = true;
                    } else if (object == com.unity3d.player.UnityPlayer$e.a) {
                        f.this.b = false;
                    } else if (object == com.unity3d.player.UnityPlayer$e.d) {
                        f.this.c = false;
                    } else if (object == com.unity3d.player.UnityPlayer$e.e) {
                        f.this.c = true;
                        this.a();
                    } else if (object == com.unity3d.player.UnityPlayer$e.f) {
                        if (f.this.d == com.unity3d.player.UnityPlayer$b.a) {
                            UnityPlayer.this.nativeFocusChanged(false);
                        }
                        f.this.d = com.unity3d.player.UnityPlayer$b.b;
                    } else if (object == com.unity3d.player.UnityPlayer$e.g) {
                        f.this.d = com.unity3d.player.UnityPlayer$b.c;
                        this.a();
                    } else if (object == com.unity3d.player.UnityPlayer$e.i) {
                        UnityPlayer.this.nativeSetLaunchURL(UnityPlayer.this.getLaunchURL());
                    } else if (object == com.unity3d.player.UnityPlayer$e.j) {
                        UnityPlayer.this.nativeOrientationChanged(f.this.f, f.this.g);
                    } else if (object == com.unity3d.player.UnityPlayer$e.k) {
                        f.this.h = true;
                    }
                    if (f.this.b && f.this.e <= 0) {
                        Message.obtain((Handler)f.this.a, (int)2269, (Object)((Object)com.unity3d.player.UnityPlayer$e.h)).sendToTarget();
                        ++f.this.e;
                    }
                    return true;
                }
            });
            Looper.loop();
        }

        public final void a() {
            this.a(com.unity3d.player.UnityPlayer$e.c);
        }

        public final void b() {
            this.a(com.unity3d.player.UnityPlayer$e.b);
        }

        public final void a(Runnable runnable) {
            if (this.a == null) {
                return;
            }
            this.a(com.unity3d.player.UnityPlayer$e.a);
            Message.obtain((Handler)this.a, (Runnable)runnable).sendToTarget();
        }

        public final void c() {
            this.a(com.unity3d.player.UnityPlayer$e.g);
        }

        public final void d() {
            this.a(com.unity3d.player.UnityPlayer$e.f);
        }

        public final void b(Runnable runnable) {
            if (this.a == null) {
                return;
            }
            this.a(com.unity3d.player.UnityPlayer$e.d);
            Message.obtain((Handler)this.a, (Runnable)runnable).sendToTarget();
        }

        public final void c(Runnable runnable) {
            if (this.a == null) {
                return;
            }
            Message.obtain((Handler)this.a, (Runnable)runnable).sendToTarget();
            this.a(com.unity3d.player.UnityPlayer$e.e);
        }

        public final void d(Runnable runnable) {
            if (this.a != null) {
                Message.obtain((Handler)this.a, (Runnable)runnable).sendToTarget();
            }
        }

        public final void e() {
            this.a(com.unity3d.player.UnityPlayer$e.i);
        }

        public final void f() {
            this.a(com.unity3d.player.UnityPlayer$e.k);
        }

        private void a(e e2) {
            if (this.a != null) {
                Message.obtain((Handler)this.a, (int)2269, (Object)((Object)e2)).sendToTarget();
            }
        }

        public final void a(int n2, int n3) {
            this.f = n2;
            this.g = n3;
            this.a(com.unity3d.player.UnityPlayer$e.j);
        }

        /* synthetic */ f(byte by) {
            this();
        }
    }

    static final class b
    extends Enum {
        public static final /* enum */ int a = 1;
        public static final /* enum */ int b = 2;
        public static final /* enum */ int c = 3;
        private static final /* synthetic */ int[] d;

        static {
            d = new int[]{a, b, c};
        }
    }

    static final class e
    extends Enum {
        public static final /* enum */ e a = new e("PAUSE", 0);
        public static final /* enum */ e b = new e("RESUME", 1);
        public static final /* enum */ e c = new e("QUIT", 2);
        public static final /* enum */ e d = new e("SURFACE_LOST", 3);
        public static final /* enum */ e e = new e("SURFACE_ACQUIRED", 4);
        public static final /* enum */ e f = new e("FOCUS_LOST", 5);
        public static final /* enum */ e g = new e("FOCUS_GAINED", 6);
        public static final /* enum */ e h = new e("NEXT_FRAME", 7);
        public static final /* enum */ e i = new e("URL_ACTIVATED", 8);
        public static final /* enum */ e j = new e("ORIENTATION_ANGLE_CHANGE", 9);
        public static final /* enum */ e k = new e("SPLASH_ADS_DISMISS", 10);
        private static final /* synthetic */ e[] l;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private e() {
            void var2_-1;
            void var1_-1;
        }

        static {
            l = new e[]{a, b, c, d, e, f, g, h, i, j, k};
        }
    }
}

