/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.player;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import com.unity3d.player.IPermissionRequestCallbacks;
import com.unity3d.player.PlatformSupport;
import com.unity3d.player.e;

public class UnityPermissions {
    private static final String SKIP_DIALOG_METADATA_NAME = "unityplayer.SkipPermissionsDialog";

    private static boolean checkInfoForMetadata(PackageItemInfo packageItemInfo) {
        try {
            return packageItemInfo.metaData.getBoolean(SKIP_DIALOG_METADATA_NAME);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean skipPermissionsDialog(Activity activity) {
        if (!PlatformSupport.MARSHMALLOW_SUPPORT) {
            return false;
        }
        try {
            PackageManager packageManager = activity.getPackageManager();
            ActivityInfo activityInfo = packageManager.getActivityInfo(activity.getComponentName(), 128);
            activity = packageManager.getApplicationInfo(activity.getPackageName(), 128);
            if (UnityPermissions.checkInfoForMetadata((PackageItemInfo)activityInfo) || UnityPermissions.checkInfoForMetadata((PackageItemInfo)activity)) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public static boolean hasUserAuthorizedPermission(Activity activity, String string) {
        return activity.checkCallingOrSelfPermission(string) == 0;
    }

    public static void requestUserPermissions(Activity object, String[] fragmentTransaction, IPermissionRequestCallbacks iPermissionRequestCallbacks) {
        String string;
        if (!PlatformSupport.MARSHMALLOW_SUPPORT) {
            return;
        }
        if (object == null || fragmentTransaction == null) {
            return;
        }
        FragmentManager fragmentManager = object.getFragmentManager();
        if (fragmentManager.findFragmentByTag(string = "96489") == null) {
            object = new e((Activity)object, iPermissionRequestCallbacks);
            iPermissionRequestCallbacks = new Bundle();
            iPermissionRequestCallbacks.putStringArray("PermissionNames", (String[])fragmentTransaction);
            object.setArguments((Bundle)iPermissionRequestCallbacks);
            fragmentTransaction = fragmentManager.beginTransaction();
            fragmentTransaction.add(0, (Fragment)object, string);
            fragmentTransaction.commit();
        }
    }
}

