/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Surface;
import android.view.TextureView;
import com.serenegiant.encoder.IVideoEncoder;
import com.serenegiant.encoder.MediaEncoder;
import com.serenegiant.encoder.MediaVideoEncoder;
import com.serenegiant.opengl.EGLBase;
import com.serenegiant.opengl.GLDrawer2D;
import com.serenegiant.opengl.GLHelper;
import com.serenegiant.utils.FpsCounter;
import com.serenegiant.uvccamera.BuildConfig;
import com.serenegiant.widget.AspectRatioTextureView;
import com.serenegiant.widget.CameraViewInterface;

public class UVCCameraTextureView
extends AspectRatioTextureView
implements TextureView.SurfaceTextureListener,
CameraViewInterface {
    private static final boolean DEBUG = BuildConfig.DEBUG;
    private static final String TAG = UVCCameraTextureView.class.getSimpleName();
    private boolean mHasSurfaceTexture;
    private RenderAgent mRenderAgent;
    private Object mCaptureSync = new Object();
    private Bitmap mTempBitmap;
    private boolean mRequestCaptureStillImage;
    private CameraViewInterface.Callback mCallback;
    private FpsCounter mFpsCounter = new FpsCounter();
    private Surface mPreviewSurface;

    public UVCCameraTextureView(Context context) {
        this(context, null, 0);
    }

    public UVCCameraTextureView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public UVCCameraTextureView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setSurfaceTextureListener(this);
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("onSurfaceTextureAvailable:" + surfaceTexture));
        }
        if (this.mRenderAgent == null) {
            this.mRenderAgent = new RenderAgent(this.mFpsCounter, surfaceTexture, width, height);
        } else {
            this.mRenderAgent.resize(width, height);
        }
        this.mHasSurfaceTexture = true;
        if (this.mCallback != null) {
            this.mCallback.onSurfaceCreated(this, this.getSurface());
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("onSurfaceTextureSizeChanged:" + surfaceTexture));
        }
        if (this.mCallback != null) {
            this.mCallback.onSurfaceDestroy(this, this.getSurface());
        }
        if (this.mPreviewSurface != null) {
            this.mPreviewSurface.release();
            this.mPreviewSurface = null;
        }
        this.mRenderAgent.resize(width, height);
        if (this.mCallback != null) {
            this.mCallback.onSurfaceCreated(this, this.getSurface());
        }
        if (this.mCallback != null) {
            this.mCallback.onSurfaceChanged(this, this.getSurface(), width, height);
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("onSurfaceTextureDestroyed:" + surfaceTexture));
        }
        if (this.mRenderAgent != null) {
            this.mRenderAgent.release();
            this.mRenderAgent = null;
        }
        this.mHasSurfaceTexture = false;
        if (this.mCallback != null) {
            this.mCallback.onSurfaceDestroy(this, this.getSurface());
        }
        if (this.mPreviewSurface != null) {
            this.mPreviewSurface.release();
            this.mPreviewSurface = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        Object object = this.mCaptureSync;
        synchronized (object) {
            if (this.mRequestCaptureStillImage) {
                this.mRequestCaptureStillImage = false;
                if (this.mTempBitmap == null) {
                    this.mTempBitmap = this.getBitmap();
                } else {
                    this.getBitmap(this.mTempBitmap);
                }
                this.mCaptureSync.notifyAll();
            }
        }
    }

    @Override
    public boolean hasSurface() {
        return this.mHasSurfaceTexture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitmap captureStillImage() {
        Object object = this.mCaptureSync;
        synchronized (object) {
            this.mRequestCaptureStillImage = true;
            try {
                this.mCaptureSync.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.mTempBitmap;
        }
    }

    @Override
    public SurfaceTexture getSurfaceTexture() {
        return this.mRenderAgent != null ? this.mRenderAgent.getPreviewTexture() : null;
    }

    @Override
    public Surface getSurface() {
        SurfaceTexture st;
        if (DEBUG) {
            Log.v((String)TAG, (String)("getSurface:hasSurface=" + this.mHasSurfaceTexture));
        }
        if (this.mPreviewSurface == null && (st = this.getSurfaceTexture()) != null) {
            this.mPreviewSurface = new Surface(st);
        }
        return this.mPreviewSurface;
    }

    @Override
    public void setVideoEncoder(IVideoEncoder encoder) {
        if (this.mRenderAgent != null) {
            this.mRenderAgent.setVideoEncoder(encoder);
        }
    }

    @Override
    public void setCallback(CameraViewInterface.Callback callback) {
        this.mCallback = callback;
    }

    public void resetFps() {
        this.mFpsCounter.reset();
    }

    public void updateFps() {
        this.mFpsCounter.update();
    }

    public float getFps() {
        return this.mFpsCounter.getFps();
    }

    public float getTotalFps() {
        return this.mFpsCounter.getTotalFps();
    }

    private static final class RenderAgent
    implements SurfaceTexture.OnFrameAvailableListener {
        private RenderHandler mThread;
        private boolean mIsActive = true;
        private FpsCounter mFpsCounter;
        private static final int MSG_INIT = 0;
        private static final int MSG_REQUEST_RENDER = 1;
        private static final int MSG_SET_ENCODER = 2;
        private static final int MSG_CREATE_SURFACE_TEXTURE = 3;
        private static final int MSG_RESIZE = 4;
        private static final int MSG_RELEASE = 9;

        public RenderAgent(FpsCounter counter, SurfaceTexture surface, int width, int height) {
            this.mThread = new RenderHandler(this, surface, width, height);
            this.mThread.sendEmptyMessage(0);
            this.mFpsCounter = counter;
        }

        public final void setVideoEncoder(IVideoEncoder encoder) {
            if (DEBUG) {
                Log.v((String)TAG, (String)"setVideoEncoder:");
            }
            if (this.mIsActive) {
                this.mThread.sendMessage(this.mThread.obtainMessage(2, encoder));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final SurfaceTexture getPreviewTexture() {
            if (DEBUG) {
                Log.v((String)TAG, (String)"getPreviewTexture:");
            }
            if (this.mIsActive) {
                Object object = this.mThread.mSync;
                synchronized (object) {
                    this.mThread.sendEmptyMessage(3);
                    try {
                        this.mThread.mSync.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return this.mThread.mPreviewSurfaceTexture;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resize(int width, int height) {
            if (DEBUG) {
                Log.v((String)TAG, (String)"resize:");
            }
            if (this.mIsActive) {
                Object object = this.mThread.mSync;
                synchronized (object) {
                    this.mThread.sendMessage(this.mThread.obtainMessage(4, width, height));
                    try {
                        this.mThread.mSync.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        public final void release() {
            if (DEBUG) {
                Log.v((String)TAG, (String)"release:");
            }
            if (this.mIsActive) {
                this.mIsActive = false;
                this.mThread.removeMessages(1);
                this.mThread.removeMessages(2);
                this.mThread.sendEmptyMessage(9);
            }
        }

        public final void onFrameAvailable(SurfaceTexture surfaceTexture) {
            if (this.mIsActive) {
                this.mFpsCounter.count();
                this.mThread.sendEmptyMessage(1);
            }
        }

        private static final class RenderHandler
        extends Handler {
            private static String TAG_HANDLER = RenderHandler.class.getSimpleName();
            private Object mSync = new Object();
            private SurfaceTexture mSurface;
            private RenderAgent mParent;
            private EGLBase mEgl;
            private EGLBase.IEglSurface mEglSurface;
            private GLDrawer2D mDrawer;
            private int mTexId = -1;
            private SurfaceTexture mPreviewSurfaceTexture;
            private float[] mStMatrix = new float[16];
            private MediaEncoder mEncoder;
            private int mViewWidth;
            private int mViewHeight;

            public RenderHandler(RenderAgent renderAgent, SurfaceTexture surface, int width, int height) {
                super(RenderHandler.createLooper());
                this.mParent = renderAgent;
                this.mSurface = surface;
                this.mViewWidth = width;
                this.mViewHeight = height;
            }

            private static Looper createLooper() {
                HandlerThread thread = new HandlerThread("RenderThread", -1);
                thread.start();
                return thread.getLooper();
            }

            public final void handleMessage(Message msg) {
                switch (msg.what) {
                    case 0: {
                        this.init();
                        break;
                    }
                    case 1: {
                        this.onDrawFrame();
                        break;
                    }
                    case 2: {
                        this.setEncoder((MediaEncoder)msg.obj);
                        break;
                    }
                    case 3: {
                        this.updatePreviewSurfaceTexture();
                        break;
                    }
                    case 4: {
                        this.resize(msg.arg1, msg.arg2);
                        break;
                    }
                    case 9: {
                        this.release();
                        break;
                    }
                    default: {
                        super.handleMessage(msg);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void resize(int width, int height) {
                if (width > 0 && width != this.mViewWidth || height > 0 && height != this.mViewHeight) {
                    this.mViewWidth = width;
                    this.mViewHeight = height;
                    this.updatePreviewSurfaceTexture();
                } else {
                    Object object = this.mSync;
                    synchronized (object) {
                        this.mSync.notifyAll();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void updatePreviewSurfaceTexture() {
                if (DEBUG) {
                    Log.i((String)TAG, (String)(TAG_HANDLER + "#updatePreviewSurfaceTexture:"));
                }
                Object object = this.mSync;
                synchronized (object) {
                    if (this.mPreviewSurfaceTexture != null) {
                        if (DEBUG) {
                            Log.d((String)TAG, (String)"updatePreviewSurfaceTexture:release mPreviewSurface");
                        }
                        this.mPreviewSurfaceTexture.setOnFrameAvailableListener(null);
                        this.mPreviewSurfaceTexture.release();
                        this.mPreviewSurfaceTexture = null;
                    }
                    this.mEglSurface.makeCurrent();
                    if (this.mTexId >= 0) {
                        this.mDrawer.deleteTex(this.mTexId);
                    }
                    this.mTexId = this.mDrawer.initTex();
                    if (DEBUG) {
                        Log.v((String)TAG, (String)("updatePreviewSurfaceTexture:tex_id=" + this.mTexId));
                    }
                    this.mPreviewSurfaceTexture = new SurfaceTexture(this.mTexId);
                    this.mPreviewSurfaceTexture.setDefaultBufferSize(this.mViewWidth, this.mViewHeight);
                    this.mPreviewSurfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this.mParent);
                    this.mSync.notifyAll();
                }
            }

            public final void setEncoder(MediaEncoder encoder) {
                if (DEBUG) {
                    Log.v((String)TAG, (String)(TAG_HANDLER + "#setEncoder:encoder=" + encoder));
                }
                if (encoder != null && encoder instanceof MediaVideoEncoder) {
                    ((MediaVideoEncoder)encoder).setEglContext(this.mEglSurface.getContext(), this.mTexId);
                }
                this.mEncoder = encoder;
            }

            public final void onDrawFrame() {
                this.mEglSurface.makeCurrent();
                this.mPreviewSurfaceTexture.updateTexImage();
                this.mPreviewSurfaceTexture.getTransformMatrix(this.mStMatrix);
                if (this.mEncoder != null) {
                    if (this.mEncoder instanceof MediaVideoEncoder) {
                        ((MediaVideoEncoder)this.mEncoder).frameAvailableSoon(this.mStMatrix);
                    } else {
                        this.mEncoder.frameAvailableSoon();
                    }
                }
                this.mDrawer.draw(this.mTexId, this.mStMatrix, 0);
                this.mEglSurface.swap();
            }

            private void init() {
                if (DEBUG) {
                    Log.v((String)TAG, (String)(TAG_HANDLER + "#init:"));
                }
                this.mEgl = EGLBase.createFrom(null, false, false);
                this.mEglSurface = this.mEgl.createFromSurface(this.mSurface);
                this.mEglSurface.makeCurrent();
                this.mDrawer = new GLDrawer2D(true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void release() {
                if (DEBUG) {
                    Log.v((String)TAG, (String)(TAG_HANDLER + "#release:"));
                }
                if (this.mDrawer != null) {
                    this.mDrawer.release();
                    this.mDrawer = null;
                }
                if (this.mPreviewSurfaceTexture != null) {
                    this.mPreviewSurfaceTexture.release();
                    this.mPreviewSurfaceTexture = null;
                }
                if (this.mTexId >= 0) {
                    GLHelper.deleteTex(this.mTexId);
                    this.mTexId = -1;
                }
                if (this.mEglSurface != null) {
                    this.mEglSurface.release();
                    this.mEglSurface = null;
                }
                if (this.mEgl != null) {
                    this.mEgl.release();
                    this.mEgl = null;
                }
                Object object = this.mSync;
                synchronized (object) {
                    this.mParent = null;
                    this.mSync.notifyAll();
                }
            }
        }
    }
}

