/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.encoder.helper;

import android.app.Application;
import android.content.Context;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Handler;
import android.util.Log;
import com.serenegiant.encoder.MediaAudioEncoder;
import com.serenegiant.encoder.MediaEncoder;
import com.serenegiant.encoder.MediaMuxerWrapper;
import com.serenegiant.encoder.MediaSurfaceEncoder;
import com.serenegiant.usb.Size;
import com.serenegiant.usb.UVCCamera;
import com.serenegiant.utils.HandlerThreadHandler;
import com.serenegiant.utils.UVCUtils;
import com.serenegiant.utils.UriHelper;
import com.serenegiant.uvccamera.BuildConfig;
import java.io.IOException;
import java.lang.ref.WeakReference;

public class MediaSurfaceEncoderHelper {
    private static final String TAG = MediaSurfaceEncoderHelper.class.getSimpleName();
    private final Object mSync = new Object();
    private MediaMuxerWrapper mMuxer;
    private MediaSurfaceEncoder mVideoEncoder;
    private WeakReference<UVCCamera> mWeakCamera;
    private Size mSize;
    private boolean mIsRecording;
    private Handler mAsyncHandler = HandlerThreadHandler.createHandler(TAG);
    private final MediaEncoder.MediaEncoderListener mVideoEncoderListener = new MediaEncoder.MediaEncoderListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPrepared(MediaEncoder encoder) {
            if (BuildConfig.DEBUG) {
                Log.v((String)TAG, (String)("onPrepared:videoEncoder=" + encoder));
            }
            MediaSurfaceEncoderHelper.this.mIsRecording = true;
            Object object = MediaSurfaceEncoderHelper.this.mSync;
            synchronized (object) {
                if (MediaSurfaceEncoderHelper.this.mWeakCamera.get() != null) {
                    ((UVCCamera)MediaSurfaceEncoderHelper.this.mWeakCamera.get()).startCapture(MediaSurfaceEncoderHelper.this.mVideoEncoder.getInputSurface());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStopped(MediaEncoder encoder) {
            if (BuildConfig.DEBUG) {
                Log.v((String)TAG, (String)("onStopped:videoEncoder=" + encoder));
            }
            try {
                MediaSurfaceEncoderHelper.this.mIsRecording = false;
                Object object = MediaSurfaceEncoderHelper.this.mSync;
                synchronized (object) {
                    if (MediaSurfaceEncoderHelper.this.mWeakCamera.get() != null) {
                        ((UVCCamera)MediaSurfaceEncoderHelper.this.mWeakCamera.get()).stopCapture();
                    }
                }
                Uri uri = encoder.getOutputUri();
                if (uri != null) {
                    MediaSurfaceEncoderHelper.this.mAsyncHandler.postDelayed(() -> {
                        Application context = UVCUtils.getApplication();
                        String path = UriHelper.getPath((Context)context, uri);
                        try {
                            if (BuildConfig.DEBUG) {
                                Log.i((String)TAG, (String)"MediaScannerConnection#scanFile");
                            }
                            MediaScannerConnection.scanFile((Context)context, (String[])new String[]{path}, null, null);
                        }
                        catch (Exception e) {
                            Log.e((String)TAG, (String)"MediaScannerConnection:", (Throwable)e);
                        }
                    }, 500L);
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"onStopped:", (Throwable)e);
            }
        }
    };
    private final MediaEncoder.MediaEncoderListener mAudioEncoderListener = new MediaEncoder.MediaEncoderListener(){

        @Override
        public void onPrepared(MediaEncoder encoder) {
            if (BuildConfig.DEBUG) {
                Log.v((String)TAG, (String)("onPrepared:audioEncoder=" + encoder));
            }
        }

        @Override
        public void onStopped(MediaEncoder encoder) {
            if (BuildConfig.DEBUG) {
                Log.v((String)TAG, (String)("onStopped:audioEncoder=" + encoder));
            }
        }
    };

    public MediaSurfaceEncoderHelper(UVCCamera camera) {
        this.setCamera(camera);
    }

    public void setCamera(UVCCamera camera) {
        this.mWeakCamera = new WeakReference<UVCCamera>(camera);
        this.mSize = camera.getPreviewSize();
    }

    public boolean isRecording() {
        return this.mIsRecording;
    }

    public void startRecording(Uri uri) {
        if (BuildConfig.DEBUG) {
            Log.v((String)TAG, (String)"startRecording:");
        }
        this.mAsyncHandler.post(() -> {
            try {
                if (this.mMuxer != null) {
                    return;
                }
                Object object = this.mSync;
                synchronized (object) {
                    this.mMuxer = new MediaMuxerWrapper(uri);
                    this.mVideoEncoder = new MediaSurfaceEncoder(this.mMuxer, this.mSize.width, this.mSize.height, this.mVideoEncoderListener);
                    new MediaAudioEncoder(this.mMuxer, this.mAudioEncoderListener);
                }
                this.mMuxer.prepare();
                this.mMuxer.startRecording();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"startRecording:", (Throwable)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseRecording() {
        if (BuildConfig.DEBUG) {
            Log.v((String)TAG, (String)("pauseRecording:mMuxer=" + this.mMuxer));
        }
        Object object = this.mSync;
        synchronized (object) {
            this.mMuxer.pauseRecording();
            if (this.mWeakCamera.get() != null) {
                ((UVCCamera)this.mWeakCamera.get()).stopCapture();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeRecording() {
        if (BuildConfig.DEBUG) {
            Log.v((String)TAG, (String)("resumeRecording:mMuxer=" + this.mMuxer));
        }
        Object object = this.mSync;
        synchronized (object) {
            if (this.mWeakCamera.get() != null) {
                ((UVCCamera)this.mWeakCamera.get()).startCapture(this.mVideoEncoder.getInputSurface());
            }
            this.mMuxer.resumeRecording();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRecording() {
        MediaMuxerWrapper muxer;
        if (BuildConfig.DEBUG) {
            Log.v((String)TAG, (String)("stopRecording:mMuxer=" + this.mMuxer));
        }
        Object object = this.mSync;
        synchronized (object) {
            muxer = this.mMuxer;
            this.mMuxer = null;
            this.mVideoEncoder = null;
        }
        if (muxer != null) {
            muxer.stopRecording();
        }
    }
}

