/*
 * Decompiled with CFR 0.152.
 */
package com.herohan.uvcapp;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.herohan.uvcapp.ImageCaptureConfig;
import java.io.File;
import java.io.OutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public interface IImageCapture {
    public static final int ERROR_UNKNOWN = 0;
    public static final int ERROR_FILE_IO = 1;
    public static final int ERROR_CAPTURE_FAILED = 2;
    public static final int ERROR_CAMERA_CLOSED = 3;
    public static final int ERROR_INVALID_CAMERA = 4;
    public static final int CAPTURE_STRATEGY_OPENGL_ES = 0;
    public static final int CAPTURE_STRATEGY_IMAGE_READER = 1;
    public static final int CAPTURE_MODE_MAXIMIZE_QUALITY = 0;
    public static final int CAPTURE_MODE_MINIMIZE_LATENCY = 1;
    public static final int JPEG_QUALITY_MAXIMIZE_QUALITY_MODE = 100;
    public static final int JPEG_QUALITY_MINIMIZE_LATENCY_MODE = 95;

    public void setConfig(ImageCaptureConfig var1);

    public void takePicture(OutputFileOptions var1, OnImageCaptureCallback var2);

    public void release();

    public static interface OnImageCaptureCallback {
        public void onImageSaved(@NonNull OutputFileResults var1);

        public void onError(int var1, @NonNull String var2, @Nullable Throwable var3);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CaptureMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CaptureStrategy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ImageCaptureError {
    }

    public static class OutputFileResults {
        @Nullable
        private Uri mSavedUri;

        OutputFileResults(@Nullable Uri SavedUri) {
            this.mSavedUri = SavedUri;
        }

        @Nullable
        public Uri getSavedUri() {
            return this.mSavedUri;
        }
    }

    public static final class OutputFileOptions {
        @Nullable
        private File mFile;
        @Nullable
        private ContentResolver mContentResolver;
        @Nullable
        private Uri mSaveCollection;
        @Nullable
        private ContentValues mContentValues;
        @Nullable
        private OutputStream mOutputStream;

        OutputFileOptions(@Nullable File file, @Nullable ContentResolver contentResolver, @Nullable Uri saveCollection, @Nullable ContentValues contentValues, @Nullable OutputStream outputStream) {
            this.mFile = file;
            this.mContentResolver = contentResolver;
            this.mSaveCollection = saveCollection;
            this.mContentValues = contentValues;
            this.mOutputStream = outputStream;
        }

        @Nullable
        public File getFile() {
            return this.mFile;
        }

        @Nullable
        public ContentResolver getContentResolver() {
            return this.mContentResolver;
        }

        @Nullable
        public Uri getSaveCollection() {
            return this.mSaveCollection;
        }

        @Nullable
        public ContentValues getContentValues() {
            return this.mContentValues;
        }

        @Nullable
        public OutputStream getOutputStream() {
            return this.mOutputStream;
        }

        public static final class Builder {
            @Nullable
            private File mFile;
            @Nullable
            private ContentResolver mContentResolver;
            @Nullable
            private Uri mSaveCollection;
            @Nullable
            private ContentValues mContentValues;
            @Nullable
            private OutputStream mOutputStream;

            public Builder(@Nullable File file) {
                this.mFile = file;
            }

            public Builder(@Nullable ContentResolver contentResolver, @Nullable Uri saveCollection, @Nullable ContentValues contentValues) {
                this.mContentResolver = contentResolver;
                this.mSaveCollection = saveCollection;
                this.mContentValues = contentValues;
            }

            public Builder(@Nullable OutputStream outputStream) {
                this.mOutputStream = outputStream;
            }

            public OutputFileOptions build() {
                return new OutputFileOptions(this.mFile, this.mContentResolver, this.mSaveCollection, this.mContentValues, this.mOutputStream);
            }
        }
    }
}

