/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.utils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class Pool<T> {
    @NonNull
    private final List<T> mPool = new ArrayList<T>();
    private final int mInitNum;
    private final int mMaxNumInPool;
    private final int mLimitNum;
    private int mCreatedObjects;

    public Pool(int initNum, int maxNumInPool, Object ... args) {
        this(initNum, maxNumInPool, maxNumInPool, args);
    }

    public Pool(int initNum, int maxNumInPool, int limitNum, Object ... args) {
        this.mInitNum = initNum;
        this.mMaxNumInPool = Math.min(maxNumInPool, limitNum);
        this.mLimitNum = limitNum;
        this.init(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Object ... args) {
        List<T> list = this.mPool;
        synchronized (list) {
            this.mPool.clear();
            this.mCreatedObjects = 0;
            for (int i = 0; i < this.mInitNum && i < this.mMaxNumInPool; ++i) {
                T obj = this.createObject(args);
                this.mPool.add(obj);
                ++this.mCreatedObjects;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T obtain(Object ... args) {
        T result = null;
        List<T> list = this.mPool;
        synchronized (list) {
            if (!this.mPool.isEmpty()) {
                result = this.mPool.remove(this.mPool.size() - 1);
            }
            if (result == null && this.mCreatedObjects < this.mLimitNum) {
                result = this.createObject(args);
                ++this.mCreatedObjects;
            }
        }
        return result;
    }

    @NonNull
    protected abstract T createObject(Object ... var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recycle(@NonNull T obj) {
        List<T> list = this.mPool;
        synchronized (list) {
            if (this.mPool.size() < this.mMaxNumInPool) {
                return this.mPool.add(obj);
            }
            --this.mCreatedObjects;
            return false;
        }
    }

    public void recycle(@NonNull Collection<T> objects) {
        for (T obj : objects) {
            if (obj == null) continue;
            this.recycle(obj);
        }
    }

    public void recycle(@NonNull T[] objects) {
        for (T obj : objects) {
            if (obj == null) continue;
            this.recycle(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(@NonNull T obj) {
        List<T> list = this.mPool;
        synchronized (list) {
            if (this.mCreatedObjects > 0) {
                --this.mCreatedObjects;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<T> list = this.mPool;
        synchronized (list) {
            this.mPool.clear();
            this.mCreatedObjects = 0;
        }
    }
}

