/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.utils;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import androidx.annotation.NonNull;
import com.serenegiant.system.ContextUtils;

public class KeyboardUtils {
    private static final boolean DEBUG = false;
    private static final String TAG = KeyboardUtils.class.getSimpleName();

    private KeyboardUtils() {
    }

    public static void hide(@NonNull View view) {
        InputMethodManager imm = ContextUtils.requireSystemService(view.getContext(), InputMethodManager.class);
        view.clearFocus();
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public static void hide(@NonNull Activity activity) {
        InputMethodManager imm = ContextUtils.requireSystemService((Context)activity, InputMethodManager.class);
        View view = activity.getCurrentFocus();
        if (view == null) {
            view = new View((Context)activity);
        }
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public static View setOnKeyboardVisibilityChangedListener(final @NonNull View view, final @NonNull OnKeyboardVisibilityChangedListener listener) {
        view.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){
            private boolean alreadyOpen;
            private final int defaultKeyboardHeightDP = 100;
            private final int EstimatedKeyboardDP = 100 + (Build.VERSION.SDK_INT >= 21 ? 48 : 0);
            private final Rect rect = new Rect();

            public void onGlobalLayout() {
                boolean isShown;
                int estimatedKeyboardHeight = (int)TypedValue.applyDimension((int)1, (float)this.EstimatedKeyboardDP, (DisplayMetrics)view.getResources().getDisplayMetrics());
                view.getWindowVisibleDisplayFrame(this.rect);
                int heightDiff = view.getRootView().getHeight() - (this.rect.bottom - this.rect.top);
                boolean bl = isShown = heightDiff >= estimatedKeyboardHeight;
                if (isShown != this.alreadyOpen) {
                    this.alreadyOpen = isShown;
                    listener.onKeyboardVisibilityChanged(isShown);
                }
            }
        });
        return view;
    }

    public static interface OnKeyboardVisibilityChangedListener {
        public void onKeyboardVisibilityChanged(boolean var1);
    }
}

