/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb;

import android.annotation.SuppressLint;
import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.nio.CharsetsUtils;
import com.serenegiant.system.BuildCheck;
import com.serenegiant.system.ContextUtils;
import com.serenegiant.usb.Const;
import com.serenegiant.usb.USBMonitor;
import com.serenegiant.usb.UsbDeviceInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class UsbUtils
implements Const {
    private static final String TAG = UsbUtils.class.getSimpleName();

    private UsbUtils() {
    }

    public static String getString(@NonNull UsbDeviceConnection connection, int id2, int languageCount, byte[] languages) {
        byte[] work = new byte[256];
        String result = null;
        for (int i = 1; i <= languageCount; ++i) {
            int ret = connection.controlTransfer(128, 6, 0x300 | id2, (int)languages[i], work, 256, 0);
            if (ret <= 2 || work[0] != ret || work[1] != 3) continue;
            result = new String(work, 2, ret - 2, CharsetsUtils.UTF16LE);
            if (!"\u0409".equals(result)) break;
            result = null;
        }
        return result;
    }

    public static boolean isSupported(@NonNull UsbDevice device, int clazz, int subClass, int protocol) {
        if (!(clazz >= 0 && clazz != device.getDeviceClass() || subClass >= 0 && subClass != device.getDeviceSubclass() || protocol >= 0 && protocol != device.getDeviceProtocol())) {
            return true;
        }
        int n = device.getInterfaceCount();
        for (int i = 0; i < n; ++i) {
            UsbInterface intf = device.getInterface(i);
            if (clazz >= 0 && clazz != intf.getInterfaceClass() || subClass >= 0 && subClass != intf.getInterfaceSubclass() || protocol >= 0 && protocol != intf.getInterfaceProtocol()) continue;
            return true;
        }
        return false;
    }

    public static boolean isUVC(@NonNull UsbDevice device) {
        return UsbUtils.isSupported(device, 14, 1, -1) || UsbUtils.isSupported(device, 14, 2, -1);
    }

    public static boolean isUAC(@NonNull UsbDevice device) {
        return UsbUtils.isSupported(device, 1, 1, -1) || UsbUtils.isSupported(device, 1, 2, -1);
    }

    @Deprecated
    @NonNull
    public static String getDeviceKeyNameWithSerial(@NonNull Context context, @Nullable UsbDevice device) {
        return UsbUtils.getDeviceKeyName(UsbDeviceInfo.getDeviceInfo(context, device));
    }

    @Deprecated
    public static int getDeviceKeyWithSerial(@NonNull Context context, @Nullable UsbDevice device) {
        return UsbUtils.getDeviceKeyNameWithSerial(context, device).hashCode();
    }

    @NonNull
    public static String getDeviceKeyName(@NonNull USBMonitor.UsbControlBlock ctrlBlock) {
        return UsbUtils.getDeviceKeyName(ctrlBlock.getInfo());
    }

    public static int getDeviceKey(@NonNull USBMonitor.UsbControlBlock ctrlBlock) {
        return UsbUtils.getDeviceKeyName(ctrlBlock).hashCode();
    }

    @NonNull
    public static String getDeviceKeyName(@NonNull Context context, @Nullable UsbDevice device) {
        return UsbUtils.getDeviceKeyName(UsbDeviceInfo.getDeviceInfo(context, device));
    }

    public static int getDeviceKey(@NonNull Context context, @Nullable UsbDevice device) {
        return UsbUtils.getDeviceKeyName(UsbDeviceInfo.getDeviceInfo(context, device)).hashCode();
    }

    @NonNull
    public static String getDeviceKeyName(@NonNull UsbDeviceInfo info) {
        UsbDevice device = info.device;
        if (device == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(device.getVendorId()).append("#").append(device.getProductId()).append("#").append(device.getDeviceClass()).append("#").append(device.getDeviceSubclass()).append("#").append(device.getDeviceProtocol());
        if (!TextUtils.isEmpty((CharSequence)info.serial)) {
            sb.append("#");
            sb.append(info.serial);
        }
        if (BuildCheck.isAndroid5()) {
            if (!TextUtils.isEmpty((CharSequence)info.manufacturer)) {
                sb.append("#").append(info.manufacturer);
            }
            if (info.configCounts >= 0) {
                sb.append("#").append(info.configCounts);
            }
            if (!TextUtils.isEmpty((CharSequence)info.version)) {
                sb.append("#").append(info.version);
            }
        }
        return sb.toString();
    }

    public static int getDeviceKey(@NonNull UsbDeviceInfo info) {
        return UsbUtils.getDeviceKeyName(info).hashCode();
    }

    @Deprecated
    @NonNull
    public static final String getDeviceKeyName(@Nullable UsbDevice device, boolean useNewAPI, String serial, String manufactureName, int configCount, String deviceVersion) {
        if (device == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(device.getVendorId()).append("#").append(device.getProductId()).append("#").append(device.getDeviceClass()).append("#").append(device.getDeviceSubclass()).append("#").append(device.getDeviceProtocol());
        if (!TextUtils.isEmpty((CharSequence)serial)) {
            sb.append("#");
            sb.append(serial);
        }
        if (useNewAPI && BuildCheck.isAndroid5()) {
            if (!TextUtils.isEmpty((CharSequence)manufactureName)) {
                sb.append("#").append(manufactureName);
            }
            if (configCount >= 0) {
                sb.append("#").append(configCount);
            }
            if (!TextUtils.isEmpty((CharSequence)deviceVersion)) {
                sb.append("#").append(deviceVersion);
            }
        }
        return sb.toString();
    }

    @Deprecated
    public static final int getDeviceKey(@Nullable UsbDevice device) {
        return device != null ? UsbUtils.getDeviceKeyName(device, null, false).hashCode() : 0;
    }

    @Deprecated
    public static final int getDeviceKey(@Nullable UsbDevice device, boolean useNewAPI) {
        return device != null ? UsbUtils.getDeviceKeyName(device, null, useNewAPI).hashCode() : 0;
    }

    @Deprecated
    public static final int getDeviceKey(@Nullable UsbDevice device, boolean useNewAPI, boolean useNonce) {
        return device != null ? UsbUtils.getDeviceKeyName(device, null, useNewAPI, useNonce).hashCode() : 0;
    }

    @Deprecated
    public static final int getDeviceKey(@Nullable UsbDevice device, String serial, boolean useNewAPI) {
        return device != null ? UsbUtils.getDeviceKeyName(device, serial, useNewAPI).hashCode() : 0;
    }

    @Deprecated
    public static final int getDeviceKey(@Nullable UsbDevice device, String serial, boolean useNewAPI, boolean useNonce) {
        return device != null ? UsbUtils.getDeviceKeyName(device, serial, useNewAPI, useNonce).hashCode() : 0;
    }

    @Deprecated
    @NonNull
    public static final String getDeviceKeyName(@Nullable UsbDevice device) {
        return UsbUtils.getDeviceKeyName(device, null, false);
    }

    @Deprecated
    @NonNull
    public static final String getDeviceKeyName(@Nullable UsbDevice device, boolean useNewAPI) {
        return UsbUtils.getDeviceKeyName(device, null, useNewAPI);
    }

    @Deprecated
    @NonNull
    public static final String getDeviceKeyName(@Nullable UsbDevice device, String serial, boolean useNewAPI) {
        return UsbUtils.getDeviceKeyName(device, serial, useNewAPI, false);
    }

    @Deprecated
    @SuppressLint(value={"NewApi"})
    @NonNull
    public static final String getDeviceKeyName(@Nullable UsbDevice device, String serial, boolean useNewAPI, boolean usuNonce) {
        if (device == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(device.getVendorId()).append("#").append(device.getProductId()).append("#").append(device.getDeviceClass()).append("#").append(device.getDeviceSubclass()).append("#").append(device.getDeviceProtocol());
        if (!TextUtils.isEmpty((CharSequence)serial)) {
            sb.append("#").append(serial);
        }
        if (usuNonce) {
            sb.append("#").append(device.getDeviceName());
        }
        if (useNewAPI && BuildCheck.isAndroid5()) {
            sb.append("#");
            if (TextUtils.isEmpty((CharSequence)serial)) {
                sb.append(device.getSerialNumber()).append("#");
            }
            sb.append(device.getManufacturerName()).append("#").append(device.getConfigurationCount()).append("#");
            if (BuildCheck.isMarshmallow()) {
                sb.append(device.getVersion()).append("#");
            }
        }
        return sb.toString();
    }

    @Nullable
    public static UsbDevice findDevice(@NonNull List<UsbDevice> devices, String name) {
        UsbDevice result = null;
        for (UsbDevice device : devices) {
            if (!device.getDeviceName().equals(name)) continue;
            result = device;
            break;
        }
        return result;
    }

    public static void dumpDevices(@NonNull Context context) {
        UsbManager usbManager = ContextUtils.requireSystemService(context, UsbManager.class);
        HashMap list = usbManager.getDeviceList();
        if (list != null && !list.isEmpty()) {
            Set keys = list.keySet();
            if (keys != null && keys.size() > 0) {
                StringBuilder sb = new StringBuilder();
                for (String key : keys) {
                    UsbDevice device = (UsbDevice)list.get(key);
                    int num_interface = device != null ? device.getInterfaceCount() : 0;
                    sb.setLength(0);
                    for (int i = 0; i < num_interface; ++i) {
                        sb.append(String.format(Locale.US, "interface%d:%s", i, device.getInterface(i).toString()));
                    }
                    Log.i((String)TAG, (String)("key=" + key + ":" + device + ":" + sb.toString()));
                }
            } else {
                Log.i((String)TAG, (String)"no device");
            }
        } else {
            Log.i((String)TAG, (String)"no device");
        }
    }
}

