/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.system;

import android.annotation.SuppressLint;
import android.os.SystemClock;
import com.serenegiant.system.BuildCheck;

public class Time {
    public static boolean prohibitElapsedRealtimeNanos = true;
    private static Time sTime;

    public static long nanoTime() {
        return sTime.timeNs();
    }

    public static long milliTime() {
        return sTime.timeMs();
    }

    public static void reset() {
        sTime = !prohibitElapsedRealtimeNanos && BuildCheck.isJellyBeanMr1() ? new TimeJellyBeanMr1() : new Time();
    }

    private Time() {
    }

    private long timeMs() {
        return this.timeNs() / 1000000L;
    }

    protected long timeNs() {
        return System.nanoTime();
    }

    static {
        Time.reset();
    }

    @SuppressLint(value={"NewApi"})
    private static class TimeJellyBeanMr1
    extends Time {
        private TimeJellyBeanMr1() {
        }

        @Override
        public long timeNs() {
            return SystemClock.elapsedRealtimeNanos();
        }
    }
}

