/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.system;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.provider.DocumentsContract;
import android.text.TextUtils;
import android.util.Pair;
import androidx.activity.ComponentActivity;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.serenegiant.system.BuildCheck;
import com.serenegiant.system.SAFPermission;
import java.io.FileNotFoundException;

@TargetApi(value=19)
public class SAFSingleFileUtils {
    private static final boolean DEBUG = false;
    private static final String TAG = SAFSingleFileUtils.class.getSimpleName();
    private static final String EXTRA_KEY_REQUEST_ID = "SAFSingleFileUtils.EXTRA_KEY_REQUEST_ID";
    @NonNull
    private final ActivityResultLauncher<Intent> mLauncher;

    public SAFSingleFileUtils(@NonNull ComponentActivity activity, @NonNull SAFPermission.SAFCallback callback) {
        this.mLauncher = activity.registerForActivityResult((ActivityResultContract)new SingleDocument(), (ActivityResultCallback)new MyActivityResultCallback(callback));
    }

    public SAFSingleFileUtils(@NonNull Fragment fragment, @NonNull SAFPermission.SAFCallback callback) {
        this.mLauncher = fragment.registerForActivityResult((ActivityResultContract)new SingleDocument(), (ActivityResultCallback)new MyActivityResultCallback(callback));
    }

    public void requestOpen(int id2, @NonNull String mimeType) throws IllegalArgumentException {
        this.mLauncher.launch((Object)SAFSingleFileUtils.prepareOpenDocumentIntent(id2, mimeType));
    }

    public void requestCreate(int id2, @NonNull String mimeType, @Nullable String defaultName) throws IllegalArgumentException {
        this.mLauncher.launch((Object)SAFSingleFileUtils.prepareCreateDocument(id2, mimeType, defaultName));
    }

    private static Intent prepareOpenDocumentIntent(int id2, @NonNull String mimeType) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)mimeType)) {
            throw new IllegalArgumentException("mime type should not a null/empty");
        }
        return new Intent("android.intent.action.OPEN_DOCUMENT").setType(mimeType).putExtra(EXTRA_KEY_REQUEST_ID, id2);
    }

    private static Intent prepareCreateDocument(int id2, @NonNull String mimeType, @Nullable String defaultName) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)mimeType)) {
            throw new IllegalArgumentException("mime type should not a null/empty");
        }
        return new Intent("android.intent.action.OPEN_DOCUMENT").setType(mimeType).putExtra("android.intent.extra.TITLE", defaultName);
    }

    public static boolean requestDeleteDocument(@NonNull Context context, Uri uri) {
        try {
            return BuildCheck.isKitKat() && DocumentsContract.deleteDocument((ContentResolver)context.getContentResolver(), (Uri)uri);
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    @TargetApi(value=19)
    private static class SingleDocument
    extends ActivityResultContract<Intent, Pair<Integer, Uri>> {
        private static final String TAG = SingleDocument.class.getSimpleName();
        @Nullable
        private Intent input;

        private SingleDocument() {
        }

        @CallSuper
        @NonNull
        public Intent createIntent(@NonNull Context context, @Nullable Intent input) {
            this.input = input;
            String action = input != null ? input.getAction() : null;
            String mimeType = input != null ? input.getType() : null;
            String defaultName = input != null ? input.getStringExtra("android.intent.extra.TITLE") : null;
            Intent intent = new Intent(action != null ? action : "android.intent.action.OPEN_DOCUMENT");
            if (Build.VERSION.SDK_INT >= 26 && input != null) {
                Uri initialUri = input != null ? input.getData() : null;
                intent.putExtra("android.provider.extra.INITIAL_URI", (Parcelable)initialUri);
            }
            if (!TextUtils.isEmpty((CharSequence)mimeType)) {
                intent.setType(mimeType);
            }
            if (!TextUtils.isEmpty((CharSequence)defaultName)) {
                intent.putExtra("android.intent.extra.TITLE", defaultName);
            }
            return intent;
        }

        @Nullable
        public final ActivityResultContract.SynchronousResult<Pair<Integer, Uri>> getSynchronousResult(@NonNull Context context, @Nullable Intent input) {
            this.input = input;
            return null;
        }

        @Nullable
        public final Pair<Integer, Uri> parseResult(int resultCode, @Nullable Intent intent) {
            Uri uri = intent != null && resultCode == -1 ? intent.getData() : null;
            int id2 = this.input != null ? this.input.getIntExtra(SAFSingleFileUtils.EXTRA_KEY_REQUEST_ID, 0) : 0;
            return Pair.create((Object)id2, (Object)uri);
        }
    }

    private static class MyActivityResultCallback
    implements ActivityResultCallback<Pair<Integer, Uri>> {
        private static final String TAG = MyActivityResultCallback.class.getSimpleName();
        @NonNull
        final SAFPermission.SAFCallback callback;

        private MyActivityResultCallback(@NonNull SAFPermission.SAFCallback callback) {
            this.callback = callback;
        }

        public void onActivityResult(Pair<Integer, Uri> result) {
            if (result != null) {
                int requestCode = (Integer)result.first;
                Uri uri = (Uri)result.second;
                if (uri != null) {
                    this.callback.onResult(requestCode, uri);
                } else {
                    this.callback.onFailed(requestCode);
                }
            } else {
                this.callback.onFailed(0);
            }
        }
    }
}

