/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.system;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class BatteryInfo
implements Parcelable {
    @SuppressLint(value={"InlinedApi"})
    public static final int BATTERY_PLUGGED_ANY = 7;
    public int level;
    public int scale;
    public float temperature;
    public float battery;
    public float voltage;
    public String technology;
    public int status;
    public int health;
    public int plugged;
    public static final Parcelable.Creator<BatteryInfo> CREATOR = new Parcelable.Creator<BatteryInfo>(){

        public BatteryInfo createFromParcel(Parcel in) {
            return new BatteryInfo(in);
        }

        public BatteryInfo[] newArray(int size) {
            return new BatteryInfo[size];
        }
    };

    public BatteryInfo() {
        this.clear();
    }

    public BatteryInfo(@NonNull BatteryInfo src) {
        this.level = src.level;
        this.scale = src.scale;
        this.temperature = src.temperature;
        this.battery = src.battery;
        this.voltage = src.voltage;
        this.technology = src.technology;
        this.status = src.status;
        this.health = src.health;
        this.plugged = src.plugged;
    }

    public BatteryInfo(@NonNull Intent batteryStatus) {
        this.level = batteryStatus.getIntExtra("level", 0);
        this.scale = batteryStatus.getIntExtra("scale", 100);
        this.temperature = (float)batteryStatus.getIntExtra("temperature", 0) / 10.0f;
        this.battery = 100.0f * (float)this.level / (float)(this.scale != 0 ? this.scale : 100);
        this.voltage = (float)batteryStatus.getIntExtra("voltage", 0) / 1000.0f;
        this.technology = batteryStatus.getStringExtra("technology");
        this.status = batteryStatus.getIntExtra("status", 1);
        this.health = batteryStatus.getIntExtra("health", 1);
        this.plugged = batteryStatus.getIntExtra("plugged", 0);
    }

    protected BatteryInfo(@NonNull Parcel in) {
        this.level = in.readInt();
        this.scale = in.readInt();
        this.temperature = in.readFloat();
        this.battery = in.readFloat();
        this.voltage = in.readFloat();
        this.technology = in.readString();
        this.status = in.readInt();
        this.health = in.readInt();
        this.plugged = in.readInt();
    }

    public void set(@Nullable BatteryInfo src) {
        if (src != null) {
            this.level = src.level;
            this.scale = src.scale;
            this.temperature = src.temperature;
            this.battery = src.battery;
            this.voltage = src.voltage;
            this.technology = src.technology;
            this.status = src.status;
            this.health = src.health;
            this.plugged = src.plugged;
        } else {
            this.clear();
        }
    }

    public void set(@NonNull Intent batteryStatus) {
        this.level = batteryStatus.getIntExtra("level", this.level);
        this.scale = batteryStatus.getIntExtra("scale", this.scale);
        this.temperature = (float)batteryStatus.getIntExtra("temperature", Math.round(this.temperature * 10.0f)) / 10.0f;
        this.battery = 100.0f * (float)this.level / (float)(this.scale != 0 ? this.scale : 100);
        this.voltage = (float)batteryStatus.getIntExtra("voltage", Math.round(this.voltage * 1000.0f)) / 1000.0f;
        this.technology = batteryStatus.getStringExtra("technology");
        this.status = batteryStatus.getIntExtra("status", this.status);
        this.health = batteryStatus.getIntExtra("health", this.health);
        this.plugged = batteryStatus.getIntExtra("plugged", this.plugged);
    }

    public void clear() {
        this.level = 0;
        this.scale = 100;
        this.temperature = 0.0f;
        this.battery = 0.0f;
        this.voltage = 0.0f;
        this.technology = null;
        this.status = 1;
        this.health = 1;
        this.plugged = 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.level);
        dest.writeInt(this.scale);
        dest.writeFloat(this.temperature);
        dest.writeFloat(this.battery);
        dest.writeFloat(this.voltage);
        dest.writeString(this.technology);
        dest.writeInt(this.status);
        dest.writeInt(this.health);
        dest.writeInt(this.plugged);
    }

    public int describeContents() {
        return 0;
    }

    @NonNull
    public String toString() {
        return "BatteryInfo{level=" + this.level + ", scale=" + this.scale + ", temperature=" + this.temperature + ", battery=" + this.battery + ", voltage=" + this.voltage + ", technology=" + this.technology + ", status=" + this.status + ", health=" + this.health + ", plugged=" + this.plugged + '}';
    }

    public boolean isCharging() {
        return this.status == 2;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @SuppressLint(value={"InlinedApi"})
    public static @interface BatteryPlugged {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BatteryHealth {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BatteryStatus {
    }
}

