/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.security;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.system.BuildCheck;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SignatureHelper {
    private SignatureHelper() {
    }

    @SuppressLint(value={"NewApi"})
    public static boolean checkSignature(@NonNull Context context, String key) throws IllegalArgumentException, PackageManager.NameNotFoundException {
        Signature[] signatures;
        PackageInfo packageInfo;
        if (TextUtils.isEmpty((CharSequence)key)) {
            throw new IllegalArgumentException("context or key is null");
        }
        Signature expected = new Signature(key);
        boolean result = true;
        PackageManager pm = context.getPackageManager();
        if (BuildCheck.isPie()) {
            packageInfo = pm.getPackageInfo(context.getPackageName(), 0x8000000);
            signatures = packageInfo.signingInfo.hasMultipleSigners() ? packageInfo.signingInfo.getApkContentsSigners() : packageInfo.signingInfo.getSigningCertificateHistory();
        } else {
            packageInfo = pm.getPackageInfo(context.getPackageName(), 64);
            signatures = packageInfo.signatures;
        }
        for (int i = 0; i < signatures.length; ++i) {
            result &= expected.equals((Object)signatures[i]);
        }
        return result;
    }

    @SuppressLint(value={"NewApi"})
    @Nullable
    public static String getSignature(@NonNull Context context) throws PackageManager.NameNotFoundException {
        Signature[] signatures;
        PackageInfo packageInfo;
        PackageManager pm = context.getPackageManager();
        if (BuildCheck.isPie()) {
            packageInfo = pm.getPackageInfo(context.getPackageName(), 0x8000000);
            signatures = packageInfo.signingInfo.hasMultipleSigners() ? packageInfo.signingInfo.getApkContentsSigners() : packageInfo.signingInfo.getSigningCertificateHistory();
        } else {
            packageInfo = pm.getPackageInfo(context.getPackageName(), 64);
            signatures = packageInfo.signatures;
        }
        boolean cnt = false;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < signatures.length; ++i) {
            Signature signature = signatures[i];
            if (signature == null) continue;
            if (cnt) {
                sb.append('/');
            }
            sb.append(signature.toCharsString());
        }
        return sb.toString();
    }

    @SuppressLint(value={"NewApi"})
    @Nullable
    public static byte[] getSignatureBytes(@NonNull Context context) throws PackageManager.NameNotFoundException {
        Signature[] signatures;
        PackageInfo packageInfo;
        PackageManager pm = context.getPackageManager();
        if (BuildCheck.isPie()) {
            packageInfo = pm.getPackageInfo(context.getPackageName(), 0x8000000);
            signatures = packageInfo.signingInfo.hasMultipleSigners() ? packageInfo.signingInfo.getApkContentsSigners() : packageInfo.signingInfo.getSigningCertificateHistory();
        } else {
            packageInfo = pm.getPackageInfo(context.getPackageName(), 64);
            signatures = packageInfo.signatures;
        }
        ByteBuffer result = ByteBuffer.allocate(1024);
        for (int i = 0; i < signatures.length; ++i) {
            int n;
            Signature signature = signatures[i];
            if (signature == null) continue;
            byte[] bytes = signature.toByteArray();
            int n2 = n = bytes != null ? bytes.length : 0;
            if (n <= 0) continue;
            if (n > result.remaining()) {
                result.flip();
                ByteBuffer temp = ByteBuffer.allocate(result.capacity() + n * 2);
                temp.put(result);
                result = temp;
            }
            result.put(bytes);
        }
        result.flip();
        int n = result.limit();
        if (n > 0) {
            byte[] bytes = new byte[n];
            result.get(bytes);
            return bytes;
        }
        return null;
    }

    @SuppressLint(value={"NewApi"})
    public static byte[] getSignaturesDigest(@NonNull Context context, @NonNull String algorithm) throws PackageManager.NameNotFoundException, NoSuchAlgorithmException {
        Signature[] signatures;
        PackageInfo packageInfo;
        PackageManager pm = context.getPackageManager();
        if (BuildCheck.isPie()) {
            packageInfo = pm.getPackageInfo(context.getPackageName(), 0x8000000);
            signatures = packageInfo.signingInfo.hasMultipleSigners() ? packageInfo.signingInfo.getApkContentsSigners() : packageInfo.signingInfo.getSigningCertificateHistory();
        } else {
            packageInfo = pm.getPackageInfo(context.getPackageName(), 64);
            signatures = packageInfo.signatures;
        }
        MessageDigest digest = MessageDigest.getInstance(algorithm);
        for (int i = 0; i < signatures.length; ++i) {
            Signature signature = signatures[i];
            if (signature == null) continue;
            digest.update(signature.toByteArray());
        }
        return digest.digest();
    }
}

