/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.security;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.security.KeyPairGeneratorSpec;
import android.security.keystore.KeyGenParameterSpec;
import android.text.TextUtils;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.serenegiant.nio.CharsetsUtils;
import com.serenegiant.security.ObfuscatorException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Calendar;
import java.util.Locale;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.security.auth.x500.X500Principal;

@RequiresApi(api=18)
public class KeyStoreUtils {
    private static final boolean DEBUG = false;
    private static final String TAG = KeyStoreUtils.class.getSimpleName();
    private static final String KEY_STORE_TYPE = "AndroidKeyStore";
    private static final String ALGORITHM_RSA = "RSA";
    private static final String CIPHER_TRANSFORMATION_RSA = "RSA/ECB/PKCS1Padding";
    @TargetApi(value=23)
    private static final String CIPHER_TRANSFORMATION_AES = "AES/CBC/PKCS7Padding";

    private KeyStoreUtils() {
    }

    public static void deleteKey(@NonNull Context context, @Nullable String name) {
        String alias = context.getPackageName() + (!TextUtils.isEmpty((CharSequence)name) ? ":" + name : "");
        try {
            KeyStore keyStore = KeyStore.getInstance(KEY_STORE_TYPE);
            keyStore.load(null);
            boolean containsAlias = keyStore.containsAlias(alias);
            if (containsAlias) {
                keyStore.deleteEntry(alias);
            }
        }
        catch (IOException | GeneralSecurityException exception) {
            // empty catch block
        }
    }

    @Nullable
    public static String encrypt(@NonNull Context context, @Nullable String name, @Nullable String value) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            return KeyStoreUtils.encryptAES(context, name, value);
        }
        return KeyStoreUtils.encryptRSA(context, name, value);
    }

    @Nullable
    public static String decrypt(@NonNull Context context, @Nullable String name, @Nullable String encrypted) throws ObfuscatorException {
        if (TextUtils.isEmpty((CharSequence)encrypted)) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            return KeyStoreUtils.decryptAES(context, name, encrypted);
        }
        return KeyStoreUtils.decryptRSA(context, name, encrypted);
    }

    private static String encryptRSA(@NonNull Context context, @Nullable String name, @NonNull String value) {
        try {
            KeyStore.Entry entry = KeyStoreUtils.getKey(context, name);
            PublicKey publicKey = ((KeyStore.PrivateKeyEntry)entry).getCertificate().getPublicKey();
            Cipher encryptor = Cipher.getInstance(CIPHER_TRANSFORMATION_RSA);
            encryptor.init(1, publicKey);
            return KeyStoreUtils.base64Encode(encryptor.doFinal(value.getBytes(CharsetsUtils.UTF8)));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("Invalid environment", e);
        }
    }

    private static String decryptRSA(@NonNull Context context, @Nullable String name, @NonNull String encrypted) throws ObfuscatorException {
        try {
            KeyStore.Entry entry = KeyStoreUtils.getKey(context, name);
            PrivateKey privateKey = ((KeyStore.PrivateKeyEntry)entry).getPrivateKey();
            Cipher decryptor = Cipher.getInstance(CIPHER_TRANSFORMATION_RSA);
            decryptor.init(2, privateKey);
            return new String(decryptor.doFinal(KeyStoreUtils.base64decode(encrypted)), CharsetsUtils.UTF8);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new ObfuscatorException(e.getMessage() + "");
        }
        catch (IllegalArgumentException e) {
            throw new ObfuscatorException(e.getMessage() + "");
        }
    }

    @RequiresApi(api=23)
    private static String encryptAES(@NonNull Context context, @Nullable String name, @NonNull String value) {
        try {
            KeyStore.Entry entry = KeyStoreUtils.getKey(context, name);
            SecretKey secretKey = ((KeyStore.SecretKeyEntry)entry).getSecretKey();
            Cipher encryptor = Cipher.getInstance(CIPHER_TRANSFORMATION_AES);
            encryptor.init(1, secretKey);
            return KeyStoreUtils.base64Encode(encryptor.getIV()) + "|" + KeyStoreUtils.base64Encode(encryptor.doFinal(value.getBytes(CharsetsUtils.UTF8)));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("Invalid environment", e);
        }
    }

    @RequiresApi(api=23)
    private static String decryptAES(@NonNull Context context, @Nullable String name, @NonNull String encrypted) throws ObfuscatorException {
        String[] split = encrypted.split("\\|");
        if (split.length < 2) {
            throw new ObfuscatorException("Unexpected encrypted format");
        }
        try {
            KeyStore.Entry entry = KeyStoreUtils.getKey(context, name);
            SecretKey secretKey = ((KeyStore.SecretKeyEntry)entry).getSecretKey();
            Cipher decryptor = Cipher.getInstance(CIPHER_TRANSFORMATION_AES);
            decryptor.init(2, (Key)secretKey, new IvParameterSpec(KeyStoreUtils.base64decode(split[0])));
            return new String(decryptor.doFinal(KeyStoreUtils.base64decode(split[1])), CharsetsUtils.UTF8);
        }
        catch (IllegalArgumentException e) {
            throw new ObfuscatorException(e.getMessage() + "");
        }
        catch (IOException e) {
            throw new ObfuscatorException(e.getMessage() + "");
        }
        catch (GeneralSecurityException e) {
            throw new ObfuscatorException(e.getMessage() + "");
        }
    }

    @Nullable
    private static KeyStore.Entry getKey(@NonNull Context context, @Nullable String name) throws GeneralSecurityException, IOException {
        String alias = context.getPackageName() + (!TextUtils.isEmpty((CharSequence)name) ? ":" + name : "");
        KeyStore keyStore = KeyStore.getInstance(KEY_STORE_TYPE);
        keyStore.load(null);
        boolean containsAlias = keyStore.containsAlias(alias);
        if (containsAlias) {
            Key key = keyStore.getKey(alias, null);
            if (Build.VERSION.SDK_INT >= 23 && ALGORITHM_RSA.equals(key.getAlgorithm())) {
                keyStore.deleteEntry(alias);
                containsAlias = false;
            }
        }
        if (!containsAlias) {
            KeyStoreUtils.createKey(context, alias);
        }
        return keyStore.getEntry(alias, null);
    }

    private static void createKey(@NonNull Context context, @NonNull String alias) throws GeneralSecurityException {
        Calendar start = Calendar.getInstance(Locale.ENGLISH);
        Calendar end = Calendar.getInstance(Locale.ENGLISH);
        end.add(1, 1);
        X500Principal principal = new X500Principal("CN=" + alias + " O=" + context.getPackageName());
        if (Build.VERSION.SDK_INT >= 23) {
            KeyGenParameterSpec spec = new KeyGenParameterSpec.Builder(alias, 3).setCertificateSubject(principal).setCertificateSerialNumber(BigInteger.ONE).setBlockModes(new String[]{"CBC"}).setEncryptionPaddings(new String[]{"PKCS7Padding"}).build();
            KeyGenerator kg = KeyGenerator.getInstance("AES", KEY_STORE_TYPE);
            kg.init((AlgorithmParameterSpec)spec);
            kg.generateKey();
        } else {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance(ALGORITHM_RSA, KEY_STORE_TYPE);
            KeyPairGeneratorSpec spec = new KeyPairGeneratorSpec.Builder(context).setAlias(alias).setSubject(principal).setSerialNumber(BigInteger.ONE).setStartDate(start.getTime()).setEndDate(end.getTime()).build();
            kpg.initialize((AlgorithmParameterSpec)spec);
            kpg.generateKeyPair();
        }
    }

    @NonNull
    private static String base64Encode(@NonNull byte[] bytes) {
        return new String(Base64.encode((byte[])bytes, (int)2), CharsetsUtils.UTF8);
    }

    @NonNull
    private static byte[] base64decode(@NonNull String encoded) {
        return Base64.decode((String)encoded, (int)2);
    }
}

