/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.preference.DialogPreference;
import com.serenegiant.common.R;
import com.serenegiant.utils.TypedArrayUtils;
import java.util.Locale;

public class NumberPickerPreferenceV7
extends DialogPreference {
    private static final boolean DEBUG = false;
    private static final String TAG = NumberPickerPreferenceV7.class.getSimpleName();
    private int mDefaultValue;
    private final int mMinValue;
    private final int mMaxValue;
    private int mValue;

    public NumberPickerPreferenceV7(@NonNull Context context) {
        this(context, null);
    }

    public NumberPickerPreferenceV7(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, TypedArrayUtils.getAttr(context, R.attr.dialogPreferenceStyle, 0x1010091));
    }

    public NumberPickerPreferenceV7(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.NumberPicker, defStyle, 0);
        this.mDefaultValue = a.getInt(R.styleable.NumberPicker_DefaultValue, 0);
        int min = a.getInt(R.styleable.NumberPicker_MinValue, 0);
        int max = a.getInt(R.styleable.NumberPicker_MaxValue, 100);
        a.recycle();
        this.mMinValue = Math.min(min, max);
        this.mMaxValue = Math.max(min, max);
        this.setPositiveButtonText(17039370);
        this.setNegativeButtonText(0x1040000);
    }

    protected Object onGetDefaultValue(TypedArray a, int index) {
        return a.getString(index);
    }

    protected void onSetInitialValue(@Nullable Object defaultValue) {
        if (defaultValue != null) {
            this.mDefaultValue = Integer.parseInt((String)defaultValue);
        }
        this.mValue = this.getPersistedInt(this.mDefaultValue);
        this.setSummary(this.getSummary());
    }

    public CharSequence getSummary() {
        return String.format(Locale.US, "%d", this.mValue);
    }

    public int getMinValue() {
        return this.mMinValue;
    }

    public int getMaxValue() {
        return this.mMaxValue;
    }

    public int getValue() {
        return this.mValue;
    }

    public void setValue(int value) {
        boolean changed;
        boolean bl = changed = this.getValue() != value;
        if (changed) {
            this.mValue = value;
            this.persistInt(value);
            if (changed) {
                this.notifyChanged();
            }
        }
    }
}

