/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.preference;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.security.KeyPairGeneratorSpec;
import android.security.keystore.KeyGenParameterSpec;
import android.text.TextUtils;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.serenegiant.nio.CharsetsUtils;
import com.serenegiant.security.ObfuscatorException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.x500.X500Principal;

public class EncryptedSharedPreferences
implements SharedPreferences {
    private static final boolean DEBUG = false;
    private static final String TAG = EncryptedSharedPreferences.class.getSimpleName();
    @NonNull
    private final SharedPreferences mSharedPreferences;
    @NonNull
    final Obfuscator mObfuscator;

    public EncryptedSharedPreferences(@NonNull SharedPreferences preferences, @NonNull Obfuscator obfuscator) {
        this.mSharedPreferences = preferences;
        this.mObfuscator = obfuscator;
    }

    @NonNull
    public Set<String> keySet() {
        Map map = this.mSharedPreferences.getAll();
        return new HashSet<String>(map.keySet());
    }

    public Map<String, ?> getAll() {
        throw new UnsupportedOperationException("#getAll is not available");
    }

    @Nullable
    public String getString(String key, @Nullable String defValue) {
        try {
            return this.unobfuscate(key, defValue);
        }
        catch (ObfuscatorException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Nullable
    public Set<String> getStringSet(String key, @Nullable Set<String> defValues) {
        throw new UnsupportedOperationException("#getStringSet is not available");
    }

    public int getInt(String key, int defValue) {
        try {
            return Integer.parseInt(this.unobfuscate(key, Integer.toString(defValue)));
        }
        catch (ObfuscatorException e) {
            throw new IllegalArgumentException(e);
        }
        catch (NumberFormatException e) {
            throw new ClassCastException();
        }
    }

    public long getLong(String key, long defValue) {
        try {
            return Long.parseLong(this.unobfuscate(key, Long.toString(defValue)));
        }
        catch (ObfuscatorException e) {
            throw new IllegalArgumentException(e);
        }
        catch (NumberFormatException e) {
            throw new ClassCastException();
        }
    }

    public float getFloat(String key, float defValue) {
        try {
            return Float.parseFloat(this.unobfuscate(key, Float.toString(defValue)));
        }
        catch (ObfuscatorException e) {
            throw new IllegalArgumentException(e);
        }
        catch (NumberFormatException e) {
            throw new ClassCastException();
        }
    }

    public boolean getBoolean(String key, boolean defValue) {
        try {
            return Boolean.parseBoolean(this.unobfuscate(key, Boolean.toString(defValue)));
        }
        catch (ObfuscatorException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean contains(String key) {
        return this.mSharedPreferences.contains(key);
    }

    public SharedPreferences.Editor edit() {
        return new EncryptedEditor(this.mSharedPreferences.edit(), this.mObfuscator);
    }

    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.mSharedPreferences.registerOnSharedPreferenceChangeListener(listener);
    }

    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.mSharedPreferences.unregisterOnSharedPreferenceChangeListener(listener);
    }

    @Nullable
    private String unobfuscate(@NonNull String key, @Nullable String defaultValue) throws ObfuscatorException {
        String encrypted = this.mSharedPreferences.getString(key, null);
        if (encrypted != null) {
            return this.mObfuscator.decrypt(key, encrypted);
        }
        return defaultValue;
    }

    @RequiresApi(api=18)
    public static class KeyStoreObfuscator
    implements Obfuscator {
        private static final String KEY_STORE_TYPE = "AndroidKeyStore";
        private static final String header = "com.serenegiant.KeyStoreObfuscator-1|";
        private static final String ALGORITHM_RSA = "RSA";
        private static final String CIPHER_TRANSFORMATION_RSA = "RSA/ECB/PKCS1Padding";
        @TargetApi(value=23)
        private static final String CIPHER_TRANSFORMATION_AES = "AES/CBC/PKCS7Padding";
        @NonNull
        private final Context mContext;
        @NonNull
        private final String alias;

        public static void deleteKey(@NonNull Context context, @Nullable String name) {
            String alias = context.getPackageName() + (!TextUtils.isEmpty((CharSequence)name) ? ":" + name : "");
            try {
                KeyStore keyStore = KeyStore.getInstance(KEY_STORE_TYPE);
                keyStore.load(null);
                if (keyStore.containsAlias(alias)) {
                    keyStore.deleteEntry(alias);
                }
            }
            catch (IOException | GeneralSecurityException exception) {
                // empty catch block
            }
        }

        public KeyStoreObfuscator(@NonNull Context context, @Nullable String name) throws GeneralSecurityException {
            this.mContext = context;
            this.alias = context.getPackageName() + (!TextUtils.isEmpty((CharSequence)name) ? ":" + name : "");
            try {
                KeyStore.Entry entry = this.getKey();
                if (entry == null) {
                    throw new GeneralSecurityException("key entry not found");
                }
            }
            catch (IOException e) {
                throw new GeneralSecurityException(e);
            }
        }

        @Override
        @Nullable
        public String encrypt(@NonNull String key, @Nullable String value) {
            if (TextUtils.isEmpty((CharSequence)value)) {
                return null;
            }
            if (Build.VERSION.SDK_INT >= 23) {
                return this.encryptAES(key, value);
            }
            return this.encryptRSA(key, value);
        }

        @Override
        @Nullable
        public String decrypt(@NonNull String key, @Nullable String encrypted) throws ObfuscatorException {
            if (TextUtils.isEmpty((CharSequence)encrypted)) {
                return null;
            }
            if (Build.VERSION.SDK_INT >= 23) {
                return this.decryptAES(key, encrypted);
            }
            return this.decryptRSA(key, encrypted);
        }

        private String encryptRSA(@NonNull String key, @NonNull String value) {
            try {
                KeyStore.Entry entry = this.getKey();
                PublicKey publicKey = ((KeyStore.PrivateKeyEntry)entry).getCertificate().getPublicKey();
                Cipher encryptor = Cipher.getInstance(CIPHER_TRANSFORMATION_RSA);
                encryptor.init(1, publicKey);
                return KeyStoreObfuscator.base64Encode(encryptor.doFinal((header + key + value).getBytes(CharsetsUtils.UTF8)));
            }
            catch (IOException | GeneralSecurityException e) {
                throw new RuntimeException("Invalid environment", e);
            }
        }

        private String decryptRSA(@NonNull String key, @NonNull String encrypted) throws ObfuscatorException {
            try {
                KeyStore.Entry entry = this.getKey();
                PrivateKey privateKey = ((KeyStore.PrivateKeyEntry)entry).getPrivateKey();
                Cipher decryptor = Cipher.getInstance(CIPHER_TRANSFORMATION_RSA);
                decryptor.init(2, privateKey);
                String result = new String(decryptor.doFinal(KeyStoreObfuscator.base64decode(encrypted)), CharsetsUtils.UTF8);
                int headerIndex = result.indexOf(header + key);
                if (headerIndex != 0) {
                    throw new ObfuscatorException("Header not found (invalid data or key)" + "");
                }
                return result.substring(header.length() + key.length());
            }
            catch (IOException | GeneralSecurityException e) {
                throw new ObfuscatorException(e.getMessage() + "");
            }
            catch (IllegalArgumentException e) {
                throw new ObfuscatorException(e.getMessage() + "");
            }
        }

        @RequiresApi(api=23)
        private String encryptAES(@NonNull String key, @NonNull String value) {
            try {
                KeyStore.Entry entry = this.getKey();
                SecretKey secretKey = ((KeyStore.SecretKeyEntry)entry).getSecretKey();
                Cipher encryptor = Cipher.getInstance(CIPHER_TRANSFORMATION_AES);
                encryptor.init(1, secretKey);
                return KeyStoreObfuscator.base64Encode(encryptor.getIV()) + "|" + KeyStoreObfuscator.base64Encode(encryptor.doFinal((header + key + value).getBytes(CharsetsUtils.UTF8)));
            }
            catch (IOException | GeneralSecurityException e) {
                throw new RuntimeException("Invalid environment", e);
            }
        }

        @RequiresApi(api=23)
        private String decryptAES(@NonNull String key, @NonNull String encrypted) throws ObfuscatorException {
            String[] split = encrypted.split("\\|");
            if (split.length < 2) {
                throw new ObfuscatorException("Unexpected encrypted format");
            }
            try {
                KeyStore.Entry entry = this.getKey();
                SecretKey secretKey = ((KeyStore.SecretKeyEntry)entry).getSecretKey();
                Cipher decryptor = Cipher.getInstance(CIPHER_TRANSFORMATION_AES);
                decryptor.init(2, (Key)secretKey, new IvParameterSpec(KeyStoreObfuscator.base64decode(split[0])));
                String result = new String(decryptor.doFinal(KeyStoreObfuscator.base64decode(split[1])), CharsetsUtils.UTF8);
                int headerIndex = result.indexOf(header + key);
                if (headerIndex != 0) {
                    throw new ObfuscatorException("Header not found (invalid data or key)" + "");
                }
                return result.substring(header.length() + key.length());
            }
            catch (GeneralSecurityException e) {
                throw new ObfuscatorException(e.getMessage() + "");
            }
            catch (IllegalArgumentException e) {
                throw new ObfuscatorException(e.getMessage() + "");
            }
            catch (IOException e) {
                throw new ObfuscatorException(e.getMessage() + "");
            }
        }

        @Nullable
        private KeyStore.Entry getKey() throws GeneralSecurityException, IOException {
            KeyStore keyStore = KeyStore.getInstance(KEY_STORE_TYPE);
            keyStore.load(null);
            boolean containsAlias = keyStore.containsAlias(this.alias);
            if (containsAlias) {
                Key key = keyStore.getKey(this.alias, null);
                if (Build.VERSION.SDK_INT >= 23 && ALGORITHM_RSA.equals(key.getAlgorithm())) {
                    keyStore.deleteEntry(this.alias);
                    containsAlias = false;
                }
            }
            if (!containsAlias) {
                this.createKey();
            }
            return keyStore.getEntry(this.alias, null);
        }

        private void createKey() throws GeneralSecurityException {
            Calendar start = Calendar.getInstance(Locale.ENGLISH);
            Calendar end = Calendar.getInstance(Locale.ENGLISH);
            end.add(1, 1);
            X500Principal principal = new X500Principal("CN=" + this.alias + " O=" + this.mContext.getPackageName());
            if (Build.VERSION.SDK_INT >= 23) {
                KeyGenParameterSpec spec = new KeyGenParameterSpec.Builder(this.alias, 3).setCertificateSubject(principal).setCertificateSerialNumber(BigInteger.ONE).setBlockModes(new String[]{"CBC"}).setEncryptionPaddings(new String[]{"PKCS7Padding"}).build();
                KeyGenerator kg = KeyGenerator.getInstance("AES", KEY_STORE_TYPE);
                kg.init((AlgorithmParameterSpec)spec);
                kg.generateKey();
            } else {
                KeyPairGenerator kpg = KeyPairGenerator.getInstance(ALGORITHM_RSA, KEY_STORE_TYPE);
                KeyPairGeneratorSpec spec = new KeyPairGeneratorSpec.Builder(this.mContext).setAlias(this.alias).setSubject(principal).setSerialNumber(BigInteger.ONE).setStartDate(start.getTime()).setEndDate(end.getTime()).build();
                kpg.initialize((AlgorithmParameterSpec)spec);
                kpg.generateKeyPair();
            }
        }

        @NonNull
        private static String base64Encode(@NonNull byte[] bytes) {
            return new String(Base64.encode((byte[])bytes, (int)2), CharsetsUtils.UTF8);
        }

        @NonNull
        private static byte[] base64decode(@NonNull String encoded) {
            return Base64.decode((String)encoded, (int)2);
        }
    }

    public static class AESObfuscator
    implements Obfuscator {
        private static final String KEYGEN_ALGORITHM = "PBEWITHSHAAND256BITAES-CBC-BC";
        private static final String CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";
        private static final String DEFAULT_HEADER = "com.serenegiant.AESObfuscator-1|";
        @NonNull
        private final String header;
        @NonNull
        private final Cipher mEncryptor;
        @NonNull
        private final Cipher mDecryptor;

        public AESObfuscator(@Nullable char[] password, @NonNull byte[] salt, @NonNull byte[] iv) throws GeneralSecurityException {
            this(null, password, salt, 1024, 256, iv);
        }

        public AESObfuscator(@Nullable String header, @Nullable char[] password, @NonNull byte[] salt, @NonNull byte[] iv) throws GeneralSecurityException {
            this(header, password, salt, 1024, 256, iv);
        }

        public AESObfuscator(@Nullable String header, @Nullable char[] password, @NonNull byte[] salt, int iterationCount, int keyLength, @NonNull byte[] iv) throws GeneralSecurityException {
            this.header = TextUtils.isEmpty((CharSequence)header) ? DEFAULT_HEADER : header;
            SecretKeyFactory factory = SecretKeyFactory.getInstance(KEYGEN_ALGORITHM);
            PBEKeySpec keySpec = new PBEKeySpec(password, salt, iterationCount, keyLength);
            SecretKey tmp = factory.generateSecret(keySpec);
            SecretKeySpec secret = new SecretKeySpec(tmp.getEncoded(), "AES");
            this.mEncryptor = Cipher.getInstance(CIPHER_ALGORITHM);
            this.mEncryptor.init(1, (Key)secret, new IvParameterSpec(iv));
            this.mDecryptor = Cipher.getInstance(CIPHER_ALGORITHM);
            this.mDecryptor.init(2, (Key)secret, new IvParameterSpec(iv));
        }

        @Override
        @Nullable
        public String encrypt(@NonNull String key, @Nullable String value) {
            if (TextUtils.isEmpty((CharSequence)value)) {
                return null;
            }
            try {
                return new String(Base64.encode((byte[])this.mEncryptor.doFinal((this.header + key + value).getBytes(CharsetsUtils.UTF8)), (int)2), CharsetsUtils.UTF8);
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException("Invalid environment", e);
            }
        }

        @Override
        @Nullable
        public String decrypt(@NonNull String key, @Nullable String encrypted) throws ObfuscatorException {
            if (TextUtils.isEmpty((CharSequence)encrypted)) {
                return null;
            }
            try {
                String result = new String(this.mDecryptor.doFinal(Base64.decode((String)encrypted, (int)2)), CharsetsUtils.UTF8);
                int headerIndex = result.indexOf(this.header + key);
                if (headerIndex != 0) {
                    throw new ObfuscatorException("Header not found (invalid data or key)" + "");
                }
                return result.substring(this.header.length() + key.length());
            }
            catch (IllegalArgumentException e) {
                throw new ObfuscatorException(e.getMessage() + "");
            }
            catch (IllegalBlockSizeException e) {
                throw new ObfuscatorException(e.getMessage() + "");
            }
            catch (BadPaddingException e) {
                throw new ObfuscatorException(e.getMessage() + "");
            }
        }
    }

    private static class EncryptedEditor
    implements SharedPreferences.Editor {
        @NonNull
        private final SharedPreferences.Editor mEditor;
        @NonNull
        final Obfuscator mObfuscator;

        public EncryptedEditor(@NonNull SharedPreferences.Editor editor, @NonNull Obfuscator obfuscator) {
            this.mEditor = editor;
            this.mObfuscator = obfuscator;
        }

        public SharedPreferences.Editor putString(String key, @Nullable String value) {
            if (!TextUtils.isEmpty((CharSequence)value)) {
                this.mEditor.putString(key, this.obfuscate(key, value));
            } else {
                this.remove(key);
            }
            return this;
        }

        public SharedPreferences.Editor putStringSet(String key, @Nullable Set<String> values) {
            throw new UnsupportedOperationException("#putStringSet is not available");
        }

        public SharedPreferences.Editor putInt(String key, int value) {
            this.putString(key, Integer.toString(value));
            return this;
        }

        public SharedPreferences.Editor putLong(String key, long value) {
            this.putString(key, Long.toString(value));
            return this;
        }

        public SharedPreferences.Editor putFloat(String key, float value) {
            this.putString(key, Float.toString(value));
            return this;
        }

        public SharedPreferences.Editor putBoolean(String key, boolean value) {
            this.putString(key, Boolean.toString(value));
            return this;
        }

        public SharedPreferences.Editor remove(String key) {
            this.mEditor.remove(key);
            return this;
        }

        public SharedPreferences.Editor clear() {
            this.mEditor.clear();
            return this;
        }

        public boolean commit() {
            return this.mEditor.commit();
        }

        public void apply() {
            this.mEditor.apply();
        }

        @Nullable
        private String obfuscate(@NonNull String key, @NonNull String value) {
            return this.mObfuscator.encrypt(key, value);
        }
    }

    public static interface Obfuscator {
        @Nullable
        public String encrypt(@NonNull String var1, @Nullable String var2);

        @Nullable
        public String decrypt(@NonNull String var1, @Nullable String var2) throws ObfuscatorException;
    }
}

