/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.net;

import android.util.Log;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collections;

public class NetworkUtils {
    private static final String TAG = NetworkUtils.class.getSimpleName();

    public static String getLocalIPv4Address() {
        try {
            for (NetworkInterface intf : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                for (InetAddress inetAddress : Collections.list(intf.getInetAddresses())) {
                    if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                    return inetAddress.getHostAddress();
                }
            }
            for (NetworkInterface intf : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                for (InterfaceAddress interfaceAddress : intf.getInterfaceAddresses()) {
                    InetAddress ad = interfaceAddress.getAddress();
                    if (ad.isLoopbackAddress() || ad instanceof Inet4Address) continue;
                    return ad.getHostAddress();
                }
            }
        }
        catch (NullPointerException | SocketException e) {
            Log.e((String)TAG, (String)"getLocalIPv4Address", (Throwable)e);
        }
        return null;
    }

    public static String getLocalIPv6Address() {
        try {
            for (NetworkInterface intf : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                for (InetAddress addr : Collections.list(intf.getInetAddresses())) {
                    if (addr.isLoopbackAddress() || !(addr instanceof Inet6Address)) continue;
                    return addr.getHostAddress();
                }
            }
        }
        catch (NullPointerException | SocketException e) {
            Log.w((String)TAG, (String)"getLocalIPv6Address", (Throwable)e);
        }
        return null;
    }
}

