/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.mediastore;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.mediastore.MediaInfo;
import com.serenegiant.mediastore.ThumbnailLoaderDrawable;
import com.serenegiant.utils.ThreadPool;
import java.util.concurrent.FutureTask;

public abstract class ThumbnailLoader
implements Runnable {
    private static final boolean DEBUG = false;
    private static final String TAG = ThumbnailLoader.class.getSimpleName();
    @NonNull
    protected final ThumbnailLoaderDrawable mParent;
    @NonNull
    private final FutureTask<Bitmap> mTask;
    @NonNull
    private final MediaInfo mInfo = new MediaInfo();
    @Nullable
    private Bitmap mBitmap;

    public ThumbnailLoader(@NonNull ThumbnailLoaderDrawable parent) {
        this.mParent = parent;
        this.mTask = new FutureTask<Object>(this, null);
    }

    public long id() {
        return this.mInfo.id;
    }

    @Nullable
    public Uri getUri() {
        return this.mInfo.getUri();
    }

    public synchronized void startLoad(@NonNull MediaInfo info) {
        this.mInfo.set(info);
        this.mBitmap = null;
        ThreadPool.queueEvent(this.mTask);
    }

    public void cancelLoad() {
        this.mTask.cancel(true);
    }

    @Nullable
    protected abstract Bitmap loadThumbnail(@NonNull Context var1, @NonNull MediaInfo var2, int var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MediaInfo info;
        ThumbnailLoader thumbnailLoader = this;
        synchronized (thumbnailLoader) {
            info = new MediaInfo(this.mInfo);
        }
        if (!this.mTask.isCancelled()) {
            this.mBitmap = this.loadThumbnail(this.mParent.getContext(), info, this.mParent.getIntrinsicWidth(), this.mParent.getIntrinsicHeight());
        }
        if (this.mTask.isCancelled() || !info.equals(this.mInfo)) {
            return;
        }
        this.mParent.scheduleSelf(this.mParent, 0L);
    }

    @Nullable
    public Bitmap getBitmap() {
        return this.mBitmap;
    }
}

