/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.SuppressLint;
import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.serenegiant.media.AbstractDecoder;
import com.serenegiant.media.DecoderListener;
import com.serenegiant.system.BuildCheck;
import java.io.IOException;
import java.nio.ByteBuffer;

@RequiresApi(value=16)
public abstract class VideoDecoder
extends AbstractDecoder {
    private static final boolean DEBUG = false;
    private static final String TAG = VideoDecoder.class.getSimpleName();
    private final Surface mOutputSurface;

    @SuppressLint(value={"NewApi"})
    @NonNull
    public static VideoDecoder createDecoder(@NonNull Surface outputSurface, @NonNull DecoderListener listener) {
        if (BuildCheck.isAPI21()) {
            return new VideoDecoderAPI21(outputSurface, listener);
        }
        return new VideoDecoderAPI16(outputSurface, listener);
    }

    private VideoDecoder(@NonNull Surface outputSurface, @NonNull DecoderListener listener) {
        super("video/", listener);
        this.mOutputSurface = outputSurface;
    }

    @Override
    protected void internalPrepare(int trackIndex, @NonNull MediaFormat format) {
    }

    @Override
    protected MediaCodec createDecoder(int trackIndex, @NonNull MediaFormat format) throws IOException {
        MediaCodec codec = null;
        if (trackIndex >= 0) {
            String mime = format.getString("mime");
            try {
                codec = MediaCodec.createDecoderByType((String)mime);
                codec.configure(format, this.mOutputSurface, null, 0);
                codec.start();
            }
            catch (IOException e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
        return codec;
    }

    @RequiresApi(value=21)
    private static class VideoDecoderAPI21
    extends VideoDecoder {
        private static final String TAG = VideoDecoderAPI21.class.getSimpleName();

        private VideoDecoderAPI21(@NonNull Surface outputSurface, @NonNull DecoderListener listener) {
            super(outputSurface, listener);
        }

        @Override
        public void decode(@NonNull MediaExtractor extractor) {
            if (this.mDecoder != null) {
                this.decodeAPI21(extractor, this.mDecoder);
            }
        }

        @Override
        protected AbstractDecoder.OutputTask createOutputTask(int trackIndex) {
            return new AbstractDecoder.OutputTask(trackIndex){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void handleOutput(@NonNull MediaCodec decoder) {
                    while (this.isRunning() && !mOutputDone) {
                        int decoderStatus = decoder.dequeueOutputBuffer(mBufferInfo, 10000L);
                        if (decoderStatus == -1) {
                            return;
                        }
                        if (decoderStatus == -3 || decoderStatus == -2) continue;
                        if (decoderStatus < 0) {
                            throw new RuntimeException("unexpected result from video decoder.dequeueOutputBuffer: " + decoderStatus);
                        }
                        decoder.releaseOutputBuffer(decoderStatus, this.adjustPresentationTime(mBufferInfo.presentationTimeUs));
                        if ((mBufferInfo.flags & 4) == 0) continue;
                        Object object = mSync;
                        synchronized (object) {
                            mOutputDone = true;
                            mSync.notifyAll();
                        }
                    }
                }
            };
        }
    }

    private static class VideoDecoderAPI16
    extends VideoDecoder {
        private static final String TAG = VideoDecoderAPI16.class.getSimpleName();
        @Nullable
        private ByteBuffer[] mInputBuffers;

        private VideoDecoderAPI16(@NonNull Surface outputSurface, @NonNull DecoderListener listener) {
            super(outputSurface, listener);
        }

        @Override
        protected MediaCodec createDecoder(int trackIndex, @NonNull MediaFormat format) throws IOException {
            MediaCodec codec = super.createDecoder(trackIndex, format);
            this.mInputBuffers = codec.getInputBuffers();
            return codec;
        }

        @Override
        public void decode(@NonNull MediaExtractor extractor) {
            if (this.mDecoder != null) {
                this.decodeAPI16(extractor, this.mDecoder, this.mInputBuffers);
            }
        }

        @Override
        protected AbstractDecoder.OutputTask createOutputTask(int trackIndex) {
            return new AbstractDecoder.OutputTask(trackIndex){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void handleOutput(@NonNull MediaCodec decoder) {
                    while (this.isRunning() && !mOutputDone) {
                        boolean doRender;
                        int decoderStatus = decoder.dequeueOutputBuffer(mBufferInfo, 10000L);
                        if (decoderStatus == -1) {
                            return;
                        }
                        if (decoderStatus == -3 || decoderStatus == -2) continue;
                        if (decoderStatus < 0) {
                            throw new RuntimeException("unexpected result from video decoder.dequeueOutputBuffer: " + decoderStatus);
                        }
                        boolean bl = doRender = mBufferInfo.size > 0;
                        if (doRender && !this.onFrameAvailable(mBufferInfo.presentationTimeUs)) {
                            this.adjustPresentationTime(mBufferInfo.presentationTimeUs);
                        }
                        decoder.releaseOutputBuffer(decoderStatus, doRender);
                        if ((mBufferInfo.flags & 4) == 0) continue;
                        Object object = mSync;
                        synchronized (object) {
                            mOutputDone = true;
                            mSync.notifyAll();
                        }
                    }
                }
            };
        }
    }
}

