/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.content.Context;
import android.content.Intent;
import android.media.projection.MediaProjectionManager;
import androidx.activity.ComponentActivity;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.fragment.app.Fragment;

@RequiresApi(value=21)
public class ScreenCaptureUtils {
    private static final boolean DEBUG = false;
    private static final String TAG = ScreenCaptureUtils.class.getSimpleName();
    @NonNull
    private final ActivityResultLauncher<Void> mLauncher;
    private boolean mRequestProjection;

    public ScreenCaptureUtils(@NonNull ComponentActivity activity, @NonNull ScreenCaptureCallback callback) {
        this.mLauncher = activity.registerForActivityResult((ActivityResultContract)new ScreenCapture(), result -> {
            if (result != null) {
                callback.onResult((Intent)result);
            } else {
                callback.onFailed();
            }
        });
    }

    public ScreenCaptureUtils(@NonNull Fragment fragment, @NonNull ScreenCaptureCallback callback) {
        this.mLauncher = fragment.registerForActivityResult((ActivityResultContract)new ScreenCapture(), result -> {
            if (result != null) {
                callback.onResult((Intent)result);
            } else {
                callback.onFailed();
            }
        });
    }

    public void requestScreenCapture() {
        if (!this.mRequestProjection) {
            this.mRequestProjection = true;
            this.mLauncher.launch(null);
        }
    }

    private static class ScreenCapture
    extends ActivityResultContract<Void, Intent> {
        private static final String TAG = ScreenCapture.class.getSimpleName();

        private ScreenCapture() {
        }

        @CallSuper
        @NonNull
        public Intent createIntent(@NonNull Context context, Void unsued) {
            MediaProjectionManager manager = (MediaProjectionManager)context.getSystemService("media_projection");
            return manager.createScreenCaptureIntent();
        }

        @Nullable
        public final ActivityResultContract.SynchronousResult<Intent> getSynchronousResult(@NonNull Context context, @Nullable Void unused) {
            return null;
        }

        @Nullable
        public final Intent parseResult(int resultCode, @Nullable Intent intent) {
            return intent != null && resultCode == -1 ? intent : null;
        }
    }

    public static interface ScreenCaptureCallback {
        public void onResult(@NonNull Intent var1);

        public void onFailed();
    }
}

