/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaFormat;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.documentfile.provider.DocumentFile;
import com.serenegiant.media.IMuxer;
import com.serenegiant.media.MediaMuxerWrapper;
import com.serenegiant.media.PostMuxCommon;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.FileChannel;

class PostMuxBuilder
extends PostMuxCommon {
    private static final boolean DEBUG = false;
    private static final String TAG = PostMuxBuilder.class.getSimpleName();
    private static final long MSEC30US = 33333L;
    private volatile boolean mIsRunning;
    @NonNull
    private final IMuxer.IMuxerFactory mMuxerFactory;
    private final boolean mUseMediaMuxer;

    public PostMuxBuilder(boolean useMediaMuxer) {
        this(null, useMediaMuxer);
    }

    public PostMuxBuilder(@Nullable IMuxer.IMuxerFactory factory, boolean useMediaMuxer) {
        this.mMuxerFactory = factory != null ? factory : new IMuxer.DefaultFactory();
        this.mUseMediaMuxer = useMediaMuxer;
    }

    public void cancel() {
        this.mIsRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void buildFromRawFile(@NonNull Context context, @NonNull String tempDirPath, @NonNull String outputPath) throws IOException {
        MediaMuxerWrapper muxer;
        boolean hasAudio;
        File tempDir = new File(tempDirPath);
        File videoFile = new File(tempDir, "video.raw");
        File audioFile = new File(tempDir, "audio.raw");
        File output = new File(outputPath);
        boolean hasVideo = videoFile.exists() && videoFile.canRead();
        boolean bl = hasAudio = audioFile.exists() && audioFile.canRead();
        if ((hasVideo || hasAudio) && (muxer = new MediaMuxerWrapper(outputPath, 0)) != null) {
            this.mIsRunning = true;
            try {
                DataInputStream videoIn = hasVideo ? new DataInputStream(new BufferedInputStream(new FileInputStream(videoFile))) : null;
                DataInputStream audioIn = hasAudio ? new DataInputStream(new BufferedInputStream(new FileInputStream(audioFile))) : null;
                this.internalBuild((IMuxer)muxer, videoIn, audioIn);
            }
            finally {
                this.mIsRunning = false;
                muxer.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    public void buildFromRawFile(@NonNull Context context, @NonNull String tempDirPath, @NonNull DocumentFile output) throws IOException {
        boolean hasAudio;
        File tempDir = new File(tempDirPath);
        File videoFile = new File(tempDir, "video.raw");
        File audioFile = new File(tempDir, "audio.raw");
        boolean hasVideo = videoFile.exists() && videoFile.canRead();
        boolean bl = hasAudio = audioFile.exists() && audioFile.canRead();
        if (hasVideo || hasAudio) {
            IMuxer muxer = this.mMuxerFactory.createMuxer(context, this.mUseMediaMuxer, output);
            if (muxer == null) {
                throw new IOException("Failed to create muxer");
            }
            if (muxer != null) {
                try {
                    DataInputStream videoIn = hasVideo ? new DataInputStream(new BufferedInputStream(new FileInputStream(videoFile))) : null;
                    DataInputStream audioIn = hasAudio ? new DataInputStream(new BufferedInputStream(new FileInputStream(audioFile))) : null;
                    this.internalBuild(muxer, videoIn, audioIn);
                }
                finally {
                    this.mIsRunning = false;
                    muxer.release();
                }
            } else {
                throw new IOException("Failed to create muxer");
            }
        }
    }

    private void internalBuild(@NonNull IMuxer muxer, @Nullable DataInputStream videoIn, @Nullable DataInputStream audioIn) throws IOException {
        MediaFormat format;
        int videoTrack = -1;
        int audioTrack = -1;
        if (videoIn != null && (format = PostMuxBuilder.readFormat(videoIn)) != null) {
            videoTrack = muxer.addTrack(format);
        }
        if (audioIn != null && (format = PostMuxBuilder.readFormat(audioIn)) != null) {
            audioTrack = muxer.addTrack(format);
        }
        if (videoTrack >= 0 || audioTrack >= 0) {
            this.mIsRunning = true;
            ByteBuffer videoBuf = null;
            MediaCodec.BufferInfo videoBufInfo = null;
            PostMuxCommon.MediaFrameHeader videoFrameHeader = null;
            if (videoTrack >= 0) {
                videoBufInfo = new MediaCodec.BufferInfo();
                videoFrameHeader = new PostMuxCommon.MediaFrameHeader();
            }
            ByteBuffer audioBuf = null;
            MediaCodec.BufferInfo audioBufInfo = new MediaCodec.BufferInfo();
            PostMuxCommon.MediaFrameHeader audioFrameHeader = null;
            if (audioTrack >= 0) {
                audioBufInfo = new MediaCodec.BufferInfo();
                audioFrameHeader = new PostMuxCommon.MediaFrameHeader();
            }
            byte[] readBuf = new byte[65536];
            int videoSequence = 0;
            int audioSequence = 0;
            long videoTimeOffset = -1L;
            long videoPresentationTimeUs = -33333L;
            long audioTimeOffset = -1L;
            long audioPresentationTimeUs = -33333L;
            muxer.start();
            while (this.mIsRunning && (videoTrack >= 0 || audioTrack >= 0)) {
                if (videoTrack >= 0) {
                    try {
                        videoBuf = PostMuxBuilder.readStream(videoIn, videoFrameHeader, videoBuf, readBuf);
                        videoFrameHeader.asBufferInfo(videoBufInfo);
                        if (videoSequence != videoFrameHeader.sequence) {
                            videoSequence = videoFrameHeader.sequence;
                            videoTimeOffset = videoPresentationTimeUs - videoBufInfo.presentationTimeUs + 33333L;
                        }
                        videoBufInfo.presentationTimeUs += videoTimeOffset;
                        muxer.writeSampleData(videoTrack, videoBuf, videoBufInfo);
                        videoPresentationTimeUs = videoBufInfo.presentationTimeUs;
                    }
                    catch (IllegalArgumentException e) {
                        videoTrack = -1;
                    }
                    catch (IOException e) {
                        videoTrack = -1;
                    }
                }
                if (audioTrack < 0) continue;
                try {
                    audioBuf = PostMuxBuilder.readStream(audioIn, audioFrameHeader, audioBuf, readBuf);
                    audioFrameHeader.asBufferInfo(audioBufInfo);
                    if (audioSequence != audioFrameHeader.sequence) {
                        audioSequence = audioFrameHeader.sequence;
                        audioTimeOffset = audioPresentationTimeUs - audioBufInfo.presentationTimeUs + 33333L;
                    }
                    audioBufInfo.presentationTimeUs += audioTimeOffset;
                    muxer.writeSampleData(audioTrack, audioBuf, audioBufInfo);
                    audioPresentationTimeUs = audioBufInfo.presentationTimeUs;
                }
                catch (IllegalArgumentException e) {
                    audioTrack = -1;
                }
                catch (IOException e) {
                    audioTrack = -1;
                }
            }
            muxer.stop();
        }
        if (videoIn != null) {
            videoIn.close();
        }
        if (audioIn != null) {
            audioIn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void buildFromRawChannel(@NonNull Context context, @NonNull String tempDirPath, @NonNull String outputPath) throws IOException {
        MediaMuxerWrapper muxer;
        boolean hasAudio;
        File tempDir = new File(tempDirPath);
        File videoFile = new File(tempDir, "video.raw");
        File audioFile = new File(tempDir, "audio.raw");
        File output = new File(outputPath);
        boolean hasVideo = videoFile.exists() && videoFile.canRead();
        boolean bl = hasAudio = audioFile.exists() && audioFile.canRead();
        if ((hasVideo || hasAudio) && (muxer = new MediaMuxerWrapper(outputPath, 0)) != null) {
            this.mIsRunning = true;
            try {
                FileChannel videoIn = hasVideo ? new FileInputStream(videoFile).getChannel() : null;
                FileChannel audioIn = hasAudio ? new FileInputStream(audioFile).getChannel() : null;
                this.internalBuild((IMuxer)muxer, videoIn, audioIn);
            }
            finally {
                this.mIsRunning = false;
                muxer.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    public void buildFromRawChannel(@NonNull Context context, @NonNull String tempDirPath, @NonNull DocumentFile output) throws IOException {
        boolean hasAudio;
        File tempDir = new File(tempDirPath);
        File videoFile = new File(tempDir, "video.raw");
        File audioFile = new File(tempDir, "audio.raw");
        boolean hasVideo = videoFile.exists() && videoFile.canRead();
        boolean bl = hasAudio = audioFile.exists() && audioFile.canRead();
        if (hasVideo || hasAudio) {
            IMuxer muxer = this.mMuxerFactory.createMuxer(context, this.mUseMediaMuxer, output);
            if (muxer == null) {
                throw new IOException("Failed to create muxer");
            }
            if (muxer != null) {
                try {
                    FileChannel videoIn = hasVideo ? new FileInputStream(videoFile).getChannel() : null;
                    FileChannel audioIn = hasAudio ? new FileInputStream(audioFile).getChannel() : null;
                    this.internalBuild(muxer, videoIn, audioIn);
                }
                finally {
                    this.mIsRunning = false;
                    muxer.release();
                }
            } else {
                throw new IOException("Failed to create muxer");
            }
        }
    }

    private void internalBuild(@NonNull IMuxer muxer, @Nullable ByteChannel videoIn, @Nullable ByteChannel audioIn) throws IOException {
        MediaFormat format;
        int videoTrack = -1;
        int audioTrack = -1;
        if (videoIn != null && (format = PostMuxBuilder.readFormat(videoIn)) != null) {
            videoTrack = muxer.addTrack(format);
        }
        if (audioIn != null && (format = PostMuxBuilder.readFormat(audioIn)) != null) {
            audioTrack = muxer.addTrack(format);
        }
        if (videoTrack >= 0 || audioTrack >= 0) {
            this.mIsRunning = true;
            ByteBuffer videoBuf = null;
            MediaCodec.BufferInfo videoBufInfo = null;
            PostMuxCommon.MediaFrameHeader videoFrameHeader = null;
            if (videoTrack >= 0) {
                videoBufInfo = new MediaCodec.BufferInfo();
                videoFrameHeader = new PostMuxCommon.MediaFrameHeader();
            }
            ByteBuffer audioBuf = null;
            MediaCodec.BufferInfo audioBufInfo = new MediaCodec.BufferInfo();
            PostMuxCommon.MediaFrameHeader audioFrameHeader = null;
            if (audioTrack >= 0) {
                audioBufInfo = new MediaCodec.BufferInfo();
                audioFrameHeader = new PostMuxCommon.MediaFrameHeader();
            }
            int videoSequence = 0;
            int audioSequence = 0;
            long videoTimeOffset = -1L;
            long videoPresentationTimeUs = -33333L;
            long audioTimeOffset = -1L;
            long audioPresentationTimeUs = -33333L;
            muxer.start();
            while (this.mIsRunning && (videoTrack >= 0 || audioTrack >= 0)) {
                if (videoTrack >= 0) {
                    try {
                        videoBuf = PostMuxBuilder.readStream(videoIn, videoFrameHeader, videoBuf);
                        videoFrameHeader.asBufferInfo(videoBufInfo);
                        if (videoSequence != videoFrameHeader.sequence) {
                            videoSequence = videoFrameHeader.sequence;
                            videoTimeOffset = videoPresentationTimeUs - videoBufInfo.presentationTimeUs + 33333L;
                        }
                        videoBufInfo.presentationTimeUs += videoTimeOffset;
                        muxer.writeSampleData(videoTrack, videoBuf, videoBufInfo);
                        videoPresentationTimeUs = videoBufInfo.presentationTimeUs;
                    }
                    catch (IllegalArgumentException e) {
                        videoTrack = -1;
                    }
                    catch (IOException e) {
                        videoTrack = -1;
                    }
                }
                if (audioTrack < 0) continue;
                try {
                    audioBuf = PostMuxBuilder.readStream(audioIn, audioFrameHeader, audioBuf);
                    audioFrameHeader.asBufferInfo(audioBufInfo);
                    if (audioSequence != audioFrameHeader.sequence) {
                        audioSequence = audioFrameHeader.sequence;
                        audioTimeOffset = audioPresentationTimeUs - audioBufInfo.presentationTimeUs + 33333L;
                    }
                    audioBufInfo.presentationTimeUs += audioTimeOffset;
                    muxer.writeSampleData(audioTrack, audioBuf, audioBufInfo);
                    audioPresentationTimeUs = audioBufInfo.presentationTimeUs;
                }
                catch (IllegalArgumentException e) {
                    audioTrack = -1;
                }
                catch (IOException e) {
                    audioTrack = -1;
                }
            }
            muxer.stop();
        }
        if (videoIn != null) {
            videoIn.close();
        }
        if (audioIn != null) {
            audioIn.close();
        }
    }
}

