/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.res.AssetFileDescriptor;
import android.media.MediaExtractor;
import android.media.MediaMetadataRetriever;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.serenegiant.media.AudioDecoder;
import com.serenegiant.media.Decoder;
import com.serenegiant.media.DecoderListener;
import com.serenegiant.media.IFrameCallback;
import com.serenegiant.media.VideoDecoder;
import com.serenegiant.system.BuildCheck;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;

@SuppressLint(value={"InlinedApi"})
@TargetApi(value=16)
public class MediaPlayer {
    private static final boolean DEBUG = false;
    private static final String TAG = MediaPlayer.class.getSimpleName();
    private static final int TIMEOUT_USEC = 10000;
    private static final int STATE_STOP = 0;
    private static final int STATE_PREPARED = 1;
    private static final int STATE_PLAYING = 2;
    private static final int STATE_PAUSED = 3;
    private static final int REQ_NON = 0;
    private static final int REQ_PREPARE = 1;
    private static final int REQ_START = 2;
    private static final int REQ_SEEK = 3;
    private static final int REQ_STOP = 4;
    private static final int REQ_PAUSE = 5;
    private static final int REQ_RESUME = 6;
    private static final int REQ_QUIT = 9;
    @NonNull
    private final Object mSync = new Object();
    @Nullable
    private final Surface mOutputSurface;
    @NonNull
    private final IFrameCallback mCallback;
    private final boolean mAudioEnabled;
    @NonNull
    private final MediaMetadataRetriever mMetadata = new MediaMetadataRetriever();
    private int mVideoWidth;
    private int mVideoHeight;
    private long mDuration;
    private int mBitrate;
    private float mFrameRate;
    private int mRotation;
    private volatile boolean mIsRunning;
    private int mState;
    @Nullable
    private Object mSource;
    private int mRequest;
    private long mRequestTime;
    @NonNull
    private final MediaExtractor mExtractor;
    private volatile boolean mLoopEnabled;
    @Nullable
    private VideoDecoder mVideoDecoder;
    private int mVideoTrackIndex;
    @Nullable
    private AudioDecoder mAudioDecoder;
    private int mAudioTrackIndex;
    private final Runnable mMoviePlayerTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @WorkerThread
        public final void run() {
            boolean isRunning = false;
            try {
                Object object = MediaPlayer.this.mSync;
                synchronized (object) {
                    isRunning = MediaPlayer.this.mIsRunning = true;
                    MediaPlayer.this.mState = 0;
                    MediaPlayer.this.mRequest = 0;
                    MediaPlayer.this.mRequestTime = -1L;
                    MediaPlayer.this.mSync.notifyAll();
                }
                while (isRunning) {
                    try {
                        int localReq;
                        object = MediaPlayer.this.mSync;
                        synchronized (object) {
                            isRunning = MediaPlayer.this.mIsRunning;
                            localReq = MediaPlayer.this.mRequest;
                            MediaPlayer.this.mRequest = 0;
                        }
                        switch (MediaPlayer.this.mState) {
                            case 0: {
                                isRunning = MediaPlayer.this.processStop(localReq);
                                break;
                            }
                            case 1: {
                                isRunning = MediaPlayer.this.processPrepared(localReq);
                                break;
                            }
                            case 2: {
                                isRunning = MediaPlayer.this.processPlaying(localReq);
                                break;
                            }
                            case 3: {
                                isRunning = MediaPlayer.this.processPaused(localReq);
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    catch (Exception e) {
                        Log.e((String)TAG, (String)"MoviePlayerTask:", (Throwable)e);
                        break;
                    }
                }
            }
            finally {
                MediaPlayer.this.handleStop();
            }
        }
    };
    private final DecoderListener mListener = new DecoderListener(){

        @Override
        public void onStartDecode(@NonNull Decoder decoder) {
        }

        @Override
        public void onStopDecode(@NonNull Decoder decoder) {
        }

        @Override
        public void onDestroy(@NonNull Decoder decoder) {
        }

        @Override
        public void onError(@NonNull Throwable t) {
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaPlayer(@Nullable Surface outputSurface, @NonNull IFrameCallback callback, boolean audioEnabled) throws NullPointerException, IllegalArgumentException {
        if (callback == null) {
            throw new NullPointerException("callback should not be null");
        }
        if (outputSurface == null && !audioEnabled) {
            throw new IllegalArgumentException("Should playback at least either video or audio.");
        }
        this.mOutputSurface = outputSurface;
        this.mCallback = callback;
        this.mAudioEnabled = audioEnabled;
        this.mExtractor = new MediaExtractor();
        new Thread(this.mMoviePlayerTask, TAG).start();
        Object object = this.mSync;
        synchronized (object) {
            try {
                if (!this.mIsRunning) {
                    this.mSync.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoop(boolean loopEnabled) {
        Object object = this.mSync;
        synchronized (object) {
            this.mLoopEnabled = loopEnabled;
        }
    }

    public final int getWidth() {
        return this.mVideoWidth;
    }

    public final int getHeight() {
        return this.mVideoHeight;
    }

    public final int getBitRate() {
        return this.mBitrate;
    }

    public final float getFramerate() {
        return this.mFrameRate;
    }

    public final int getRotation() {
        return this.mRotation;
    }

    public final long getDurationUs() {
        return this.mDuration;
    }

    public boolean hasAudio() {
        return this.mAudioEnabled && this.mAudioDecoder != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPlaying() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mState == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPaused() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mState == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(@NonNull String src) {
        Object object = this.mSync;
        synchronized (object) {
            this.mSource = src;
            this.mRequest = 1;
            this.mSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(@NonNull AssetFileDescriptor src) {
        Object object = this.mSync;
        synchronized (object) {
            this.mSource = src;
            this.mRequest = 1;
            this.mSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mState == 2) {
                return;
            }
            this.mRequest = 2;
            this.mSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seek(long newTime) {
        Object object = this.mSync;
        synchronized (object) {
            this.mRequest = 3;
            this.mRequestTime = newTime;
            this.mSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mState != 0) {
                this.mRequest = 4;
                this.mSync.notifyAll();
                try {
                    this.mSync.wait(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mState == 2) {
                this.mRequest = 5;
                this.mSync.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mState == 3) {
                this.mRequest = 6;
                this.mSync.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        this.stop();
        Object object = this.mSync;
        synchronized (object) {
            this.mRequest = 9;
            this.mSync.notifyAll();
        }
    }

    @Nullable
    public String extractMetadata(int key) {
        return this.mMetadata.extractMetadata(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private boolean processStop(int req) throws InterruptedException, IOException {
        Object object;
        boolean isRunning = true;
        switch (req) {
            case 1: {
                this.handlePrepare(this.mSource);
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                throw new IllegalStateException("invalid state:" + this.mState);
            }
            case 9: {
                isRunning = false;
                break;
            }
            default: {
                object = this.mSync;
                synchronized (object) {
                    this.mSync.wait();
                    break;
                }
            }
        }
        object = this.mSync;
        synchronized (object) {
        }
        return isRunning &= this.mIsRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private boolean processPrepared(int req) throws InterruptedException {
        Object object;
        boolean isRunning = true;
        switch (req) {
            case 2: {
                this.handleStart();
                break;
            }
            case 5: 
            case 6: {
                throw new IllegalStateException("invalid state:" + this.mState);
            }
            case 4: {
                this.handleStop();
                break;
            }
            case 9: {
                isRunning = false;
                break;
            }
            default: {
                object = this.mSync;
                synchronized (object) {
                    this.mSync.wait();
                    break;
                }
            }
        }
        object = this.mSync;
        synchronized (object) {
        }
        return isRunning &= this.mIsRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private boolean processPlaying(int req) {
        boolean isRunning = true;
        switch (req) {
            case 1: 
            case 2: 
            case 6: {
                throw new IllegalStateException("invalid state:" + this.mState);
            }
            case 3: {
                this.handleSeek(this.mRequestTime);
                break;
            }
            case 4: {
                this.handleStop();
                break;
            }
            case 5: {
                this.handlePause();
                break;
            }
            case 9: {
                isRunning = false;
                break;
            }
            default: {
                this.handleLoop(this.mCallback);
            }
        }
        Object object = this.mSync;
        synchronized (object) {
        }
        return isRunning &= this.mIsRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private boolean processPaused(int req) throws InterruptedException {
        Object object;
        boolean isRunning = true;
        switch (req) {
            case 1: 
            case 2: {
                throw new IllegalStateException("invalid state:" + this.mState);
            }
            case 3: {
                this.handleSeek(this.mRequestTime);
                break;
            }
            case 4: {
                this.handleStop();
                break;
            }
            case 6: {
                this.handleResume();
                break;
            }
            case 9: {
                isRunning = false;
                break;
            }
            default: {
                object = this.mSync;
                synchronized (object) {
                    this.mSync.wait();
                    break;
                }
            }
        }
        object = this.mSync;
        synchronized (object) {
        }
        return isRunning &= this.mIsRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void handlePrepare(Object source) throws IOException {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mState != 0) {
                throw new RuntimeException("invalid state:" + this.mState);
            }
        }
        if (source instanceof String) {
            String srcString = (String)source;
            File src = new File(srcString);
            if (TextUtils.isEmpty((CharSequence)srcString) || !src.canRead()) {
                throw new FileNotFoundException("Unable to read " + source);
            }
            this.mMetadata.setDataSource((String)source);
            this.mExtractor.setDataSource((String)source);
        } else if (source instanceof AssetFileDescriptor) {
            FileDescriptor fd = ((AssetFileDescriptor)source).getFileDescriptor();
            this.mMetadata.setDataSource(fd);
            if (BuildCheck.isAndroid7()) {
                this.mExtractor.setDataSource((AssetFileDescriptor)source);
            } else {
                this.mExtractor.setDataSource(fd);
            }
        } else if (source instanceof FileDescriptor) {
            this.mMetadata.setDataSource((FileDescriptor)source);
            this.mExtractor.setDataSource((FileDescriptor)source);
        } else {
            throw new IllegalArgumentException("unknown source type:source=" + source);
        }
        this.updateInfo(this.mMetadata);
        if (this.mOutputSurface != null && this.mVideoDecoder == null) {
            this.mVideoDecoder = VideoDecoder.createDecoder(this.mOutputSurface, this.mListener);
            this.mVideoTrackIndex = this.mVideoDecoder.prepare(this.mExtractor);
        } else {
            this.mVideoTrackIndex = -100;
        }
        if (this.mAudioEnabled && this.mAudioDecoder == null) {
            this.mAudioDecoder = AudioDecoder.createDecoder(this.mListener);
            this.mAudioTrackIndex = this.mAudioDecoder.prepare(this.mExtractor);
        } else {
            this.mAudioTrackIndex = -100;
        }
        object = this.mSync;
        synchronized (object) {
            this.mState = 1;
        }
        this.mCallback.onPrepared();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void handleStart() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mState != 1) {
                throw new RuntimeException("invalid state:" + this.mState);
            }
            this.mState = 2;
        }
        if (this.mRequestTime > 0L) {
            this.handleSeek(this.mRequestTime);
        }
        if (this.mVideoDecoder != null) {
            this.mVideoDecoder.start();
        }
        if (this.mAudioDecoder != null) {
            this.mAudioDecoder.start();
        }
    }

    @WorkerThread
    private void handleSeek(long newTimeUs) {
        if (newTimeUs < 0L) {
            return;
        }
        if (this.mExtractor != null) {
            this.mExtractor.seekTo(newTimeUs, 2);
            this.mExtractor.advance();
        }
        this.mRequestTime = -1L;
    }

    @WorkerThread
    private void handleLoop(IFrameCallback frameCallback) {
        if (this.mExtractor != null) {
            int trackIndex = this.mExtractor.getSampleTrackIndex();
            if (trackIndex == this.mVideoTrackIndex) {
                this.mVideoDecoder.decode(this.mExtractor);
            } else if (trackIndex == this.mAudioTrackIndex) {
                this.mAudioDecoder.decode(this.mExtractor);
            }
            if (!this.mExtractor.advance()) {
                if (this.mLoopEnabled) {
                    this.handleSeek(0L);
                } else {
                    if (this.mVideoDecoder != null) {
                        this.mVideoDecoder.signalEndOfStream();
                    }
                    if (this.mAudioDecoder != null) {
                        this.mAudioDecoder.signalEndOfStream();
                    }
                    this.handleStop();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void handleStop() {
        boolean needCallOnFinished;
        Object object = this.mSync;
        synchronized (object) {
            if (this.mVideoDecoder != null) {
                this.mVideoDecoder.release();
                this.mVideoDecoder = null;
            }
            if (this.mAudioDecoder != null) {
                this.mAudioDecoder.release();
                this.mAudioDecoder = null;
            }
        }
        Object object2 = this.mSync;
        synchronized (object2) {
            needCallOnFinished = this.mState != 0;
            this.mState = 0;
        }
        if (needCallOnFinished) {
            this.mCallback.onFinished();
        }
    }

    @WorkerThread
    private void handlePause() {
    }

    @WorkerThread
    private void handleResume() {
    }

    private void updateInfo(@NonNull MediaMetadataRetriever metaData) {
        this.mBitrate = 0;
        this.mRotation = 0;
        this.mVideoHeight = 0;
        this.mVideoWidth = 0;
        this.mDuration = 0L;
        this.mFrameRate = 0.0f;
        String value = metaData.extractMetadata(18);
        if (!TextUtils.isEmpty((CharSequence)value)) {
            this.mVideoWidth = Integer.parseInt(value);
        }
        if (!TextUtils.isEmpty((CharSequence)(value = metaData.extractMetadata(19)))) {
            this.mVideoHeight = Integer.parseInt(value);
        }
        if (Build.VERSION.SDK_INT >= 17 && !TextUtils.isEmpty((CharSequence)(value = metaData.extractMetadata(24)))) {
            this.mRotation = Integer.parseInt(value);
        }
        if (!TextUtils.isEmpty((CharSequence)(value = metaData.extractMetadata(20)))) {
            this.mBitrate = Integer.parseInt(value);
        }
        if (!TextUtils.isEmpty((CharSequence)(value = metaData.extractMetadata(9)))) {
            this.mDuration = Long.parseLong(value) * 1000L;
        }
    }
}

