/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.media.AudioRecord;
import android.os.Process;
import android.util.Log;
import androidx.annotation.NonNull;
import com.serenegiant.media.AbstractAudioEncoder;
import com.serenegiant.media.AudioSampler;
import com.serenegiant.media.EncoderListener;
import com.serenegiant.media.IAudioSampler;
import com.serenegiant.media.IRecorder;
import com.serenegiant.media.MemMediaQueue;
import com.serenegiant.media.RecycleMediaData;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.TimeUnit;

public class AudioEncoderBuffered
extends AbstractAudioEncoder {
    private static final String TAG = AudioEncoderBuffered.class.getSimpleName();
    private static final int MAX_POOL_SIZE = 100;
    private static final int MAX_QUEUE_SIZE = 100;
    private AudioThread mAudioThread = null;
    private DequeueThread mDequeueThread = null;
    protected final int mBufferSize = 1024;
    @NonNull
    private final MemMediaQueue mAudioQueue;

    public AudioEncoderBuffered(@NonNull IRecorder recorder, @NonNull EncoderListener listener, int audio_source, int audio_channels) {
        super(recorder, listener, audio_source, audio_channels, 44100, 64000);
        if (audio_source < 0 || audio_source > 7) {
            throw new IllegalArgumentException("invalid audio source:" + audio_source);
        }
        this.mAudioQueue = new MemMediaQueue(100, 100, 100);
    }

    @Override
    public void start() {
        super.start();
        if (this.mAudioThread == null) {
            this.mAudioThread = new AudioThread();
            this.mAudioThread.start();
            this.mDequeueThread = new DequeueThread();
            this.mDequeueThread.start();
        }
    }

    @Override
    public void stop() {
        this.mAudioThread = null;
        this.mDequeueThread = null;
        super.stop();
    }

    private final class DequeueThread
    extends Thread {
        public DequeueThread() {
            super("DequeueThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            int frame_count = 0;
            while (true) {
                RecycleMediaData data;
                Object object = AudioEncoderBuffered.this.mSync;
                synchronized (object) {
                    if (!AudioEncoderBuffered.this.mIsCapturing || AudioEncoderBuffered.this.mRequestStop) {
                        break;
                    }
                }
                try {
                    data = AudioEncoderBuffered.this.mAudioQueue.poll(30L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e1) {
                    break;
                }
                if (data == null) continue;
                if (data.size() > 0) {
                    AudioEncoderBuffered.this.encode(data.get(), data.size(), data.presentationTimeUs());
                    AudioEncoderBuffered.this.frameAvailableSoon();
                    ++frame_count;
                }
                data.recycle();
            }
            if (frame_count == 0) {
                ByteBuffer buf = ByteBuffer.allocateDirect(1024).order(ByteOrder.nativeOrder());
                for (int i = 0; AudioEncoderBuffered.this.mIsCapturing && i < 5; ++i) {
                    buf.position(1024);
                    buf.flip();
                    AudioEncoderBuffered.this.encode(buf, 1024, AudioEncoderBuffered.this.getInputPTSUs());
                    AudioEncoderBuffered.this.frameAvailableSoon();
                    DequeueThread dequeueThread = this;
                    synchronized (dequeueThread) {
                        try {
                            this.wait(50L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                }
            }
        }
    }

    private final class AudioThread
    extends Thread {
        public AudioThread() {
            super("AudioThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final void run() {
            Process.setThreadPriority((int)-16);
            int buffer_size = AudioSampler.getAudioBufferSize(AudioEncoderBuffered.this.mChannelCount, AudioEncoderBuffered.this.mSampleRate, 1024, 25);
            AudioRecord audioRecord = IAudioSampler.createAudioRecord(AudioEncoderBuffered.this.mAudioSource, AudioEncoderBuffered.this.mSampleRate, AudioEncoderBuffered.this.mChannelCount, 2, buffer_size);
            int err_count = 0;
            if (audioRecord == null) return;
            try {
                if (!AudioEncoderBuffered.this.mIsCapturing) return;
                audioRecord.startRecording();
                try {
                    while (AudioEncoderBuffered.this.mIsCapturing) {
                        int readBytes;
                        if (AudioEncoderBuffered.this.mRequestStop) {
                            return;
                        }
                        int recordingState = audioRecord.getRecordingState();
                        if (recordingState != 3) {
                            if (err_count == 0) {
                                Log.e((String)TAG, (String)("not a recording state," + recordingState));
                            }
                            if (++err_count > 20) {
                                return;
                            }
                            Object object = AudioEncoderBuffered.this.mSync;
                            synchronized (object) {
                                AudioEncoderBuffered.this.mSync.wait(100L);
                                continue;
                            }
                        }
                        RecycleMediaData data = AudioEncoderBuffered.this.mAudioQueue.obtain(1024);
                        ByteBuffer buffer = data.get();
                        buffer.clear();
                        try {
                            readBytes = audioRecord.read(buffer, 1024);
                        }
                        catch (Exception e) {
                            return;
                        }
                        if (readBytes > 0) {
                            err_count = 0;
                            data.presentationTimeUs(AudioEncoderBuffered.this.getInputPTSUs()).size(readBytes);
                            buffer.position(readBytes);
                            buffer.flip();
                            AudioEncoderBuffered.this.mAudioQueue.queueFrame(data);
                            continue;
                        }
                        if (readBytes == 0) {
                            err_count = 0;
                            data.recycle();
                            continue;
                        }
                        if (readBytes == -1) {
                            if (err_count == 0) {
                                Log.e((String)TAG, (String)"Read error ERROR");
                            }
                        } else if (readBytes == -2) {
                            if (err_count == 0) {
                                Log.e((String)TAG, (String)"Read error ERROR_BAD_VALUE");
                            }
                        } else if (readBytes == -3) {
                            if (err_count == 0) {
                                Log.e((String)TAG, (String)"Read error ERROR_INVALID_OPERATION");
                            }
                        } else {
                            if (readBytes == -6) {
                                Log.e((String)TAG, (String)"Read error ERROR_DEAD_OBJECT");
                                data.recycle();
                                return;
                            }
                            if (readBytes < 0 && err_count == 0) {
                                Log.e((String)TAG, (String)("Read returned unknown err " + readBytes));
                            }
                        }
                        data.recycle();
                        if (++err_count > 10) return;
                    }
                    return;
                }
                finally {
                    audioRecord.stop();
                }
            }
            catch (Exception exception) {
                return;
            }
            finally {
                audioRecord.release();
            }
        }
    }
}

