/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.io;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.nio.CharsetsUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.ByteChannel;

public class ChannelHelper {
    private ChannelHelper() {
    }

    public static boolean readBoolean(@NonNull ByteChannel channel) throws IOException {
        return ChannelHelper.readBoolean(channel, null);
    }

    public static boolean readBoolean(@NonNull ByteChannel channel, @Nullable ByteBuffer work) throws IOException {
        ByteBuffer buf = ChannelHelper.checkBuffer(work, 1);
        int readBytes = channel.read(buf);
        if (readBytes != 1) {
            throw new IOException();
        }
        buf.clear();
        return buf.get() != 0;
    }

    public static byte readByte(@NonNull ByteChannel channel) throws IOException {
        return ChannelHelper.readByte(channel, null);
    }

    public static byte readByte(@NonNull ByteChannel channel, @Nullable ByteBuffer work) throws IOException {
        ByteBuffer buf = ChannelHelper.checkBuffer(work, 1);
        int readBytes = channel.read(buf);
        if (readBytes != 1) {
            throw new IOException();
        }
        buf.clear();
        return buf.get();
    }

    public static char readChar(@NonNull ByteChannel channel) throws IOException {
        return ChannelHelper.readChar(channel, null);
    }

    public static char readChar(@NonNull ByteChannel channel, @Nullable ByteBuffer work) throws IOException {
        ByteBuffer buf = ChannelHelper.checkBuffer(work, 2);
        int readBytes = channel.read(buf);
        if (readBytes != 2) {
            throw new IOException();
        }
        buf.clear();
        return buf.getChar();
    }

    public static short readShort(@NonNull ByteChannel channel) throws IOException {
        return ChannelHelper.readShort(channel, null);
    }

    public static short readShort(@NonNull ByteChannel channel, @Nullable ByteBuffer work) throws IOException {
        ByteBuffer buf = ChannelHelper.checkBuffer(work, 2);
        int readBytes = channel.read(buf);
        if (readBytes != 2) {
            throw new IOException();
        }
        buf.clear();
        return buf.getShort();
    }

    public static int readInt(@NonNull ByteChannel channel) throws IOException {
        return ChannelHelper.readInt(channel, null);
    }

    public static int readInt(@NonNull ByteChannel channel, @Nullable ByteBuffer work) throws IOException {
        ByteBuffer buf = ChannelHelper.checkBuffer(work, 4);
        int readBytes = channel.read(buf);
        if (readBytes != 4) {
            throw new IOException();
        }
        buf.clear();
        return buf.getInt();
    }

    public static long readLong(@NonNull ByteChannel channel) throws IOException {
        return ChannelHelper.readLong(channel, null);
    }

    public static long readLong(@NonNull ByteChannel channel, @Nullable ByteBuffer work) throws IOException {
        ByteBuffer buf = ChannelHelper.checkBuffer(work, 8);
        int readBytes = channel.read(buf);
        if (readBytes != 8) {
            throw new IOException();
        }
        buf.clear();
        return buf.getLong();
    }

    public static float readFloat(@NonNull ByteChannel channel) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(4);
        int readBytes = channel.read(buf);
        if (readBytes != 4) {
            throw new IOException();
        }
        buf.clear();
        return buf.getFloat();
    }

    public static float readFloat(@NonNull ByteChannel channel, @Nullable ByteBuffer work) throws IOException {
        ByteBuffer buf = ChannelHelper.checkBuffer(work, 4);
        int readBytes = channel.read(buf);
        if (readBytes != 4) {
            throw new IOException();
        }
        buf.clear();
        return buf.getFloat();
    }

    public static double readDouble(@NonNull ByteChannel channel) throws IOException {
        return ChannelHelper.readDouble(channel, null);
    }

    public static double readDouble(@NonNull ByteChannel channel, @Nullable ByteBuffer work) throws IOException {
        ByteBuffer buf = ChannelHelper.checkBuffer(work, 8);
        int readBytes = channel.read(buf);
        if (readBytes != 8) {
            throw new IOException();
        }
        buf.clear();
        return buf.getDouble();
    }

    public static String readString(@NonNull ByteChannel channel) throws IOException {
        int bytes = ChannelHelper.readInt(channel);
        byte[] buf = new byte[bytes];
        ByteBuffer b = ByteBuffer.wrap(buf);
        int readBytes = channel.read(b);
        if (readBytes != bytes) {
            throw new IOException();
        }
        return new String(buf, CharsetsUtils.UTF8);
    }

    public static boolean[] readBooleanArray(@NonNull ByteChannel channel) throws IOException {
        int n = ChannelHelper.readInt(channel);
        ByteBuffer buf = ByteBuffer.allocate(n);
        int readBytes = channel.read(buf);
        if (readBytes != n) {
            throw new IOException();
        }
        buf.clear();
        boolean[] result = new boolean[n];
        for (int i = 0; i < n; ++i) {
            result[i] = buf.get() != 0;
        }
        return result;
    }

    public static byte[] readByteArray(@NonNull ByteChannel channel) throws IOException {
        int n = ChannelHelper.readInt(channel);
        byte[] result = new byte[n];
        ByteBuffer buf = ByteBuffer.wrap(result);
        int readBytes = channel.read(buf);
        if (readBytes != n) {
            throw new IOException();
        }
        return result;
    }

    public static char[] readCharArray(@NonNull ByteChannel channel) throws IOException {
        int n = ChannelHelper.readInt(channel);
        ByteBuffer buf = ByteBuffer.allocate(n * 2).order(ByteOrder.BIG_ENDIAN);
        int readBytes = channel.read(buf);
        if (readBytes != n * 2) {
            throw new IOException();
        }
        buf.clear();
        CharBuffer result = buf.asCharBuffer();
        if (result.hasArray()) {
            return result.array();
        }
        char[] b = new char[n];
        result.get(b);
        return b;
    }

    public static short[] readShortArray(@NonNull ByteChannel channel) throws IOException {
        int n = ChannelHelper.readInt(channel);
        ByteBuffer buf = ByteBuffer.allocate(n * 2).order(ByteOrder.BIG_ENDIAN);
        int readBytes = channel.read(buf);
        if (readBytes != n * 2) {
            throw new IOException();
        }
        buf.clear();
        ShortBuffer result = buf.asShortBuffer();
        if (result.hasArray()) {
            return result.array();
        }
        short[] b = new short[n];
        result.get(b);
        return b;
    }

    public static int[] readIntArray(@NonNull ByteChannel channel) throws IOException {
        int n = ChannelHelper.readInt(channel);
        ByteBuffer buf = ByteBuffer.allocate(n * 4).order(ByteOrder.BIG_ENDIAN);
        int readBytes = channel.read(buf);
        if (readBytes != n * 4) {
            throw new IOException();
        }
        buf.clear();
        IntBuffer result = buf.asIntBuffer();
        if (result.hasArray()) {
            return result.array();
        }
        int[] b = new int[n];
        result.get(b);
        return b;
    }

    public static long[] readLongArray(@NonNull ByteChannel channel) throws IOException {
        int n = ChannelHelper.readInt(channel);
        ByteBuffer buf = ByteBuffer.allocate(n * 8).order(ByteOrder.BIG_ENDIAN);
        int readBytes = channel.read(buf);
        if (readBytes != n * 8) {
            throw new IOException();
        }
        buf.clear();
        LongBuffer result = buf.asLongBuffer();
        if (result.hasArray()) {
            return result.array();
        }
        long[] b = new long[n];
        result.get(b);
        return b;
    }

    public static float[] readFloatArray(@NonNull ByteChannel channel) throws IOException {
        int n = ChannelHelper.readInt(channel);
        ByteBuffer buf = ByteBuffer.allocate(n * 4).order(ByteOrder.BIG_ENDIAN);
        int readBytes = channel.read(buf);
        if (readBytes != n * 4) {
            throw new IOException();
        }
        buf.clear();
        FloatBuffer result = buf.asFloatBuffer();
        if (result.hasArray()) {
            return result.array();
        }
        float[] b = new float[n];
        result.get(b);
        return b;
    }

    public static double[] readDoubleArray(@NonNull ByteChannel channel) throws IOException {
        int n = ChannelHelper.readInt(channel);
        ByteBuffer buf = ByteBuffer.allocate(n * 8).order(ByteOrder.BIG_ENDIAN);
        int readBytes = channel.read(buf);
        if (readBytes != n * 8) {
            throw new IOException();
        }
        buf.clear();
        DoubleBuffer result = buf.asDoubleBuffer();
        if (result.hasArray()) {
            return result.array();
        }
        double[] b = new double[n];
        result.get(b);
        return b;
    }

    public static ByteBuffer readByteBuffer(@NonNull ByteChannel channel) throws IOException {
        return ChannelHelper.readByteBuffer(channel, null, true);
    }

    public static ByteBuffer readByteBuffer(@NonNull ByteChannel channel, @NonNull ByteBuffer buf) throws IOException {
        return ChannelHelper.readByteBuffer(channel, buf, false);
    }

    public static ByteBuffer readByteBuffer(@NonNull ByteChannel channel, @Nullable ByteBuffer readBuf, boolean canReAllocate) throws IOException {
        int n = ChannelHelper.readInt(channel);
        int pos = readBuf != null ? readBuf.position() : 0;
        ByteBuffer buf = readBuf;
        if (buf == null || buf.remaining() < n) {
            if (canReAllocate) {
                if (buf == null) {
                    buf = ByteBuffer.allocateDirect(n);
                } else {
                    ByteBuffer temp = ByteBuffer.allocateDirect(readBuf.limit() + n);
                    buf.flip();
                    temp.put(buf);
                    buf = temp;
                }
            } else {
                throw new IOException();
            }
        }
        buf.limit(pos + n);
        int readBytes = channel.read(buf);
        if (readBytes != n) {
            throw new IOException();
        }
        buf.position(pos);
        buf.limit(pos + n);
        return buf;
    }

    public static void write(@NonNull ByteChannel channel, boolean value) throws IOException {
        ChannelHelper.write(channel, value, null);
    }

    public static void write(@NonNull ByteChannel channel, boolean value, @Nullable ByteBuffer work) throws IOException {
        ByteBuffer buf = ChannelHelper.checkBuffer(work, 1);
        buf.put((byte)(value ? 1 : 0));
        buf.flip();
        channel.write(buf);
    }

    public static void write(@NonNull ByteChannel channel, byte value) throws IOException {
        ChannelHelper.write(channel, value, null);
    }

    public static void write(@NonNull ByteChannel channel, byte value, @Nullable ByteBuffer work) throws IOException {
        ByteBuffer buf = ChannelHelper.checkBuffer(work, 1);
        buf.put(value);
        buf.flip();
        channel.write(buf);
    }

    public static void write(@NonNull ByteChannel channel, char value) throws IOException {
        ChannelHelper.write(channel, value, null);
    }

    public static void write(@NonNull ByteChannel channel, char value, @Nullable ByteBuffer work) throws IOException {
        ByteBuffer buf = ChannelHelper.checkBuffer(work, 2);
        buf.putChar(value);
        buf.flip();
        channel.write(buf);
    }

    public static void write(@NonNull ByteChannel channel, short value) throws IOException {
        ChannelHelper.write(channel, value, null);
    }

    public static void write(@NonNull ByteChannel channel, short value, @Nullable ByteBuffer work) throws IOException {
        ByteBuffer buf = ChannelHelper.checkBuffer(work, 2);
        buf.putShort(value);
        buf.flip();
        channel.write(buf);
    }

    public static void write(@NonNull ByteChannel channel, int value) throws IOException {
        ChannelHelper.write(channel, value, null);
    }

    public static void write(@NonNull ByteChannel channel, int value, @Nullable ByteBuffer work) throws IOException {
        ByteBuffer buf = ChannelHelper.checkBuffer(work, 4);
        buf.putInt(value);
        buf.flip();
        channel.write(buf);
    }

    public static void write(@NonNull ByteChannel channel, long value) throws IOException {
        ChannelHelper.write(channel, value, null);
    }

    public static void write(@NonNull ByteChannel channel, long value, @Nullable ByteBuffer work) throws IOException {
        ByteBuffer buf = ChannelHelper.checkBuffer(work, 8);
        buf.putLong(value);
        buf.flip();
        channel.write(buf);
    }

    public static void write(@NonNull ByteChannel channel, float value) throws IOException {
        ChannelHelper.write(channel, value, null);
    }

    public static void write(@NonNull ByteChannel channel, float value, @Nullable ByteBuffer work) throws IOException {
        ByteBuffer buf = ChannelHelper.checkBuffer(work, 4);
        buf.putFloat(value);
        buf.flip();
        channel.write(buf);
    }

    public static void write(@NonNull ByteChannel channel, double value) throws IOException {
        ChannelHelper.write(channel, value, null);
    }

    public static void write(@NonNull ByteChannel channel, double value, @Nullable ByteBuffer work) throws IOException {
        ByteBuffer buf = ChannelHelper.checkBuffer(work, 8);
        buf.putDouble(value);
        buf.flip();
        channel.write(buf);
    }

    public static void write(@NonNull ByteChannel channel, @NonNull String value) throws IOException {
        byte[] buf = value.getBytes(CharsetsUtils.UTF8);
        ChannelHelper.write(channel, buf.length);
        channel.write(ByteBuffer.wrap(buf));
    }

    public static void write(@NonNull ByteChannel channel, @NonNull boolean[] value) throws IOException {
        ChannelHelper.write(channel, value, null);
    }

    public static void write(@NonNull ByteChannel channel, @NonNull boolean[] value, @Nullable ByteBuffer work) throws IOException {
        int n = value.length;
        ChannelHelper.write(channel, n, work);
        ByteBuffer buf = ChannelHelper.checkBuffer(work, n);
        for (int i = 0; i < n; ++i) {
            buf.put((byte)(value[i] ? 1 : 0));
        }
        buf.flip();
        channel.write(buf);
    }

    public static void write(@NonNull ByteChannel channel, @NonNull byte[] value) throws IOException {
        ChannelHelper.write(channel, value.length);
        channel.write(ByteBuffer.wrap(value));
    }

    public static void write(@NonNull ByteChannel channel, @NonNull char[] value) throws IOException {
        ChannelHelper.write(channel, value, null);
    }

    public static void write(@NonNull ByteChannel channel, @NonNull char[] value, @Nullable ByteBuffer work) throws IOException {
        int n = value.length;
        ChannelHelper.write(channel, n, work);
        ByteBuffer buf = ChannelHelper.checkBuffer(work, n * 2);
        for (int i = 0; i < n; ++i) {
            buf.putChar(value[i]);
        }
        buf.flip();
        channel.write(buf);
    }

    public static void write(@NonNull ByteChannel channel, @NonNull short[] value) throws IOException {
        ChannelHelper.write(channel, value, null);
    }

    public static void write(@NonNull ByteChannel channel, @NonNull short[] value, @Nullable ByteBuffer work) throws IOException {
        int n = value.length;
        ChannelHelper.write(channel, n, work);
        ByteBuffer buf = ChannelHelper.checkBuffer(work, n * 2);
        for (int i = 0; i < n; ++i) {
            buf.putShort(value[i]);
        }
        buf.flip();
        channel.write(buf);
    }

    public static void write(@NonNull ByteChannel channel, @NonNull int[] value) throws IOException {
        ChannelHelper.write(channel, value, null);
    }

    public static void write(@NonNull ByteChannel channel, @NonNull int[] value, @Nullable ByteBuffer work) throws IOException {
        int n = value.length;
        ChannelHelper.write(channel, n, work);
        ByteBuffer buf = ChannelHelper.checkBuffer(work, n * 4);
        for (int i = 0; i < n; ++i) {
            buf.putInt(value[i]);
        }
        buf.flip();
        channel.write(buf);
    }

    public static void write(@NonNull ByteChannel channel, @NonNull long[] value) throws IOException {
        ChannelHelper.write(channel, value, null);
    }

    public static void write(@NonNull ByteChannel channel, @NonNull long[] value, @Nullable ByteBuffer work) throws IOException {
        int n = value.length;
        ChannelHelper.write(channel, n, work);
        ByteBuffer buf = ChannelHelper.checkBuffer(work, n * 8);
        for (int i = 0; i < n; ++i) {
            buf.putLong(value[i]);
        }
        buf.flip();
        channel.write(buf);
    }

    public static void write(@NonNull ByteChannel channel, @NonNull float[] value) throws IOException {
        ChannelHelper.write(channel, value, null);
    }

    public static void write(@NonNull ByteChannel channel, @NonNull float[] value, @Nullable ByteBuffer work) throws IOException {
        int n = value.length;
        ChannelHelper.write(channel, n, work);
        ByteBuffer buf = ChannelHelper.checkBuffer(work, n * 4);
        for (int i = 0; i < n; ++i) {
            buf.putFloat(value[i]);
        }
        buf.flip();
        channel.write(buf);
    }

    public static void write(@NonNull ByteChannel channel, @NonNull double[] value) throws IOException {
        ChannelHelper.write(channel, value, null);
    }

    public static void write(@NonNull ByteChannel channel, @NonNull double[] value, @Nullable ByteBuffer work) throws IOException {
        int n = value.length;
        ChannelHelper.write(channel, n, work);
        ByteBuffer buf = ChannelHelper.checkBuffer(work, n * 8);
        for (int i = 0; i < n; ++i) {
            buf.putDouble(value[i]);
        }
        buf.flip();
        channel.write(buf);
    }

    public static void write(@NonNull ByteChannel channel, @NonNull ByteBuffer value) throws IOException {
        ChannelHelper.write(channel, value.remaining());
        channel.write(value);
    }

    private static ByteBuffer checkBuffer(@Nullable ByteBuffer work, int sz) {
        ByteBuffer buf = work;
        if (buf == null || work.capacity() < sz) {
            buf = ByteBuffer.allocateDirect(sz);
        }
        buf.order(ByteOrder.BIG_ENDIAN);
        buf.clear();
        buf.limit(sz);
        return buf;
    }
}

