/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.glpipeline;

import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.serenegiant.gl.GLDrawer2D;
import com.serenegiant.gl.GLManager;
import com.serenegiant.gl.GLSurface;
import com.serenegiant.gl.GLUtils;
import com.serenegiant.gl.RendererTarget;
import com.serenegiant.glpipeline.GLPipeline;
import com.serenegiant.glpipeline.GLSurfacePipeline;
import com.serenegiant.glpipeline.ProxyPipeline;
import com.serenegiant.glutils.IMirror;
import com.serenegiant.math.Fraction;

public class DrawerPipeline
extends ProxyPipeline
implements GLSurfacePipeline,
IMirror {
    private static final boolean DEBUG = false;
    private static final String TAG = DrawerPipeline.class.getSimpleName();
    public static Callback DEFAULT_CALLBACK = new Callback(){

        @Override
        @NonNull
        public GLDrawer2D createDrawer(@NonNull GLManager glManager, boolean isOES) {
            return GLDrawer2D.create(glManager.isGLES3(), isOES);
        }

        @Override
        public void releaseDrawer(@NonNull GLManager glManager, @NonNull GLDrawer2D drawer) {
            drawer.release();
        }

        @Override
        @Nullable
        public GLDrawer2D onResize(@NonNull GLManager glManager, @Nullable GLDrawer2D drawer, int width, int height) {
            if (drawer != null) {
                drawer.release();
            }
            return null;
        }
    };
    @NonNull
    private final Object mSync = new Object();
    @NonNull
    private final GLManager mManager;
    @NonNull
    private final Callback mCallback;
    @Nullable
    private GLDrawer2D mDrawer;
    @Nullable
    private RendererTarget mRendererTarget;
    private volatile boolean mDrawOnly;
    @Nullable
    private GLSurface offscreenSurface;
    private int mMirror = 0;
    private int cnt;

    public DrawerPipeline(@NonNull GLManager manager, @NonNull Callback callback) throws IllegalStateException, IllegalArgumentException {
        this(manager, callback, null, null);
    }

    public DrawerPipeline(@NonNull GLManager manager, @NonNull Callback callback, final @Nullable Object surface, final @Nullable Fraction maxFps) throws IllegalStateException, IllegalArgumentException {
        if (surface != null && !GLUtils.isSupportedSurface(surface)) {
            throw new IllegalArgumentException("Unsupported surface type!," + surface);
        }
        this.mManager = manager;
        this.mCallback = callback;
        manager.runOnGLThread(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                DrawerPipeline.this.createTargetOnGL(surface, maxFps);
            }
        });
    }

    @Override
    protected void internalRelease() {
        if (this.isValid()) {
            this.releaseAll();
        }
        super.internalRelease();
    }

    @Override
    public void setSurface(@Nullable Object surface) throws IllegalStateException, IllegalArgumentException {
        this.setSurface(surface, null);
    }

    @Override
    public void setSurface(final @Nullable Object surface, final @Nullable Fraction maxFps) throws IllegalStateException, IllegalArgumentException {
        if (!this.isValid()) {
            throw new IllegalStateException("already released?");
        }
        if (surface != null && !GLUtils.isSupportedSurface(surface)) {
            throw new IllegalArgumentException("Unsupported surface type!," + surface);
        }
        this.mManager.runOnGLThread(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                DrawerPipeline.this.createTargetOnGL(surface, maxFps);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasSurface() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mRendererTarget != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getId() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mRendererTarget != null ? this.mRendererTarget.getId() : 0;
        }
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.mManager.isValid();
    }

    public boolean isDrawOnly() {
        return this.mDrawOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMirror(int mirror) {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mMirror != mirror) {
                this.mMirror = mirror;
                this.mManager.runOnGLThread(() -> {
                    if (this.mRendererTarget != null) {
                        this.mRendererTarget.setMirror(IMirror.flipVertical(mirror));
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMirror() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mMirror;
        }
    }

    @Override
    public void setParent(@Nullable GLPipeline parent) {
        super.setParent(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public void onFrameAvailable(boolean isOES, int texId, @NonNull @Size(min=16L) float[] texMatrix) {
        RendererTarget target;
        if (this.mDrawer == null || isOES != this.mDrawer.isOES()) {
            if (this.mDrawer != null) {
                this.mCallback.releaseDrawer(this.mManager, this.mDrawer);
            }
            this.mDrawer = this.mCallback.createDrawer(this.mManager, isOES);
        }
        Object object = this.mSync;
        synchronized (object) {
            target = this.mRendererTarget;
        }
        if (target != null && target.canDraw()) {
            target.draw(this.mDrawer, 33984, texId, texMatrix);
        }
        if (this.mDrawOnly && this.offscreenSurface != null) {
            super.onFrameAvailable(this.offscreenSurface.isOES(), this.offscreenSurface.getTexId(), this.offscreenSurface.getTexMatrix());
        } else {
            super.onFrameAvailable(isOES, texId, texMatrix);
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.isValid()) {
            this.mManager.runOnGLThread(new Runnable(){

                @Override
                @WorkerThread
                public void run() {
                    if (DrawerPipeline.this.mDrawer != null) {
                        DrawerPipeline.this.mCallback.releaseDrawer(DrawerPipeline.this.mManager, DrawerPipeline.this.mDrawer);
                        DrawerPipeline.this.mDrawer = null;
                    }
                }
            });
        }
    }

    @Override
    @CallSuper
    public void resize(final int width, final int height) throws IllegalStateException {
        super.resize(width, height);
        this.mManager.runOnGLThread(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                DrawerPipeline.this.mDrawer = DrawerPipeline.this.mCallback.onResize(DrawerPipeline.this.mManager, DrawerPipeline.this.mDrawer, width, height);
            }
        });
    }

    private void releaseAll() {
        if (this.mManager.isValid()) {
            try {
                this.mManager.runOnGLThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    @WorkerThread
                    public void run() {
                        Object object = DrawerPipeline.this.mSync;
                        synchronized (object) {
                            if (DrawerPipeline.this.mRendererTarget != null) {
                                DrawerPipeline.this.mRendererTarget.release();
                                DrawerPipeline.this.mRendererTarget = null;
                            }
                            if (DrawerPipeline.this.offscreenSurface != null) {
                                DrawerPipeline.this.offscreenSurface.release();
                                DrawerPipeline.this.offscreenSurface = null;
                            }
                        }
                        if (DrawerPipeline.this.mDrawer != null) {
                            DrawerPipeline.this.mCallback.releaseDrawer(DrawerPipeline.this.mManager, DrawerPipeline.this.mDrawer);
                        }
                        DrawerPipeline.this.mDrawer = null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void createTargetOnGL(@Nullable Object surface, @Nullable Fraction maxFps) {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mRendererTarget == null || this.mRendererTarget.getSurface() != surface) {
                if (this.mRendererTarget != null) {
                    this.mRendererTarget.release();
                    this.mRendererTarget = null;
                }
                if (this.offscreenSurface != null) {
                    this.offscreenSurface.release();
                    this.offscreenSurface = null;
                }
                if (GLUtils.isSupportedSurface(surface)) {
                    this.mRendererTarget = RendererTarget.newInstance(this.mManager.getEgl(), surface, maxFps != null ? maxFps.asFloat() : 0.0f);
                    this.mDrawOnly = false;
                } else if (this.isValid()) {
                    this.offscreenSurface = GLSurface.newInstance(this.mManager.isGLES3(), this.getWidth(), this.getHeight());
                    this.mRendererTarget = RendererTarget.newInstance(this.mManager.getEgl(), this.offscreenSurface, maxFps != null ? maxFps.asFloat() : 0.0f);
                    this.mDrawOnly = true;
                }
                if (this.mRendererTarget != null) {
                    this.mRendererTarget.setMirror(IMirror.flipVertical(this.mMirror));
                }
            }
        }
    }

    public static interface Callback {
        @WorkerThread
        @NonNull
        public GLDrawer2D createDrawer(@NonNull GLManager var1, boolean var2);

        @WorkerThread
        public void releaseDrawer(@NonNull GLManager var1, @NonNull GLDrawer2D var2);

        @WorkerThread
        @Nullable
        public GLDrawer2D onResize(@NonNull GLManager var1, @Nullable GLDrawer2D var2, int var3, int var4);
    }
}

