/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.gl;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.content.res.ResourcesCompat;
import com.serenegiant.gl.GLConst;
import com.serenegiant.gl.ShaderConst;
import com.serenegiant.system.Stacktrace;
import com.serenegiant.utils.AssetsHelper;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.FloatBuffer;

@Deprecated
public final class GLHelper
implements GLConst {
    private static final boolean DEBUG = false;
    private static final String TAG = GLHelper.class.getSimpleName();

    private GLHelper() {
    }

    public static void checkGlError(String op) {
        int error = GLES20.glGetError();
        if (error != 0) {
            String msg = op + ": glError 0x" + Integer.toHexString(error);
            Log.e((String)TAG, (String)msg);
            Stacktrace.print();
        }
    }

    public static int initTex(int texTarget, int texUnit, int filterParam) {
        return GLHelper.initTex(texTarget, texUnit, filterParam, filterParam, 33071);
    }

    public static int initTex(int texTarget, int texUnit, int minFilter, int magFilter, int wrap) {
        int[] tex = new int[1];
        GLES20.glActiveTexture((int)texUnit);
        GLES20.glGenTextures((int)1, (int[])tex, (int)0);
        GLES20.glBindTexture((int)texTarget, (int)tex[0]);
        GLES20.glTexParameteri((int)texTarget, (int)10242, (int)wrap);
        GLES20.glTexParameteri((int)texTarget, (int)10243, (int)wrap);
        GLES20.glTexParameteri((int)texTarget, (int)10241, (int)minFilter);
        GLES20.glTexParameteri((int)texTarget, (int)10240, (int)magFilter);
        Log.d((String)TAG, (String)("initTex:texId=" + tex[0]));
        return tex[0];
    }

    public static int[] initTexes(int n, int texTarget, int filterParam) {
        return GLHelper.initTexes(new int[n], texTarget, filterParam, filterParam, 33071);
    }

    public static int[] initTexes(@NonNull int[] texIds, int texTarget, int filterParam) {
        return GLHelper.initTexes(texIds, texTarget, filterParam, filterParam, 33071);
    }

    public static int[] initTexes(int n, int texTarget, int minFilter, int magFilter, int wrap) {
        return GLHelper.initTexes(new int[n], texTarget, minFilter, magFilter, wrap);
    }

    public static int[] initTexes(@NonNull int[] texIds, int texTarget, int minFilter, int magFilter, int wrap) {
        int[] textureUnits = new int[1];
        GLES20.glGetIntegerv((int)34930, (int[])textureUnits, (int)0);
        Log.v((String)TAG, (String)("GL_MAX_TEXTURE_IMAGE_UNITS=" + textureUnits[0]));
        int n = Math.min(texIds.length, textureUnits[0]);
        for (int i = 0; i < n; ++i) {
            texIds[i] = GLHelper.initTex(texTarget, ShaderConst.TEX_NUMBERS[i], minFilter, magFilter, wrap);
        }
        return texIds;
    }

    public static int[] initTexes(int n, int texTarget, int texUnit, int minFilter, int magFilter, int wrap) {
        return GLHelper.initTexes(new int[n], texTarget, texUnit, minFilter, magFilter, wrap);
    }

    public static int[] initTexes(@NonNull int[] texIds, int texTarget, int texUnit, int filterParam) {
        return GLHelper.initTexes(texIds, texTarget, texUnit, filterParam, filterParam, 33071);
    }

    public static int[] initTexes(@NonNull int[] texIds, int texTarget, int texUnit, int minFilter, int magFilter, int wrap) {
        int[] textureUnits = new int[1];
        GLES20.glGetIntegerv((int)34930, (int[])textureUnits, (int)0);
        int n = Math.min(texIds.length, textureUnits[0]);
        for (int i = 0; i < n; ++i) {
            texIds[i] = GLHelper.initTex(texTarget, texUnit, minFilter, magFilter, wrap);
        }
        return texIds;
    }

    public static void deleteTex(int hTex) {
        int[] tex = new int[]{hTex};
        GLES20.glDeleteTextures((int)1, (int[])tex, (int)0);
    }

    public static void deleteTex(@NonNull int[] tex) {
        GLES20.glDeleteTextures((int)tex.length, (int[])tex, (int)0);
    }

    public static int loadTextureFromResource(Context context, int resId) {
        return GLHelper.loadTextureFromResource(context, resId, null);
    }

    @SuppressLint(value={"NewApi"})
    public static int loadTextureFromResource(Context context, int resId, Resources.Theme theme) {
        Bitmap bitmap = Bitmap.createBitmap((int)256, (int)256, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawARGB(0, 0, 255, 0);
        Drawable background = ResourcesCompat.getDrawable((Resources)context.getResources(), (int)resId, (Resources.Theme)theme);
        background.setBounds(0, 0, 256, 256);
        background.draw(canvas);
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        GLES20.glBindTexture((int)3553, (int)textures[0]);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10242, (float)10497.0f);
        GLES20.glTexParameterf((int)3553, (int)10243, (float)10497.0f);
        GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
        bitmap.recycle();
        return textures[0];
    }

    public static int createTextureWithTextContent(@NonNull String text) {
        return GLHelper.createTextureWithTextContent(text, 33984);
    }

    public static int createTextureWithTextContent(@NonNull String text, int texUnit) {
        Bitmap bitmap = Bitmap.createBitmap((int)256, (int)256, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawARGB(0, 0, 255, 0);
        Paint textPaint = new Paint();
        textPaint.setTextSize(32.0f);
        textPaint.setAntiAlias(true);
        textPaint.setARGB(255, 255, 255, 255);
        canvas.drawText(text, 16.0f, 112.0f, textPaint);
        int texture = GLHelper.initTex(3553, texUnit, 9728, 9729, 10497);
        GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
        bitmap.recycle();
        return texture;
    }

    public static int loadShader(@NonNull Context context, String vss_asset, String fss_asset) {
        int program;
        try {
            String vss = AssetsHelper.loadString(context.getAssets(), vss_asset);
            String fss = AssetsHelper.loadString(context.getAssets(), vss_asset);
            program = GLHelper.loadShader(vss, fss);
        }
        catch (IOException e) {
            program = 0;
        }
        return program;
    }

    public static int loadShader(String vss, String fss) {
        int[] compiled = new int[1];
        int vs = GLHelper.loadShader(35633, vss);
        if (vs == 0) {
            Log.d((String)TAG, (String)("loadShader:failed to compile vertex shader,\n" + vss));
            return 0;
        }
        int fs = GLHelper.loadShader(35632, fss);
        if (fs == 0) {
            Log.d((String)TAG, (String)("loadShader:failed to compile fragment shader,\n" + fss));
            return 0;
        }
        int program = GLES20.glCreateProgram();
        GLHelper.checkGlError("glCreateProgram");
        if (program == 0) {
            Log.e((String)TAG, (String)"Could not create program");
        }
        GLES20.glAttachShader((int)program, (int)vs);
        GLHelper.checkGlError("glAttachShader");
        GLES20.glAttachShader((int)program, (int)fs);
        GLHelper.checkGlError("glAttachShader");
        GLES20.glLinkProgram((int)program);
        int[] linkStatus = new int[1];
        GLES20.glGetProgramiv((int)program, (int)35714, (int[])linkStatus, (int)0);
        if (linkStatus[0] != 1) {
            Log.e((String)TAG, (String)"Could not link program: ");
            Log.e((String)TAG, (String)GLES20.glGetProgramInfoLog((int)program));
            GLES20.glDeleteProgram((int)program);
            return 0;
        }
        return program;
    }

    public static int loadShader(int shaderType, String source) {
        int shader = GLES20.glCreateShader((int)shaderType);
        GLHelper.checkGlError("glCreateShader type=" + shaderType);
        GLES20.glShaderSource((int)shader, (String)source);
        GLES20.glCompileShader((int)shader);
        int[] compiled = new int[1];
        GLES20.glGetShaderiv((int)shader, (int)35713, (int[])compiled, (int)0);
        if (compiled[0] == 0) {
            Log.e((String)TAG, (String)("Could not compile shader " + shaderType + ":"));
            Log.e((String)TAG, (String)(" " + GLES20.glGetShaderInfoLog((int)shader)));
            GLES20.glDeleteShader((int)shader);
            shader = 0;
        }
        return shader;
    }

    public static void checkLocation(int location, String label) {
        if (location < 0) {
            throw new RuntimeException("Unable to locate '" + label + "' in program");
        }
    }

    public static int createBuffer(int target, @NonNull FloatBuffer data, int usage) {
        int[] ids = new int[1];
        GLES20.glGenBuffers((int)1, (int[])ids, (int)0);
        GLHelper.checkGlError("glGenBuffers");
        GLES20.glBindBuffer((int)target, (int)ids[0]);
        GLHelper.checkGlError("glBindBuffer");
        GLES20.glBufferData((int)target, (int)(4 * data.limit()), (Buffer)data, (int)usage);
        GLHelper.checkGlError("glBufferData");
        GLES20.glBindBuffer((int)target, (int)0);
        return ids[0];
    }

    public static void deleteBuffer(int bufId) {
        GLHelper.deleteBuffer(new int[]{bufId});
    }

    public static void deleteBuffer(@NonNull int[] bufIds) {
        GLES20.glDeleteBuffers((int)bufIds.length, (int[])bufIds, (int)0);
    }
}

