/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.egl;

import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.serenegiant.egl.EGLBase;
import com.serenegiant.gl.GLContext;
import com.serenegiant.gl.GLUtils;
import com.serenegiant.utils.MessageTask;

public abstract class EglTask
extends MessageTask {
    private static final boolean DEBUG = false;
    private static final String TAG = EglTask.class.getSimpleName();
    private final int mMasterWidth;
    private final int mMasterHeight;
    @NonNull
    private final GLContext mGLContext;

    public EglTask(@Nullable EGLBase.IContext<?> sharedContext, int flags) {
        this(GLUtils.getSupportedGLVersion(), sharedContext, flags);
    }

    public EglTask(int maxClientVersion, @Nullable EGLBase.IContext<?> sharedContext, int flags) {
        this(maxClientVersion, sharedContext, flags, 1, 1);
    }

    public EglTask(int maxClientVersion, @Nullable EGLBase.IContext<?> sharedContext, int flags, int masterWidth, int masterHeight) {
        this(new GLContext(maxClientVersion, sharedContext, flags), masterWidth, masterHeight);
    }

    public EglTask(@NonNull GLContext glContext, int masterWidth, int masterHeight) {
        this.mGLContext = glContext;
        this.mMasterWidth = Math.max(masterWidth, 1);
        this.mMasterHeight = Math.max(masterHeight, 1);
        this.init(0, 0, null);
    }

    @Override
    @WorkerThread
    @CallSuper
    protected void onInit(int flags, int maxClientVersion, Object sharedContext) {
        this.mGLContext.initialize(null, this.mMasterWidth, this.mMasterHeight);
    }

    @Override
    protected MessageTask.Request takeRequest() throws InterruptedException {
        MessageTask.Request result = super.takeRequest();
        this.mGLContext.makeDefault();
        return result;
    }

    @Override
    @WorkerThread
    protected void onBeforeStop() {
        this.mGLContext.makeDefault();
    }

    @Override
    @WorkerThread
    protected void onRelease() {
        this.mGLContext.release();
    }

    @NonNull
    public GLContext getGLContext() {
        return this.mGLContext;
    }

    @NonNull
    public EGLBase getEgl() {
        return this.mGLContext.getEgl();
    }

    @NonNull
    public EGLBase.IConfig<?> getConfig() {
        return this.mGLContext.getConfig();
    }

    @NonNull
    public EGLBase.IContext<?> getContext() {
        return this.mGLContext.getContext();
    }

    public void makeCurrent() {
        this.mGLContext.makeDefault();
    }

    public void swap() {
        this.mGLContext.swap();
    }

    public int getGlVersion() {
        return this.mGLContext.getGlVersion();
    }

    public boolean isGLES3() {
        return this.mGLContext.isGLES3();
    }

    public boolean hasExtension(@NonNull String extension) {
        return this.mGLContext.hasExtension(extension);
    }

    public boolean isOES3Supported() {
        return this.mGLContext.isOES3Supported();
    }
}

