/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.egl;

import android.annotation.TargetApi;
import android.opengl.GLES10;
import android.opengl.GLES20;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.egl.EGLBase;
import com.serenegiant.gl.GLUtils;
import com.serenegiant.gl.WrappedSurfaceHolder;
import com.serenegiant.system.BuildCheck;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

class EGLBase10
extends EGLBase {
    private static final boolean DEBUG = false;
    private static final String TAG = EGLBase10.class.getSimpleName();
    @NonNull
    private static final Context EGL_NO_CONTEXT = EGLBase10.wrap(EGL10.EGL_NO_CONTEXT);
    @NonNull
    private Context mContext = EGL_NO_CONTEXT;
    @Nullable
    private EGL10 mEgl = null;
    @NonNull
    private EGLDisplay mEglDisplay = EGL10.EGL_NO_DISPLAY;
    @Nullable
    private Config mEglConfig = null;
    private int mGlVersion = 2;

    static Context wrap(@NonNull EGLContext context) {
        return new Context(context);
    }

    static Config wrap(@NonNull EGLConfig eglConfig) {
        return new Config(eglConfig);
    }

    static EGLBase createFromCurrentImpl(int maxClientVersion, boolean withDepthBuffer, int stencilBits, boolean isRecordable) {
        Context context = null;
        EGL10 egl10 = (EGL10)EGLContext.getEGL();
        EGLContext currentContext = egl10.eglGetCurrentContext();
        EGLSurface currentSurface = egl10.eglGetCurrentSurface(12377);
        if (currentContext != null && currentSurface != null) {
            context = EGLBase10.wrap(currentContext);
        }
        return new EGLBase10(maxClientVersion, context, withDepthBuffer, stencilBits, isRecordable);
    }

    static boolean hasGLThreadImpl() {
        EGL10 egl10 = (EGL10)EGLContext.getEGL();
        EGLContext currentContext = egl10.eglGetCurrentContext();
        EGLSurface currentSurface = egl10.eglGetCurrentSurface(12377);
        return currentContext != null && currentSurface != null;
    }

    @Nullable
    static EGLBase.IContext<?> wrapCurrentContextImpl() {
        EGL10 egl10 = (EGL10)EGLContext.getEGL();
        EGLContext currentContext = egl10.eglGetCurrentContext();
        EGLSurface currentSurface = egl10.eglGetCurrentSurface(12377);
        if (currentContext != null && currentSurface != null) {
            return EGLBase10.wrapContext(currentContext);
        }
        return null;
    }

    EGLBase10(int maxClientVersion, @Nullable Context sharedContext, boolean withDepthBuffer, int stencilBits, boolean isRecordable) throws IllegalArgumentException {
        this.init(maxClientVersion, sharedContext, withDepthBuffer, stencilBits, isRecordable);
    }

    EGLBase10(int maxClientVersion, boolean withDepthBuffer, int stencilBits, boolean isRecordable) throws IllegalArgumentException {
        this.init(maxClientVersion, EGLBase10.wrap(((EGL10)EGLContext.getEGL()).eglGetCurrentContext()), withDepthBuffer, stencilBits, isRecordable);
    }

    @Override
    public void release() {
        this.destroyContext();
        this.mContext = EGL_NO_CONTEXT;
        if (this.mEgl == null) {
            return;
        }
        this.mEgl.eglMakeCurrent(this.mEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
        this.mEgl.eglTerminate(this.mEglDisplay);
        this.mEglDisplay = EGL10.EGL_NO_DISPLAY;
        this.mEglConfig = null;
        this.mEgl = null;
    }

    @Override
    public EGLBase.IEglSurface createFromSurface(Object nativeWindow) {
        EglSurface result = new EglSurface(this, nativeWindow);
        result.makeCurrent();
        return result;
    }

    @Override
    public EGLBase.IEglSurface createOffscreen(int width, int height) {
        EglSurface result = new EglSurface(this, width, height);
        result.makeCurrent();
        return result;
    }

    @Override
    public EGLBase.IEglSurface wrapCurrent() {
        EglSurface result = new EglSurface(this);
        result.makeCurrent();
        return result;
    }

    @Override
    public boolean isValidContext() {
        return this.mContext.eglContext != EGL10.EGL_NO_CONTEXT;
    }

    @NonNull
    public Context getContext() throws IllegalStateException {
        if (!this.isValidContext()) {
            throw new IllegalStateException();
        }
        return this.mContext;
    }

    @NonNull
    public Config getConfig() throws IllegalStateException {
        if (!this.isValidContext()) {
            throw new IllegalStateException();
        }
        return this.mEglConfig;
    }

    @Override
    public void makeDefault() {
        if (!this.mEgl.eglMakeCurrent(this.mEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT)) {
            Log.w((String)TAG, (String)("makeDefault:eglMakeCurrent:err=" + this.mEgl.eglGetError()));
        }
    }

    @Override
    public void sync() {
        this.mEgl.eglWaitGL();
        this.mEgl.eglWaitNative(12379, null);
    }

    @Override
    public void waitGL() {
        this.mEgl.eglWaitGL();
    }

    @Override
    public void waitNative() {
        this.mEgl.eglWaitNative(12379, null);
    }

    @Override
    public String queryString(int what) {
        return this.mEgl.eglQueryString(this.mEglDisplay, what);
    }

    @Override
    public int getGlVersion() {
        return this.mGlVersion;
    }

    private final void init(int maxClientVersion, @Nullable Context sharedContext, boolean withDepthBuffer, int stencilBits, boolean isRecordable) throws IllegalArgumentException {
        EGLContext context;
        EGLConfig config;
        Context context2 = sharedContext = sharedContext != null ? sharedContext : EGL_NO_CONTEXT;
        if (this.mEgl == null) {
            this.mEgl = (EGL10)EGLContext.getEGL();
            this.mEglDisplay = this.mEgl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
            if (this.mEglDisplay == EGL10.EGL_NO_DISPLAY) {
                throw new IllegalArgumentException("eglGetDisplay failed");
            }
            int[] version = new int[2];
            if (!this.mEgl.eglInitialize(this.mEglDisplay, version)) {
                this.mEglDisplay = EGL10.EGL_NO_DISPLAY;
                throw new IllegalArgumentException("eglInitialize failed");
            }
        }
        if (maxClientVersion >= 3 && (config = this.getConfig(3, withDepthBuffer, stencilBits, isRecordable)) != null) {
            context = this.createContext(sharedContext, config, 3);
            if (this.mEgl.eglGetError() == 12288) {
                this.mEglConfig = EGLBase10.wrap(config);
                this.mContext = EGLBase10.wrap(context);
                this.mGlVersion = 3;
            }
        }
        if (maxClientVersion >= 2 && !this.isValidContext()) {
            config = this.getConfig(2, withDepthBuffer, stencilBits, isRecordable);
            if (config == null) {
                throw new IllegalArgumentException("chooseConfig failed");
            }
            try {
                context = this.createContext(sharedContext, config, 2);
                this.checkEglError("eglCreateContext");
                this.mEglConfig = EGLBase10.wrap(config);
                this.mContext = EGLBase10.wrap(context);
                this.mGlVersion = 2;
            }
            catch (Exception e) {
                if (isRecordable) {
                    config = this.getConfig(2, withDepthBuffer, stencilBits, false);
                    if (config == null) {
                        throw new IllegalArgumentException("chooseConfig failed");
                    }
                    EGLContext context3 = this.createContext(sharedContext, config, 2);
                    this.checkEglError("eglCreateContext");
                    this.mEglConfig = EGLBase10.wrap(config);
                    this.mContext = EGLBase10.wrap(context3);
                    this.mGlVersion = 2;
                }
                throw e;
            }
        }
        if (!this.isValidContext()) {
            config = this.getConfig(1, withDepthBuffer, stencilBits, isRecordable);
            if (config == null) {
                throw new IllegalArgumentException("chooseConfig failed");
            }
            context = this.createContext(sharedContext, config, 1);
            this.checkEglError("eglCreateContext");
            this.mEglConfig = EGLBase10.wrap(config);
            this.mContext = EGLBase10.wrap(context);
            this.mGlVersion = 1;
        }
        int[] values = new int[1];
        this.mEgl.eglQueryContext(this.mEglDisplay, (EGLContext)this.mContext.eglContext, 12440, values);
        if (this.mEgl.eglGetError() == 12288) {
            Log.d((String)TAG, (String)String.format("EGLContext created, client version %d(request %d) ", values[0], maxClientVersion));
        }
        this.makeDefault();
    }

    private final boolean makeCurrent(EGLSurface surface) {
        if (surface == null || surface == EGL10.EGL_NO_SURFACE) {
            int error = this.mEgl.eglGetError();
            if (error == 12299) {
                Log.e((String)TAG, (String)"makeCurrent:EGL_BAD_NATIVE_WINDOW");
            }
            return false;
        }
        if (!this.mEgl.eglMakeCurrent(this.mEglDisplay, surface, surface, (EGLContext)this.mContext.eglContext)) {
            Log.w((String)TAG, (String)("eglMakeCurrent" + this.mEgl.eglGetError()));
            return false;
        }
        return true;
    }

    private final int swap(EGLSurface surface) {
        if (!this.mEgl.eglSwapBuffers(this.mEglDisplay, surface)) {
            int err = this.mEgl.eglGetError();
            return err;
        }
        return 12288;
    }

    private final int swap(EGLSurface surface, long ignored) {
        if (!this.mEgl.eglSwapBuffers(this.mEglDisplay, surface)) {
            int err = this.mEgl.eglGetError();
            return err;
        }
        return 12288;
    }

    private final EGLContext createContext(@NonNull Context sharedContext, EGLConfig config, int version) {
        int[] attrib_list = new int[]{12440, version, 12344};
        EGLContext context = this.mEgl.eglCreateContext(this.mEglDisplay, config, (EGLContext)sharedContext.eglContext, attrib_list);
        return context;
    }

    private final void destroyContext() {
        EGLContext ctx = (EGLContext)this.mContext.eglContext;
        this.mContext = EGL_NO_CONTEXT;
        if (ctx != EGL10.EGL_NO_CONTEXT && !this.mEgl.eglDestroyContext(this.mEglDisplay, ctx)) {
            Log.e((String)"destroyContext", (String)("display:" + this.mEglDisplay + " context: " + ctx));
            Log.e((String)TAG, (String)("eglDestroyContext:" + this.mEgl.eglGetError()));
        }
    }

    private final int getSurfaceWidth(EGLSurface surface) {
        int[] value = new int[1];
        boolean ret = this.mEgl.eglQuerySurface(this.mEglDisplay, surface, 12375, value);
        if (!ret) {
            value[0] = 0;
        }
        return value[0];
    }

    private final int getSurfaceHeight(EGLSurface surface) {
        int[] value = new int[1];
        boolean ret = this.mEgl.eglQuerySurface(this.mEglDisplay, surface, 12374, value);
        if (!ret) {
            value[0] = 0;
        }
        return value[0];
    }

    @NonNull
    private final EGLSurface createWindowSurface(Object nativeWindow) throws IllegalArgumentException {
        EGLSurface result;
        int[] surfaceAttribs = new int[]{12344};
        try {
            result = this.mEgl.eglCreateWindowSurface(this.mEglDisplay, (EGLConfig)this.mEglConfig.eglConfig, nativeWindow, surfaceAttribs);
            if (result == null || result == EGL10.EGL_NO_SURFACE) {
                int error = this.mEgl.eglGetError();
                if (error == 12299) {
                    Log.e((String)TAG, (String)"createWindowSurface returned EGL_BAD_NATIVE_WINDOW.");
                }
                throw new RuntimeException("createWindowSurface failed error=" + error);
            }
            this.makeCurrent(result);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"eglCreateWindowSurface", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        return result;
    }

    @NonNull
    private final EGLSurface createOffscreenSurface(@IntRange(from=1L) int width, @IntRange(from=1L) int height) throws IllegalArgumentException {
        EGLSurface result;
        int[] surfaceAttribs = new int[]{12375, width, 12374, height, 12344};
        this.mEgl.eglWaitGL();
        try {
            result = this.mEgl.eglCreatePbufferSurface(this.mEglDisplay, (EGLConfig)this.mEglConfig.eglConfig, surfaceAttribs);
            this.checkEglError("eglCreatePbufferSurface");
            if (result == null || result == EGL10.EGL_NO_SURFACE) {
                int error = this.mEgl.eglGetError();
                throw new RuntimeException("createOffscreenSurface failed error=" + error);
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)"createOffscreenSurface", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        return result;
    }

    private final void destroySurface(EGLSurface surface) {
        if (surface != EGL10.EGL_NO_SURFACE) {
            this.mEgl.eglMakeCurrent(this.mEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
            this.mEgl.eglDestroySurface(this.mEglDisplay, surface);
        }
    }

    private final void checkEglError(String msg) {
        int error = this.mEgl.eglGetError();
        if (error != 12288) {
            throw new RuntimeException(msg + ": EGL error: 0x" + Integer.toHexString(error));
        }
    }

    private final EGLConfig getConfig(int version, boolean hasDepthBuffer, int stencilBits, boolean isRecordable) {
        int renderableType = 4;
        if (version >= 3) {
            renderableType |= 0x40;
        }
        int[] attribList = new int[]{12352, renderableType, 12324, 8, 12323, 8, 12322, 8, 12321, 8, 12344, 12344, 12344, 12344, 12344, 12344, 12344};
        int offset = 10;
        if (stencilBits > 0) {
            attribList[offset++] = 12326;
            attribList[offset++] = 8;
        }
        if (hasDepthBuffer) {
            attribList[offset++] = 12325;
            attribList[offset++] = 16;
        }
        if (isRecordable && BuildCheck.isAndroid4_3()) {
            attribList[offset++] = 12610;
            attribList[offset++] = 1;
        }
        for (int i = attribList.length - 1; i >= offset; --i) {
            attribList[i] = 12344;
        }
        EGLConfig config = this.internalGetConfig(attribList);
        if (config == null && version == 2 && isRecordable) {
            int n = attribList.length;
            for (int i = 10; i < n - 1; i += 2) {
                if (attribList[i] != 12610) continue;
                for (int j = i; j < n; ++j) {
                    attribList[j] = 12344;
                }
                break;
            }
            config = this.internalGetConfig(attribList);
        }
        if (config == null) {
            Log.w((String)TAG, (String)"try to fallback to RGB565");
            attribList[3] = 5;
            attribList[5] = 6;
            attribList[7] = 5;
            attribList[9] = 0;
            config = this.internalGetConfig(attribList);
        }
        return config;
    }

    private EGLConfig internalGetConfig(int[] attribList) {
        EGLConfig[] configs = new EGLConfig[1];
        int[] numConfigs = new int[1];
        if (!this.mEgl.eglChooseConfig(this.mEglDisplay, attribList, configs, configs.length, numConfigs)) {
            return null;
        }
        return configs[0];
    }

    private static class EglSurface
    implements EGLBase.IEglSurface {
        @NonNull
        private final EGLBase10 mEglBase;
        private final int mGLVersion;
        private final boolean mOwnSurface;
        @NonNull
        private EGLSurface mEglSurface;
        private int viewPortX;
        private int viewPortY;
        private int viewPortWidth;
        private int viewPortHeight;

        private EglSurface(@NonNull EGLBase10 eglBase, Object surface) throws IllegalArgumentException {
            this.mEglBase = eglBase;
            this.mGLVersion = eglBase.getGlVersion();
            Object _surface = surface instanceof Surface && !BuildCheck.isAndroid4_2() ? new WrappedSurfaceHolder((Surface)surface) : surface;
            if (!GLUtils.isSupportedSurface(_surface)) {
                throw new IllegalArgumentException("unsupported surface");
            }
            this.mEglSurface = this.mEglBase.createWindowSurface(_surface);
            this.mOwnSurface = true;
            this.setViewPort(0, 0, this.getWidth(), this.getHeight());
        }

        private EglSurface(@NonNull EGLBase10 eglBase, int width, int height) {
            this.mEglBase = eglBase;
            this.mGLVersion = eglBase.getGlVersion();
            this.mEglSurface = width <= 0 || height <= 0 ? this.mEglBase.createOffscreenSurface(1, 1) : this.mEglBase.createOffscreenSurface(width, height);
            this.mOwnSurface = true;
            this.setViewPort(0, 0, this.getWidth(), this.getHeight());
        }

        private EglSurface(@NonNull EGLBase10 eglBase) {
            this(eglBase, 12377);
        }

        private EglSurface(@NonNull EGLBase10 eglBase, int readDraw) {
            this.mEglBase = eglBase;
            this.mGLVersion = eglBase.getGlVersion();
            this.mEglSurface = eglBase.mEgl.eglGetCurrentSurface(readDraw);
            this.mOwnSurface = false;
            this.setViewPort(0, 0, this.getWidth(), this.getHeight());
        }

        @Override
        public void release() {
            this.mEglBase.makeDefault();
            if (this.mOwnSurface) {
                this.mEglBase.destroySurface(this.mEglSurface);
            }
            this.mEglSurface = EGL10.EGL_NO_SURFACE;
        }

        @Override
        public boolean isValid() {
            return this.mEglSurface != EGL10.EGL_NO_SURFACE && this.mEglBase.getSurfaceWidth(this.mEglSurface) > 0 && this.mEglBase.getSurfaceHeight(this.mEglSurface) > 0;
        }

        @Override
        public int getWidth() {
            return this.mEglBase.getSurfaceWidth(this.mEglSurface);
        }

        @Override
        public int getHeight() {
            return this.mEglBase.getSurfaceHeight(this.mEglSurface);
        }

        @Override
        public void makeCurrent() {
            this.mEglBase.makeCurrent(this.mEglSurface);
            this.setViewPort(this.viewPortX, this.viewPortY, this.viewPortWidth, this.viewPortHeight);
        }

        @Override
        public void setViewPort(int x, int y, int width, int height) {
            this.viewPortX = x;
            this.viewPortY = y;
            this.viewPortWidth = width;
            this.viewPortHeight = height;
            if (this.mGLVersion >= 2) {
                GLES20.glViewport((int)x, (int)y, (int)width, (int)height);
            } else {
                GLES10.glViewport((int)x, (int)y, (int)width, (int)height);
            }
        }

        @Override
        public void swap() {
            this.mEglBase.swap(this.mEglSurface);
        }

        @Override
        @TargetApi(value=18)
        public void swap(long presentationTimeNs) {
            this.mEglBase.swap(this.mEglSurface, presentationTimeNs);
        }

        @TargetApi(value=18)
        public void setPresentationTime(long presentationTimeNs) {
        }

        @NonNull
        public String toString() {
            return "EglSurface{mEglBase=" + this.mEglBase + ", mEglSurface=" + this.mEglSurface + ", mOwnSurface=" + this.mOwnSurface + ", viewPortX=" + this.viewPortX + ", viewPortY=" + this.viewPortY + ", viewPortWidth=" + this.viewPortWidth + ", viewPortHeight=" + this.viewPortHeight + '}';
        }
    }

    static class Config
    extends EGLBase.IConfig<EGLConfig> {
        private Config(@NonNull EGLConfig eglConfig) {
            super(eglConfig);
        }
    }

    static class Context
    extends EGLBase.IContext<EGLContext> {
        private Context(EGLContext context) {
            super(context);
        }

        @Override
        public long getNativeHandle() {
            return 0L;
        }
    }
}

