/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.dialog;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.serenegiant.dialog.DialogFragmentEx;
import com.serenegiant.system.BuildCheck;

public class ConfirmDialogV4
extends DialogFragmentEx {
    private static final String TAG = ConfirmDialogV4.class.getSimpleName();
    private static final String ARGS_KEY_CANCELED_ON_TOUCH_OUTSIDE = "ARGS_KEY_CANCELED_ON_TOUCH_OUTSIDE";
    private static final String ARGS_KEY_MESSAGE_STRING = "ARGS_KEY_MESSAGE_STRING";
    private static final String ARGS_KEY_ARGS = "ARGS_KEY_ARGS";
    private ConfirmDialogListener mListener;
    private final DialogInterface.OnClickListener mOnClickListener = new DialogInterface.OnClickListener(){

        public void onClick(DialogInterface dialog, int which) {
            ConfirmDialogV4.this.callOnMessageDialogResult(which);
        }
    };

    public static ConfirmDialogV4 showDialog(@NonNull FragmentActivity parent, int requestCode, @StringRes int id_title, @StringRes int id_message, boolean canceledOnTouchOutside) throws IllegalStateException {
        return ConfirmDialogV4.showDialog(parent, requestCode, id_title, id_message, canceledOnTouchOutside, null);
    }

    public static ConfirmDialogV4 showDialog(@NonNull FragmentActivity parent, int requestCode, @StringRes int id_title, @StringRes int id_message, boolean canceledOnTouchOutside, @Nullable Bundle userArgs) throws IllegalStateException {
        ConfirmDialogV4 dialog = ConfirmDialogV4.newInstance(requestCode, id_title, id_message, null, canceledOnTouchOutside, userArgs);
        dialog.show(parent.getSupportFragmentManager(), TAG);
        return dialog;
    }

    public static ConfirmDialogV4 showDialog(@NonNull FragmentActivity parent, int requestCode, @StringRes int id_title, @NonNull CharSequence message, boolean canceledOnTouchOutside) throws IllegalStateException {
        return ConfirmDialogV4.showDialog(parent, requestCode, id_title, message, canceledOnTouchOutside, null);
    }

    public static ConfirmDialogV4 showDialog(@NonNull FragmentActivity parent, int requestCode, @StringRes int id_title, @NonNull CharSequence message, boolean canceledOnTouchOutside, @Nullable Bundle userArgs) throws IllegalStateException {
        ConfirmDialogV4 dialog = ConfirmDialogV4.newInstance(requestCode, id_title, 0, message, canceledOnTouchOutside, userArgs);
        dialog.show(parent.getSupportFragmentManager(), TAG);
        return dialog;
    }

    public static ConfirmDialogV4 showDialog(@NonNull Fragment parent, int requestCode, @StringRes int id_title, @StringRes int id_message, boolean canceledOnTouchOutside) throws IllegalStateException {
        return ConfirmDialogV4.showDialog(parent, requestCode, id_title, id_message, canceledOnTouchOutside, null);
    }

    public static ConfirmDialogV4 showDialog(@NonNull Fragment parent, int requestCode, @StringRes int id_title, @StringRes int id_message, boolean canceledOnTouchOutside, @Nullable Bundle userArgs) throws IllegalStateException {
        ConfirmDialogV4 dialog = ConfirmDialogV4.newInstance(requestCode, id_title, id_message, null, canceledOnTouchOutside, userArgs);
        dialog.setTargetFragment(parent, parent.getId());
        dialog.show(parent.getParentFragmentManager(), TAG);
        return dialog;
    }

    public static ConfirmDialogV4 showDialog(@NonNull Fragment parent, int requestCode, @StringRes int id_title, @NonNull CharSequence message, boolean canceledOnTouchOutside) throws IllegalStateException {
        return ConfirmDialogV4.showDialog(parent, requestCode, id_title, message, canceledOnTouchOutside, null);
    }

    public static ConfirmDialogV4 showDialog(@NonNull Fragment parent, int requestCode, @StringRes int id_title, @NonNull CharSequence message, boolean canceledOnTouchOutside, @Nullable Bundle userArgs) throws IllegalStateException {
        ConfirmDialogV4 dialog = ConfirmDialogV4.newInstance(requestCode, id_title, 0, message, canceledOnTouchOutside, userArgs);
        dialog.setTargetFragment(parent, parent.getId());
        dialog.show(parent.getParentFragmentManager(), TAG);
        return dialog;
    }

    public static ConfirmDialogV4 newInstance(int requestCode, @StringRes int id_title, @StringRes int id_message, @Nullable CharSequence message, boolean canceledOnTouchOutside, @Nullable Bundle userArgs) {
        ConfirmDialogV4 fragment = new ConfirmDialogV4();
        Bundle args = new Bundle();
        args.putInt("requestCode", requestCode);
        args.putInt("title", id_title);
        args.putInt("message", id_message);
        args.putCharSequence(ARGS_KEY_MESSAGE_STRING, message);
        args.putBoolean(ARGS_KEY_CANCELED_ON_TOUCH_OUTSIDE, canceledOnTouchOutside);
        args.putBundle(ARGS_KEY_ARGS, userArgs);
        fragment.setArguments(args);
        return fragment;
    }

    public void onAttach(@NonNull Context context) {
        Fragment target;
        Fragment fragment;
        super.onAttach(context);
        if (context instanceof ConfirmDialogListener) {
            this.mListener = (ConfirmDialogListener)context;
        }
        if (this.mListener == null && (fragment = this.getTargetFragment()) instanceof ConfirmDialogListener) {
            this.mListener = (ConfirmDialogListener)fragment;
        }
        if (this.mListener == null && BuildCheck.isAndroid4_2() && (target = this.getParentFragment()) instanceof ConfirmDialogListener) {
            this.mListener = (ConfirmDialogListener)target;
        }
        if (this.mListener == null) {
            throw new ClassCastException(context.toString());
        }
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Bundle args = savedInstanceState != null ? savedInstanceState : this.requireArguments();
        int id_title = args.getInt("title");
        int id_message = args.getInt("message");
        CharSequence message = args.getCharSequence(ARGS_KEY_MESSAGE_STRING);
        boolean canceledOnTouchOutside = args.getBoolean(ARGS_KEY_CANCELED_ON_TOUCH_OUTSIDE);
        AlertDialog.Builder builder = new AlertDialog.Builder(this.requireContext(), this.getTheme()).setIcon(17301543).setTitle(id_title).setPositiveButton(17039370, this.mOnClickListener).setNegativeButton(0x1040000, this.mOnClickListener);
        if (id_message != 0) {
            builder.setMessage(id_message);
        } else {
            builder.setMessage(message);
        }
        AlertDialog dialog = builder.create();
        dialog.setCanceledOnTouchOutside(canceledOnTouchOutside);
        return dialog;
    }

    public void onCancel(@NonNull DialogInterface dialog) {
        super.onCancel(dialog);
        this.callOnMessageDialogResult(-2);
    }

    private void callOnMessageDialogResult(int result) throws IllegalStateException {
        Bundle args = this.requireArguments();
        Bundle userArgs = args.getBundle(ARGS_KEY_ARGS);
        int requestCode = args.getInt("requestCode");
        try {
            this.mListener.onConfirmResult(this, requestCode, result, userArgs);
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
        }
    }

    public static interface ConfirmDialogListener {
        public void onConfirmResult(@NonNull ConfirmDialogV4 var1, int var2, int var3, @Nullable Bundle var4);
    }
}

