/*
 * Decompiled with CFR 0.152.
 */
package com.tony.bluetoothunityapi;

import com.tony.bluetoothunityapi.BluetoothHelper;
import com.tony.bluetoothunityapi.BluetoothStreamManager;
import com.tony.bluetoothunityapi.CharArrayWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BluetoothOneCharStreamManager
extends BluetoothStreamManager {
    private List<Byte> messageBuffer = new ArrayList<Byte>();
    private byte terminator;
    private boolean appendTerminator;

    public BluetoothOneCharStreamManager(BluetoothHelper helper, String terminator, boolean appendTerminator) {
        super(helper);
        this.terminator = terminator == null || terminator.length() == 0 || terminator.charAt(0) == '\u0000' ? (byte)0 : (byte)terminator.charAt(0);
        this.appendTerminator = appendTerminator;
    }

    @Override
    public void OnMessageReceived(byte[] buff) {
        int i = 0;
        int j = 0;
        while ((i = this.getTerminatorCharIndex(buff, j)) >= 0) {
            this.messageBuffer.addAll(Arrays.asList(BluetoothOneCharStreamManager.toObject(Arrays.copyOfRange(buff, j, i))));
            this.helper.invokeDataReceivedEvent(new CharArrayWrapper(this.messageBuffer.toArray()));
            this.messageBuffer.clear();
            j = i + 1;
        }
        if (i == -2) {
            this.messageBuffer.addAll(Arrays.asList(BluetoothOneCharStreamManager.toObject(Arrays.copyOfRange(buff, j, buff.length))));
        }
    }

    @Override
    public void Listen() {
        this.transceiver.listen();
    }

    @Override
    public void sendData() {
        if (!this.appendTerminator) {
            this.transceiver.write(this.data_out);
        } else {
            byte[] buff = Arrays.copyOf(this.data_out, this.data_out.length + 1);
            buff[buff.length - 1] = this.terminator;
            this.transceiver.write(buff);
        }
    }

    private int getTerminatorCharIndex(byte[] array, int startIndex) {
        if (startIndex >= array.length) {
            return -1;
        }
        int i = startIndex;
        while (array[i] != this.terminator) {
            if (++i < array.length) continue;
            return -2;
        }
        return i;
    }
}

