/*
 * Decompiled with CFR 0.152.
 */
package arp.camera;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import android.util.Size;

public class PreferenceHelper {
    public static void writePreferenceForCameraId(Context context, String name, Size[] previewSizes, Integer[] formats, Size[][] pictureSizes) {
        SharedPreferences preferences = context.getSharedPreferences(name, 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putInt("formats", formats.length);
        for (int i = 0; i < formats.length; ++i) {
            editor.putInt("formats" + i, formats[i].intValue());
            if (pictureSizes[i] == null) {
                editor.putInt("formats" + i + "pictureSizes", 0);
                continue;
            }
            editor.putInt("formats" + formats[i] + "pictureSizes", pictureSizes[i].length);
            for (int j = 0; j < pictureSizes[i].length; ++j) {
                editor.putInt("formats" + formats[i] + "pictureSizes" + j + "_width", pictureSizes[i][j].getWidth());
                editor.putInt("formats" + formats[i] + "pictureSizes" + j + "_height", pictureSizes[i][j].getHeight());
            }
        }
        editor.commit();
        PreferenceHelper.writeCurrentPreferenceForCameraId(context, name, previewSizes, formats, pictureSizes);
    }

    public static String getCameraFormat(Context context) {
        String format;
        if (context != null) {
            SharedPreferences preferences = context.getSharedPreferences("CameraConfig", 0);
            format = preferences.getString("format", "JPEG");
        } else {
            format = "JPEG";
        }
        return format;
    }

    private static void writeCurrentPreferenceForCameraId(Context context, String name, Size[] previewSizes, Integer[] formats, Size[][] pictureSizes) {
        String currentName = "current" + name;
        SharedPreferences currentPreferences = context.getSharedPreferences(currentName, 0);
        SharedPreferences preferences = context.getSharedPreferences(name, 0);
        SharedPreferences.Editor editor = currentPreferences.edit();
        editor.putInt("previewSize_width", previewSizes[0].getWidth());
        editor.putInt("previewSize_height", previewSizes[0].getHeight());
        int formatsNum = preferences.getInt("formats", 0);
        for (int i = 0; i < formatsNum; ++i) {
            editor.putInt("format_" + formats[i] + "_pictureSize_width", pictureSizes[i][0].getWidth());
            editor.putInt("format_" + formats[i] + "_pictureSize_height", pictureSizes[i][0].getHeight());
        }
        editor.putInt("format", formats[0].intValue());
        editor.commit();
    }

    public static void writeCurrentCameraid(Context context, String cameraId) {
        SharedPreferences currentPreferences = context.getSharedPreferences("current", 0);
        SharedPreferences.Editor editor = currentPreferences.edit();
        editor.putString("cameraid", cameraId);
        editor.commit();
    }

    public static String getCurrentCameraid(Context context) {
        SharedPreferences currentPreferences = context.getSharedPreferences("current", 0);
        return currentPreferences.getString("cameraid", "0");
    }

    public static boolean checkFirstInit(Context context) {
        SharedPreferences preferences = context.getSharedPreferences("current", 0);
        int num = preferences.getInt("first_time", 0);
        return num == 1;
    }

    public static String[] getFormatsName(Context context, String cameraId) {
        SharedPreferences preferences = context.getSharedPreferences(cameraId, 0);
        int formatsNum = preferences.getInt("formats", 0);
        String[] formats = new String[formatsNum];
        for (int i = 0; i < formatsNum; ++i) {
            int format = preferences.getInt("formats" + i, 0);
            formats[i] = null != PreferenceHelper.getFormatName(format) ? PreferenceHelper.getFormatName(format) : "null";
        }
        return formats;
    }

    public static int[] getFormatsNumber(Context context, String cameraId) {
        SharedPreferences preferences = context.getSharedPreferences(cameraId, 0);
        int formatsNum = preferences.getInt("formats", 0);
        int[] formats = new int[formatsNum];
        for (int i = 0; i < formatsNum; ++i) {
            int format = preferences.getInt("formats" + i, 0);
            formats[i] = null != PreferenceHelper.getFormatName(format) ? format : -1;
        }
        return formats;
    }

    private static String getFormatName(int format) {
        String name = null;
        switch (format) {
            case 256: {
                name = "JPEG";
                break;
            }
            case 16: {
                name = "NV16";
                break;
            }
            case 17: {
                name = "NV21";
                break;
            }
            case 37: {
                name = "RAW10";
                break;
            }
            case 32: {
                name = "RAW_SENSOR";
                break;
            }
            case 4: {
                name = "RGB_565";
                break;
            }
            case 35: {
                name = "YUV_420_888";
                break;
            }
            case 20: {
                name = "YUY2";
                break;
            }
            case 842094169: {
                name = "YV12";
                break;
            }
            case 0: {
                name = null;
            }
        }
        return name;
    }

    public static String getFormatSize(Context context, String cameraId) {
        SharedPreferences sp = context.getSharedPreferences(cameraId, 0);
        SharedPreferences currentSp = context.getSharedPreferences("current" + cameraId, 0);
        Log.i((String)"getPreviewSize", (String)("cameraId--->" + cameraId));
        Log.i((String)"getPreviewSize", (String)("context--->" + context));
        int currentFormat = currentSp.getInt("format", 256);
        int sizeNum = sp.getInt("formats" + currentFormat + "pictureSizes", 0);
        String[] str = new String[sizeNum];
        String ret = "";
        for (int i = 0; i < sizeNum; ++i) {
            ret = ret + sp.getInt("formats" + currentFormat + "pictureSizes" + i + "_width", 0) + "," + sp.getInt("formats" + currentFormat + "pictureSizes" + i + "_height", 0) + ";";
        }
        Log.i((String)"getPreviewSize", (String)("ret--->" + ret));
        return ret;
    }

    public static String[] getPreviewSize(Context context, String cameraId) {
        SharedPreferences sp = context.getSharedPreferences(cameraId, 0);
        int previewNum = sp.getInt("previewSizes", 0);
        String[] str = new String[previewNum];
        for (int i = 0; i < previewNum; ++i) {
            str[i] = sp.getInt("previewSizes" + i + "_width", 0) + "*" + sp.getInt("previewSizes" + i + "_height", 0);
        }
        return str;
    }
}

