/*
 * Decompiled with CFR 0.152.
 */
package arp.camera;

import android.content.Intent;
import android.media.Image;
import android.media.ImageReader;
import android.net.Uri;
import android.os.Environment;
import android.util.Log;
import arp.camera.CameraPluginActivity;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Random;

public class JpegReaderListener
implements ImageReader.OnImageAvailableListener {
    public void onImageAvailable(ImageReader reader) {
        new Thread(new ImageSaver(reader)).start();
    }

    private File createJpeg() {
        long time = System.currentTimeMillis();
        int random = new Random().nextInt(1000);
        File dir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM);
        Log.i((String)"JpegSaver", (String)(dir.getPath() + time + "_" + random + ".jpg"));
        return new File(dir, time + "_" + random + ".jpg");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(byte[] bytes, File file) throws IOException {
        Log.i((String)"JpegSaver", (String)"save");
        try (FileOutputStream os = null;){
            os = new FileOutputStream(file);
            ((OutputStream)os).write(bytes);
        }
    }

    class ImageSaver
    implements Runnable {
        private ImageReader mImageReader;

        ImageSaver(ImageReader mImageReader) {
            this.mImageReader = mImageReader;
        }

        @Override
        public void run() {
            Image image = this.mImageReader.acquireLatestImage();
            File file = JpegReaderListener.this.createJpeg();
            try {
                ByteBuffer buffer = image.getPlanes()[0].getBuffer();
                byte[] bytes = new byte[buffer.remaining()];
                buffer.get(bytes);
                try {
                    JpegReaderListener.this.save(bytes, file);
                    Log.i((String)"JpegSaver", (String)("\u7167\u7247\u4fdd\u5b58\u6210\u529f\uff0c\u4f4d\u4e8e" + file.getPath()));
                    Intent intent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
                    Uri uri = Uri.fromFile((File)file);
                    intent.setData(uri);
                    CameraPluginActivity.context.sendBroadcast(intent);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                image.close();
            }
            catch (Exception e) {
                e.getStackTrace();
            }
        }
    }
}

