/*
 * Decompiled with CFR 0.152.
 */
package arp.camera;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.MeteringRectangle;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.ImageReader;
import android.media.MediaActionSound;
import android.opengl.GLES30;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.renderscript.RenderScript;
import android.util.Log;
import android.util.Range;
import android.util.Size;
import android.util.SparseIntArray;
import android.view.Surface;
import android.widget.Toast;
import arp.camera.JpegReaderListener;
import arp.camera.PreferenceHelper;
import arp.camera.PreviewSessionCallback;
import arp.camera.UsedThroughReflection;
import arp.camera.YuvToRgb;
import com.unity3d.player.UnityPlayerActivity;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;

public class CameraPluginActivity
extends UnityPlayerActivity {
    private static final String TAG = "CameraPluginActivity";
    private static final int STATE_PREVIEW = 1;
    private static final int STATE_CAPTURE = 2;
    private int mState = 0;
    public static final int FOCUS_DISAPPEAR = 100;
    public static final int WINDOW_TEXT_DISAPPEAR = 101;
    public static final int FOCUS_AGAIN = 102;
    private static final int SHOW_AF = 1;
    private static final int SHOW_AE = 2;
    private static final int SHOW_AWB = 3;
    private static final int SHOW_ISO = 4;
    private static final int SHOW_ZOOM = 5;
    private static final int SHOW_ZOOM_2 = 6;
    private static final SparseIntArray ORIENTATIONS = new SparseIntArray();
    private Size mPreviewSize;
    private CameraDevice mCameraDevice;
    private CaptureRequest.Builder mPreviewBuilder;
    private CaptureRequest.Builder mCaptureBuilder;
    private CameraManager mCameraManager;
    private HandlerThread mHandlerThread;
    private Handler mHandler;
    private CameraCharacteristics mCameraCharacteristics;
    private String mCameraId;
    private int mFormat;
    private ImageReader mImageReader = null;
    private CameraCaptureSession mCameraCaptureSession;
    private PreviewSessionCallback mPreviewSessionCallback = null;
    private MediaActionSound mMediaActionSound;
    private Surface mSurface;
    private Size mlargest;
    private float valueAF;
    private int valueAE;
    private long valueAETime;
    private int valueISO;
    public static CameraPluginActivity context;
    private static final int MAX_IMAGES = 4;
    private static final int CONVERSION_FRAME_RATE = 60;
    private RenderScript mRenderScript;
    private YuvToRgb mConversionScript;
    private Size[][] pictureSizes;
    private Integer[] formats;
    private Integer mCameraState = 0;
    private CameraDevice.StateCallback mCameraDeviceStateCallback = new CameraDevice.StateCallback(){

        public void onClosed(CameraDevice camera) {
            Log.i((String)"StateCallback", (String)"onClosed");
            CameraPluginActivity.this.mCameraState = 4;
        }

        public void onOpened(CameraDevice cameraDevice) {
            Log.i((String)"Thread", (String)("onOpened---->" + Thread.currentThread().getName()));
            Log.i((String)"StateCallback", (String)"onOpened");
            CameraPluginActivity.this.mCameraDevice = cameraDevice;
            CameraPluginActivity.this.startPreview();
            CameraPluginActivity.this.mCameraState = 2;
        }

        public void onDisconnected(CameraDevice cameraDevice) {
            Log.i((String)"StateCallback", (String)"onDisconnected");
            CameraPluginActivity.this.mCameraState = 4;
        }

        public void onError(CameraDevice cameraDevice, int i) {
            Log.i((String)"StateCallback", (String)("onError--->" + i + ",,,null == cameraDevice--->" + (null == cameraDevice)));
            CameraPluginActivity.this.mCameraState = 4;
        }
    };
    private CameraCaptureSession.StateCallback mSessionCaptureStateCallback = new CameraCaptureSession.StateCallback(){

        public void onConfigured(CameraCaptureSession session) {
            CameraCaptureSession.CaptureCallback CaptureCallback2 = new CameraCaptureSession.CaptureCallback(){

                public void onCaptureCompleted(CameraCaptureSession session, CaptureRequest request, TotalCaptureResult result) {
                    CameraPluginActivity.this.mMediaActionSound.play(0);
                    CameraPluginActivity.this.continuePreview();
                }
            };
            try {
                session.capture(CameraPluginActivity.this.mCaptureBuilder.build(), CaptureCallback2, CameraPluginActivity.this.mHandler);
            }
            catch (CameraAccessException e) {
                throw new RuntimeException(e);
            }
            catch (Exception e) {
                Log.e((String)"onConfigured", (String)e.getMessage());
            }
        }

        public void onConfigureFailed(CameraCaptureSession session) {
            Toast.makeText((Context)CameraPluginActivity.this, (CharSequence)"onConfigureFailed---Capture", (int)0).show();
        }
    };
    private CameraCaptureSession.StateCallback mSessionPreviewStateCallback = new CameraCaptureSession.StateCallback(){

        public void onConfigured(CameraCaptureSession cameraCaptureSession) {
            Log.i((String)"mSessionPreview", (String)("onConfigured---->" + Thread.currentThread().getName()));
            Log.i((String)"mSessionPreview", (String)"mSessionStateCallback--->onConfigured");
            Log.i((String)"mSessionPreview", (String)(CameraPluginActivity.this.getCameraState() + " "));
            try {
                CameraDevice device = cameraCaptureSession.getDevice();
                if (device != CameraPluginActivity.this.mCameraDevice) {
                    Log.i((String)"mCameraDevice", (String)"device replaced");
                    return;
                }
                CameraPluginActivity.this.mCameraCaptureSession = cameraCaptureSession;
                cameraCaptureSession.setRepeatingRequest(CameraPluginActivity.this.mPreviewBuilder.build(), (CameraCaptureSession.CaptureCallback)CameraPluginActivity.this.mPreviewSessionCallback, CameraPluginActivity.this.mHandler);
            }
            catch (CameraAccessException e) {
                e.printStackTrace();
            }
        }

        public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
            Log.i((String)"StateCallback", (String)"mSessionStateCallback--->onConfigureFailed");
            Toast.makeText((Context)CameraPluginActivity.this, (CharSequence)"onConfigureFailed---Preview", (int)0).show();
        }

        public void onReady(CameraCaptureSession session) {
            super.onReady(session);
            Log.i((String)"StateCallback", (String)"mSessionStateCallback--->onReady");
        }

        public void onActive(CameraCaptureSession session) {
            super.onActive(session);
            Log.i((String)"StateCallback", (String)"mSessionStateCallback--->onActive");
        }

        public void onClosed(CameraCaptureSession session) {
            super.onClosed(session);
            Log.i((String)"StateCallback", (String)"mSessionStateCallback--->onClosed");
        }
    };

    public native void nativeInit();

    public native void nativeRelease();

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        System.loadLibrary("NativeCameraPlugin");
        CameraPluginActivity.setContext(this);
    }

    private void initSeekBarValue() {
        this.valueAF = 5.0f;
        this.valueAETime = 0x6663464L;
        this.valueISO = 4950;
        this.valueAE = 0;
    }

    private void initShutter() {
        this.mMediaActionSound = new MediaActionSound();
        this.mMediaActionSound.load(0);
    }

    private static synchronized void setContext(CameraPluginActivity context) {
        CameraPluginActivity.context = context;
    }

    protected void onDestroy() {
        super.onDestroy();
        this.nativeRelease();
        CameraPluginActivity.setContext(null);
    }

    public void onPause() {
        super.onPause();
    }

    @UsedThroughReflection
    public void requestJavaRendering(int texturePointer) {
        int[] imageBuffer = new int[]{};
        if (this.mConversionScript != null) {
            imageBuffer = this.mConversionScript.getOutputBuffer();
        }
        if (imageBuffer.length > 1) {
            GLES30.glBindTexture((int)3553, (int)texturePointer);
            GLES30.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)this.mPreviewSize.getWidth(), (int)this.mPreviewSize.getHeight(), (int)6408, (int)5121, (Buffer)IntBuffer.wrap(imageBuffer));
        }
    }

    @UsedThroughReflection
    public void initCamera() {
        block12: {
            if (Build.VERSION.SDK_INT >= 23 && this.checkSelfPermission("android.permission.CAMERA") != 0) {
                return;
            }
            this.nativeInit();
            this.mRenderScript = RenderScript.create((Context)this);
            this.initSeekBarValue();
            this.initShutter();
            this.initHandler();
            try {
                ArrayList<Integer> formatList;
                int[] formatsAll;
                Size[] previewSizes;
                StreamConfigurationMap map;
                CameraCharacteristics character;
                CameraManager manager = (CameraManager)this.getSystemService("camera");
                String[] cameraIds = manager.getCameraIdList();
                if (cameraIds == null || cameraIds.length <= 0) break block12;
                if (cameraIds[0] != null) {
                    character = manager.getCameraCharacteristics(cameraIds[0]);
                    map = (StreamConfigurationMap)character.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
                    previewSizes = map.getOutputSizes(SurfaceTexture.class);
                    formatsAll = map.getOutputFormats();
                    formatList = new ArrayList<Integer>();
                    for (int format : formatsAll) {
                        Log.i((String)"Runnable", (String)("format--->" + format));
                        if (format != 256 && format != 32) continue;
                        formatList.add(format);
                    }
                    this.formats = formatList.toArray(new Integer[formatList.size()]);
                    this.pictureSizes = new Size[this.formats.length][];
                    for (int i = 0; i < this.formats.length; ++i) {
                        if (null != map.getOutputSizes(this.formats[i].intValue())) {
                            this.pictureSizes[i] = map.getOutputSizes(this.formats[i].intValue());
                            for (int j = 0; j < this.pictureSizes[i].length; ++j) {
                                Log.i((String)"Runnable", (String)("formats[i]--->" + this.formats[i] + ",,," + this.pictureSizes[i][j].getWidth() + ",,," + this.pictureSizes[i][j].getHeight()));
                            }
                            continue;
                        }
                        Log.i((String)"Runnable", (String)"camera0--->map.getOutputSizes\u4e3a\u7a7a");
                    }
                    PreferenceHelper.writePreferenceForCameraId((Context)this, "camera0", previewSizes, this.formats, this.pictureSizes);
                }
                if (cameraIds[1] != null) {
                    character = manager.getCameraCharacteristics(cameraIds[1]);
                    map = (StreamConfigurationMap)character.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
                    previewSizes = map.getOutputSizes(SurfaceTexture.class);
                    formatsAll = map.getOutputFormats();
                    formatList = new ArrayList();
                    for (int format : formatsAll) {
                        if (format != 256 && format != 32) continue;
                        formatList.add(format);
                    }
                    this.formats = formatList.toArray(new Integer[formatList.size()]);
                    this.pictureSizes = new Size[this.formats.length][];
                    for (int i = 0; i < this.formats.length; ++i) {
                        if (null != map.getOutputSizes(this.formats[i].intValue())) {
                            this.pictureSizes[i] = map.getOutputSizes(this.formats[i].intValue());
                            continue;
                        }
                        Log.i((String)"Runnable", (String)"camera1--->map.getOutputSizes\u4e3a\u7a7a");
                    }
                    PreferenceHelper.writePreferenceForCameraId((Context)this, "camera1", previewSizes, this.formats, this.pictureSizes);
                }
            }
            catch (CameraAccessException e) {
                e.printStackTrace();
                return;
            }
        }
        PreferenceHelper.writeCurrentCameraid((Context)this, "0");
        this.mCameraId = PreferenceHelper.getCurrentCameraid((Context)this);
        this.mCameraState = 1;
    }

    @UsedThroughReflection
    public boolean openCamera(int viewWidth, int viewHeight) throws CameraAccessException, InterruptedException {
        this.mCameraManager = (CameraManager)this.getSystemService("camera");
        this.setUpCameraOutputs(viewWidth, viewHeight);
        this.configureTransform(viewWidth, viewHeight);
        this.initOutputSurface(viewWidth, viewHeight);
        if (Build.VERSION.SDK_INT >= 23 && this.checkSelfPermission("android.permission.CAMERA") != 0) {
            return false;
        }
        this.mCameraManager.openCamera(this.mCameraId, this.mCameraDeviceStateCallback, this.mHandler);
        this.mCameraState = 3;
        return true;
    }

    private void initHandler() {
        this.mHandlerThread = new HandlerThread("Android_L_Camera");
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper());
    }

    private void initOutputSurface(int width, int height) {
        this.mFormat = 256;
        int sizeWidth = width;
        int sizeHeight = height;
        Log.i((String)"initOutputSurface", (String)("mLargest--->" + this.mlargest.getWidth() + ",,," + this.mlargest.getHeight()));
        Log.i((String)"initOutputSurface", (String)("mPreviewSize--->" + this.mPreviewSize.getWidth() + ",,," + this.mPreviewSize.getHeight()));
        ImageReader imageReader = ImageReader.newInstance((int)this.mlargest.getWidth(), (int)this.mlargest.getHeight(), (int)this.mFormat, (int)4);
        this.mConversionScript = new YuvToRgb(this.mRenderScript, this.mPreviewSize, 60);
        this.mConversionScript.setOutputSurface(imageReader.getSurface());
        this.mSurface = this.mConversionScript.getInputSurface();
    }

    private void configureTransform(int viewWidth, int viewHeight) {
    }

    private void setUpCameraOutputs(int width, int height) throws CameraAccessException {
        this.mFormat = 256;
        this.mCameraCharacteristics = this.mCameraManager.getCameraCharacteristics(this.mCameraId);
        StreamConfigurationMap map = (StreamConfigurationMap)this.mCameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        this.mlargest = new Size(width, height);
        this.mPreviewSize = new Size(width, height);
        int orientation = this.getResources().getConfiguration().orientation;
    }

    private Size chooseOptimalSize(Size[] choices, int width, int height, Size aspectRatio) {
        ArrayList<Size> bigEnough = new ArrayList<Size>();
        int w = aspectRatio.getWidth();
        int h = aspectRatio.getHeight();
        for (Size option : choices) {
            if (option.getHeight() != option.getWidth() * h / w || option.getWidth() < width || option.getHeight() < height) continue;
            bigEnough.add(option);
        }
        if (bigEnough.size() > 0) {
            return Collections.min(bigEnough, new CompareSizesByArea());
        }
        Log.e((String)"nonono", (String)"Couldn't find any suitable preview size");
        return choices[0];
    }

    private void startPreview() {
        try {
            this.mPreviewBuilder = this.mCameraDevice.createCaptureRequest(1);
            this.mPreviewBuilder.addTarget(this.mSurface);
            this.initPreviewBuilder();
            this.mPreviewBuilder.set(CaptureRequest.CONTROL_MODE, (Object)1);
            this.mPreviewBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
            this.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
            this.mPreviewBuilder.set(CaptureRequest.CONTROL_AWB_MODE, (Object)1);
            this.mState = 1;
            this.mCameraDevice.createCaptureSession(Arrays.asList(this.mSurface), this.mSessionPreviewStateCallback, this.mHandler);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    private void initPreviewBuilder() {
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_MODE, (Object)0);
        this.mPreviewBuilder.set(CaptureRequest.LENS_FOCUS_DISTANCE, (Object)Float.valueOf(this.valueAF));
        this.mPreviewBuilder.set(CaptureRequest.SENSOR_EXPOSURE_TIME, (Object)this.valueAETime);
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION, (Object)this.valueAE);
        this.mPreviewBuilder.set(CaptureRequest.SENSOR_SENSITIVITY, (Object)this.valueISO);
    }

    @UsedThroughReflection
    public void stopCamera() {
        if (this.mCameraCaptureSession != null) {
            this.mCameraCaptureSession.close();
            this.mCameraCaptureSession = null;
        }
        if (null != this.mCameraDevice) {
            this.mCameraDevice.close();
            this.mCameraDevice = null;
            this.mCameraState = 1;
        }
        Log.i((String)"stopCamera", (String)"stopCamera");
    }

    @UsedThroughReflection
    public void takePicture() throws CameraAccessException {
        if (this.mImageReader == null) {
            this.mImageReader = ImageReader.newInstance((int)this.mlargest.getWidth(), (int)this.mlargest.getHeight(), (int)256, (int)2);
            this.mImageReader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)new JpegReaderListener(), this.mHandler);
        }
        this.mCaptureBuilder = this.mCameraDevice.createCaptureRequest(2);
        if (this.mFormat == 32) {
            this.mCaptureBuilder.set(CaptureRequest.STATISTICS_LENS_SHADING_MAP_MODE, (Object)1);
        }
        this.mCaptureBuilder.addTarget(this.mImageReader.getSurface());
        Range[] fps = (Range[])this.mCameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
        int rotation = this.getWindowManager().getDefaultDisplay().getRotation();
        this.mCaptureBuilder.set(CaptureRequest.JPEG_ORIENTATION, (Object)ORIENTATIONS.get(rotation));
        this.previewBuilder2CaptureBuilder();
        this.mState = 2;
        Log.i((String)"takePicture", (String)("mCaptureBuilder--->" + this.mCaptureBuilder.toString()));
        try {
            this.mCameraDevice.createCaptureSession(Arrays.asList(this.mImageReader.getSurface()), this.mSessionCaptureStateCallback, this.mHandler);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    private void previewBuilder2CaptureBuilder() {
        this.mCaptureBuilder.set(CaptureRequest.CONTROL_MODE, (Object)((Integer)this.mPreviewBuilder.get(CaptureRequest.CONTROL_MODE)));
        this.mCaptureBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)((Integer)this.mPreviewBuilder.get(CaptureRequest.CONTROL_AF_MODE)));
        this.mCaptureBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)((Integer)this.mPreviewBuilder.get(CaptureRequest.CONTROL_AE_MODE)));
        this.mCaptureBuilder.set(CaptureRequest.CONTROL_AWB_MODE, (Object)((Integer)this.mPreviewBuilder.get(CaptureRequest.CONTROL_AWB_MODE)));
        if ((Integer)this.mPreviewBuilder.get(CaptureRequest.CONTROL_AE_MODE) == 0) {
            Log.i((String)"Runnable", (String)("mPreviewBuilder.get(CaptureRequest.SENSOR_EXPOSURE_TIME)--->" + this.mPreviewBuilder.get(CaptureRequest.SENSOR_EXPOSURE_TIME)));
            this.mCaptureBuilder.set(CaptureRequest.SENSOR_EXPOSURE_TIME, (Object)((Long)this.mPreviewBuilder.get(CaptureRequest.SENSOR_EXPOSURE_TIME)));
        } else if ((Integer)this.mPreviewBuilder.get(CaptureRequest.CONTROL_AE_MODE) == 1) {
            this.mCaptureBuilder.set(CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION, (Object)((Integer)this.mPreviewBuilder.get(CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION)));
        }
        this.mCaptureBuilder.set(CaptureRequest.LENS_FOCUS_DISTANCE, (Object)((Float)this.mPreviewBuilder.get(CaptureRequest.LENS_FOCUS_DISTANCE)));
        this.mCaptureBuilder.set(CaptureRequest.CONTROL_EFFECT_MODE, (Object)((Integer)this.mPreviewBuilder.get(CaptureRequest.CONTROL_EFFECT_MODE)));
        this.mCaptureBuilder.set(CaptureRequest.SENSOR_SENSITIVITY, (Object)((Integer)this.mPreviewBuilder.get(CaptureRequest.SENSOR_SENSITIVITY)));
        this.mCaptureBuilder.set(CaptureRequest.CONTROL_AF_REGIONS, (Object)((MeteringRectangle[])this.mPreviewBuilder.get(CaptureRequest.CONTROL_AF_REGIONS)));
        this.mCaptureBuilder.set(CaptureRequest.CONTROL_AE_REGIONS, (Object)((MeteringRectangle[])this.mPreviewBuilder.get(CaptureRequest.CONTROL_AE_REGIONS)));
        this.mCaptureBuilder.set(CaptureRequest.CONTROL_SCENE_MODE, (Object)((Integer)this.mPreviewBuilder.get(CaptureRequest.CONTROL_SCENE_MODE)));
        this.mCaptureBuilder.set(CaptureRequest.SCALER_CROP_REGION, (Object)((Rect)this.mPreviewBuilder.get(CaptureRequest.SCALER_CROP_REGION)));
    }

    @UsedThroughReflection
    public void continuePreview() {
        Log.i((String)"continuePreview", (String)"continuePreview");
        this.mState = 1;
        try {
            this.mCameraDevice.createCaptureSession(Arrays.asList(this.mSurface), this.mSessionPreviewStateCallback, this.mHandler);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    private String getCamera(CameraManager _manager) {
        try {
            for (String cameraId : _manager.getCameraIdList()) {
                CameraCharacteristics characteristics = _manager.getCameraCharacteristics(cameraId);
                int cameraOrientation = (Integer)characteristics.get(CameraCharacteristics.LENS_FACING);
                if (cameraOrientation != 1) continue;
                return cameraId;
            }
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    @UsedThroughReflection
    public void setExposureTime(long exposureTime) {
        this.mPreviewBuilder.set(CaptureRequest.SENSOR_EXPOSURE_TIME, (Object)exposureTime);
    }

    @UsedThroughReflection
    public long getMaxExposureTime() {
        try {
            CameraManager manager = (CameraManager)this.getSystemService("camera");
            String pickedCamera = this.getCamera(manager);
            CameraCharacteristics characteristics = manager.getCameraCharacteristics(pickedCamera);
            return (Long)((Range)characteristics.get(CameraCharacteristics.SENSOR_INFO_EXPOSURE_TIME_RANGE)).getUpper();
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    @UsedThroughReflection
    public long getMinExposureTime() {
        try {
            CameraManager manager = (CameraManager)this.getSystemService("camera");
            String pickedCamera = this.getCamera(manager);
            CameraCharacteristics characteristics = manager.getCameraCharacteristics(pickedCamera);
            return (Long)((Range)characteristics.get(CameraCharacteristics.SENSOR_INFO_EXPOSURE_TIME_RANGE)).getLower();
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    @UsedThroughReflection
    public void setZoomRatio(float zoomRatio) {
        float maxRatio = this.getMaxZoomRatio();
        zoomRatio = Math.min(zoomRatio, maxRatio);
        try {
            CameraManager manager = (CameraManager)this.getSystemService("camera");
            String pickedCamera = this.getCamera(manager);
            CameraCharacteristics characteristics = manager.getCameraCharacteristics(pickedCamera);
            this.mPreviewBuilder.set(CaptureRequest.SCALER_CROP_REGION, (Object)this.getZoomRect(characteristics, zoomRatio));
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    private Rect getZoomRect(CameraCharacteristics characteristics, float zoomLevel) {
        Rect sensorRect = (Rect)characteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
        int xCenter = sensorRect.width() / 2;
        int yCenter = sensorRect.height() / 2;
        int deltaX = (int)((float)sensorRect.width() / (2.0f * zoomLevel));
        int deltaY = (int)((float)sensorRect.height() / (2.0f * zoomLevel));
        return new Rect(xCenter - deltaX, yCenter - deltaY, xCenter + deltaX, yCenter + deltaY);
    }

    @UsedThroughReflection
    public float getMaxZoomRatio() {
        try {
            CameraManager manager = (CameraManager)this.getSystemService("camera");
            String pickedCamera = this.getCamera(manager);
            CameraCharacteristics characteristics = manager.getCameraCharacteristics(pickedCamera);
            return ((Float)characteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM)).floatValue();
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
            return 1.0f;
        }
    }

    @UsedThroughReflection
    public void setAutoExposure(boolean autoExposure) {
        this.mPreviewBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)(autoExposure ? 1 : 0));
    }

    @UsedThroughReflection
    public String getFormatSize() {
        String ret = "";
        Integer f = 0;
        while (f < this.formats.length) {
            Integer format = this.formats[f];
            if (format == 256) {
                Size[] sizes;
                for (Size size : sizes = this.pictureSizes[f]) {
                    ret = ret + size.getWidth() + "," + size.getHeight() + ";";
                }
            }
            Integer n = f;
            f = f + 1;
        }
        return ret;
    }

    @UsedThroughReflection
    public int getCameraState() {
        return this.mCameraState;
    }

    @UsedThroughReflection
    public boolean isCameraNull() {
        return this.mCameraDevice == null;
    }

    @UsedThroughReflection
    public int[] getImageBuffer() {
        if (this.mConversionScript != null) {
            return this.mConversionScript.getOutputBuffer();
        }
        return new int[0];
    }

    @UsedThroughReflection
    public void refreshSetting() {
        this.continuePreview();
    }

    static {
        ORIENTATIONS.append(0, 90);
        ORIENTATIONS.append(1, 0);
        ORIENTATIONS.append(2, 270);
        ORIENTATIONS.append(3, 180);
    }

    private class CompareSizesByArea
    implements Comparator<Size> {
        private CompareSizesByArea() {
        }

        @Override
        public int compare(Size lhs, Size rhs) {
            return Long.signum((long)lhs.getWidth() * (long)lhs.getHeight() - (long)rhs.getWidth() * (long)rhs.getHeight());
        }
    }
}

