/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb.uvc;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.view.Surface;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.media.MediaCodecUtils;
import com.serenegiant.media.VideoConfig;
import com.serenegiant.system.BuildCheck;
import com.serenegiant.usb.uvc.TranscodeH264;
import java.io.IOException;

@Keep
@TargetApi(value=18)
public class SurfaceH264PipelineSource
extends TranscodeH264 {
    private static final boolean DEBUG = false;
    private static final String TAG = SurfaceH264PipelineSource.class.getSimpleName();
    private Surface mInputSurface;

    public SurfaceH264PipelineSource() {
        this(0, null, null);
    }

    public SurfaceH264PipelineSource(int prefixOptions) {
        this(prefixOptions, null, null);
    }

    public SurfaceH264PipelineSource(int prefixOptions, TranscodeH264.TranscodeH264Listener listener, @Nullable VideoConfig config) {
        super(prefixOptions, listener, config);
        this.setState(0);
    }

    @Override
    protected void onCreateEncoder(@NonNull MediaCodec videoEncoder) {
        this.mInputSurface = videoEncoder.createInputSurface();
    }

    public Surface getInputSurface() throws IllegalStateException {
        if (this.getState() == 2) {
            return this.mInputSurface;
        }
        throw new IllegalStateException();
    }

    @Override
    @SuppressLint(value={"InlinedApi"})
    protected MediaCodec createEncoder(@NonNull VideoConfig config, int width, int height, int frameRate, float bpp, int iFrameIntervals, long repeatIntervalUs) throws IOException {
        MediaCodecInfo codecInfo = MediaCodecUtils.selectVideoEncoder((String)"video/avc");
        if (codecInfo == null) {
            throw new IOException("Unable to find an appropriate codec for video/avc");
        }
        MediaFormat format = MediaFormat.createVideoFormat((String)"video/avc", (int)width, (int)height);
        format.setInteger("color-format", 2130708361);
        format.setInteger("bitrate", config.getBitrate(width, height, frameRate, bpp));
        format.setInteger("frame-rate", frameRate);
        format.setInteger("i-frame-interval", iFrameIntervals);
        if (BuildCheck.isKitKat() && repeatIntervalUs > 0L) {
            format.setLong("repeat-previous-frame-after", repeatIntervalUs);
        }
        MediaCodec encoder = MediaCodec.createEncoderByType((String)"video/avc");
        encoder.configure(format, null, null, 1);
        return encoder;
    }
}

