/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb.uvc;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.documentfile.provider.DocumentFile;
import com.serenegiant.camera.IFrameCallback;
import com.serenegiant.camera.RawFrameType;
import com.serenegiant.media.IMuxer;
import com.serenegiant.media.VideoConfig;
import com.serenegiant.media.VideoMuxer;
import com.serenegiant.system.BuildCheck;
import com.serenegiant.usb.uvc.FrameCallbackPipeline;
import com.serenegiant.utils.BufferHelper;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;

@SuppressLint(value={"NewApi"})
public class MP4FrameSavePipeline
extends FrameCallbackPipeline {
    private static final String TAG = MP4FrameSavePipeline.class.getSimpleName();
    public static final String MIME_VIDEO_RAW = "video/raw";
    public static final String MIME_AUDIO_RAW = "audio/raw";
    @SuppressLint(value={"InlinedApi"})
    private static final int BUFFER_FLAG_KEY_FRAME = BuildCheck.isLollipop() ? 1 : 1;
    private final IMuxer.IMuxerFactory mMuxerFactory = new VideoMuxer.DefaultFactory();
    private final String mMime;
    private final RawFrameType mRawFrameType;
    private final int mRawFrameTypeValue;
    private final int mTargetFps;
    private final MediaCodec.BufferInfo mBufferInfo = new MediaCodec.BufferInfo();
    private IMuxer mMuxer;
    private int mTrackIndex;
    private final IFrameCallback mFrameCallback = new IFrameCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFrame(@NonNull ByteBuffer frame, int width, int height, long presentationTimeUs, int raw_frame_t, int flags) {
            if (MP4FrameSavePipeline.this.mRawFrameTypeValue == raw_frame_t) {
                Object object = MP4FrameSavePipeline.this.mSync;
                synchronized (object) {
                    MP4FrameSavePipeline.this.onFrame(frame, width, height, presentationTimeUs, raw_frame_t, flags);
                }
            }
        }
    };

    @Deprecated
    public MP4FrameSavePipeline(@NonNull String outputPath, RawFrameType rawFrameType, int targetFps) throws IOException {
        this(MIME_VIDEO_RAW, outputPath, rawFrameType, targetFps, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public MP4FrameSavePipeline(String mime, @NonNull String outputPath, RawFrameType rawFrameType, int targetFps, @Nullable VideoConfig config) throws IOException {
        File path = new File(outputPath);
        path.getParentFile().mkdirs();
        VideoConfig videoConfig = config != null ? config : new VideoConfig();
        Object object = this.mSync;
        synchronized (object) {
            this.mMime = mime;
            this.mRawFrameType = rawFrameType;
            this.mRawFrameTypeValue = rawFrameType.getValue();
            this.mTargetFps = targetFps;
            this.mMuxer = this.mMuxerFactory.createMuxer(videoConfig.useMediaMuxer(), outputPath);
        }
    }

    public MP4FrameSavePipeline(@NonNull Context context, @NonNull DocumentFile output, RawFrameType rawFrameType, int targetFps) throws IOException {
        this(context, MIME_VIDEO_RAW, output, rawFrameType, targetFps, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MP4FrameSavePipeline(@NonNull Context context, String mime, @NonNull DocumentFile output, RawFrameType rawFrameType, int targetFps, @Nullable VideoConfig config) throws IOException {
        VideoConfig videoConfig = config != null ? config : new VideoConfig();
        Object object = this.mSync;
        synchronized (object) {
            this.mMime = mime;
            this.mRawFrameType = rawFrameType;
            this.mRawFrameTypeValue = rawFrameType.getValue();
            this.mTargetFps = targetFps;
            this.mMuxer = this.mMuxerFactory.createMuxer(context, videoConfig.useMediaMuxer(), output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mMuxer != null) {
                try {
                    this.mMuxer.release();
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                }
                this.mMuxer = null;
            }
            super.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void start() {
        Object object = this.mSync;
        synchronized (object) {
            super.setFrameCallback(this.mFrameCallback, this.mRawFrameType);
            super.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() {
        super.stop();
        Object object = this.mSync;
        synchronized (object) {
            if (this.mMuxer != null && this.mMuxer.isStarted()) {
                this.mMuxer.stop();
            }
        }
    }

    private MediaFormat createFormat(int width, int height) {
        MediaFormat format = MediaFormat.createVideoFormat((String)this.mMime, (int)width, (int)height);
        format.setInteger("color-format", 19);
        format.setInteger("frame-rate", this.mTargetFps);
        format.setInteger("i-frame-interval", 1);
        if (this.mRawFrameType == RawFrameType.RAW_FRAME_MJPEG) {
            format.setByteBuffer("csd-0", BufferHelper.from((String)"038080801B000100048080800D6C11000000000A1CB4000A1CB4068080800102"));
            format.setByteBuffer("csd-1", BufferHelper.from((String)"038080801B000100048080800D6C11000000000A1CB4000A1CB4068080800102"));
        }
        return format;
    }

    @Override
    public void setFrameCallback(@Nullable IFrameCallback callback, RawFrameType rawFrameType) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("FrameSavePipeline#setFrameCallback can not call");
    }

    protected void onFrame(@NonNull ByteBuffer frame, int width, int height, long presentationTimeUs, int rawFrameType, int flags) {
        if (this.mMuxer != null) {
            if (!this.mMuxer.isStarted()) {
                try {
                    MediaFormat format = this.createFormat(width, height);
                    this.mTrackIndex = this.mMuxer.addTrack(format);
                    this.mMuxer.start();
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                    return;
                }
            }
            if (this.mMuxer.isStarted() && this.mTrackIndex >= 0) {
                this.mBufferInfo.set(0, frame.limit(), presentationTimeUs, flags | BUFFER_FLAG_KEY_FRAME);
                this.mMuxer.writeSampleData(this.mTrackIndex, frame, this.mBufferInfo);
            }
        }
    }
}

