/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb.uvc;

import androidx.annotation.NonNull;
import com.serenegiant.usb.uvc.PreviewFormat;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class CameraConfig {
    public static final float FPS_MIN = 0.1f;
    public static final float FPS_MAX = 121.0f;
    public static final int PREFER_MJPEG_YUV = 0;
    public static final int PREFER_YUV_MJPEG = 1;
    public static final int PREFER_H264_MJPEG_YUV = 2;
    public static final int PREFER_YUV_H264_MJPEG = 3;
    public static final int PREFER_MJPEG_H264_YUV = 4;
    public static final int PREFER_MJPEG_ONLY = 5;
    public static final int PREFER_YUV_ONLY = 6;
    public static final int PREFER_H264_ONLY = 7;
    public static float maxFps = 121.0f;
    public static float maxFpsMediaCodec = 31.0f;
    public static float minFps = 0.1f;

    @NonNull
    public static PreviewFormat[] getPreviewFormats(int preferMode) {
        PreviewFormat[] formats;
        switch (preferMode) {
            case 1: {
                formats = new PreviewFormat[]{PreviewFormat.PREVIEW_FORMAT_YUY2, PreviewFormat.PREVIEW_FORMAT_MJPEG};
                break;
            }
            case 2: {
                formats = new PreviewFormat[]{PreviewFormat.PREVIEW_FORMAT_H264, PreviewFormat.PREVIEW_FORMAT_MJPEG, PreviewFormat.PREVIEW_FORMAT_YUY2};
                break;
            }
            case 3: {
                formats = new PreviewFormat[]{PreviewFormat.PREVIEW_FORMAT_YUY2, PreviewFormat.PREVIEW_FORMAT_H264, PreviewFormat.PREVIEW_FORMAT_MJPEG};
                break;
            }
            case 4: {
                formats = new PreviewFormat[]{PreviewFormat.PREVIEW_FORMAT_MJPEG, PreviewFormat.PREVIEW_FORMAT_H264, PreviewFormat.PREVIEW_FORMAT_YUY2};
                break;
            }
            case 5: {
                formats = new PreviewFormat[]{PreviewFormat.PREVIEW_FORMAT_MJPEG};
                break;
            }
            case 6: {
                formats = new PreviewFormat[]{PreviewFormat.PREVIEW_FORMAT_YUY2};
                break;
            }
            case 7: {
                formats = new PreviewFormat[]{PreviewFormat.PREVIEW_FORMAT_H264};
                break;
            }
            default: {
                formats = new PreviewFormat[]{PreviewFormat.PREVIEW_FORMAT_MJPEG, PreviewFormat.PREVIEW_FORMAT_YUY2};
            }
        }
        return formats;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PreferMode {
    }
}

