/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb.upc;

import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.Nullable;
import com.serenegiant.usb.uvc.IPipeline;

@Keep
public class GLRendererPipeline
extends IPipeline {
    private static final boolean DEBUG = false;
    private static final String TAG = GLRendererPipeline.class.getSimpleName();

    public GLRendererPipeline(int glVersion, boolean keepLastFrame, boolean enable_hw_buffer) {
        super(520);
        this.mNativePtr = this.nativeCreate(glVersion, keepLastFrame, enable_hw_buffer);
    }

    @Override
    public int getState() {
        return this.nativeGetState(this.mNativePtr);
    }

    @Override
    public void setPipeline(@Nullable IPipeline nextPipeline) {
        if (this.getState() < 20) {
            throw new IllegalStateException("already released");
        }
        this.nativeSetPipeline(this.mNativePtr, nextPipeline);
    }

    @Override
    public void start() {
        int result = GLRendererPipeline.nativeStart(this.mNativePtr);
        if (result != 0) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void stop() {
        int result = GLRendererPipeline.nativeStop(this.mNativePtr);
        if (result != 0) {
            Log.w((String)TAG, (String)("nativeStop returned " + result));
        }
    }

    @Override
    public void release() {
        this.nativeDestroy(this.mNativePtr);
        this.mNativePtr = 0L;
        this.nativeDestroy(this.mNativePtr);
    }

    public void onDraw() {
        GLRendererPipeline.nativeOnDraw(this.mNativePtr);
    }

    private final native long nativeCreate(int var1, boolean var2, boolean var3);

    private final native void nativeDestroy(long var1);

    private final native int nativeGetState(long var1);

    private final native int nativeSetPipeline(long var1, IPipeline var3);

    private static final native int nativeStart(long var0);

    private static final native int nativeStop(long var0);

    private static final native int nativeOnDraw(long var0);
}

