/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.androidutils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.serenegiant.androidutils.AndroidUtils;
import com.serenegiant.androidutils.IAndroidUtils;
import com.serenegiant.androidutils.R;
import com.serenegiant.dialog.MessageDialogAppFragment;
import com.serenegiant.system.BuildCheck;
import com.serenegiant.system.PermissionCheck;
import com.unity3d.player.UnityPlayer;

public class AndroidUtilsFragment
extends Fragment
implements IAndroidUtils,
MessageDialogAppFragment.MessageDialogListener {
    private static final boolean DEBUG = false;
    private static final String TAG = AndroidUtilsFragment.class.getSimpleName();
    private static final long SEND_DELAY_MS = 300L;
    private final Handler mUIHandler = new Handler(Looper.getMainLooper());
    @Nullable
    private String mCallbackUnityObjName;
    private final Runnable mSendOnStartTask = new Runnable(){

        @Override
        public void run() {
            AndroidUtilsFragment.this.sendCallbackMessage("OnStartEvent", null);
        }
    };
    private final Runnable mSendOnResumeTask = new Runnable(){

        @Override
        public void run() {
            AndroidUtilsFragment.this.sendCallbackMessage("OnResumeEvent", null);
        }
    };
    private final Runnable mSendOnPauseTask = new Runnable(){

        @Override
        public void run() {
            AndroidUtilsFragment.this.sendCallbackMessage("OnPauseEvent", null);
        }
    };
    private final Runnable mSendOnStopTask = new Runnable(){

        @Override
        public void run() {
            AndroidUtilsFragment.this.sendCallbackMessage("OnStopEvent", null);
        }
    };

    private static AndroidUtilsFragment requireUtils(@NonNull Activity activity) throws IllegalStateException {
        FragmentManager fm = activity.getFragmentManager();
        Fragment detector = fm.findFragmentByTag(AndroidUtilsFragment.class.getName());
        if (!(detector instanceof AndroidUtilsFragment)) {
            throw new IllegalStateException();
        }
        return (AndroidUtilsFragment)detector;
    }

    public AndroidUtilsFragment() {
        this.setRetainInstance(true);
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle args = savedInstanceState;
        if (args == null) {
            args = this.getArguments();
        }
        if (args != null) {
            this.mCallbackUnityObjName = args.getString("ARGS_KEY_CALLBACK_UNITY_OBJECT_NAME");
        }
    }

    public void onStart() {
        super.onStart();
        this.mUIHandler.removeCallbacks(this.mSendOnStartTask);
        this.mUIHandler.removeCallbacks(this.mSendOnStopTask);
        this.mUIHandler.postDelayed(this.mSendOnStartTask, 300L);
    }

    public void onResume() {
        super.onResume();
        this.mUIHandler.removeCallbacks(this.mSendOnResumeTask);
        this.mUIHandler.removeCallbacks(this.mSendOnPauseTask);
        this.mUIHandler.postDelayed(this.mSendOnResumeTask, 300L);
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        Bundle args = this.getArguments();
        if (args != null) {
            outState.putAll(args);
        }
    }

    public void onPause() {
        this.mUIHandler.removeCallbacks(this.mSendOnResumeTask);
        this.mUIHandler.removeCallbacks(this.mSendOnPauseTask);
        this.mUIHandler.postDelayed(this.mSendOnPauseTask, 300L);
        super.onPause();
    }

    public void onStop() {
        this.mUIHandler.removeCallbacks(this.mSendOnStartTask);
        this.mUIHandler.removeCallbacks(this.mSendOnStopTask);
        this.mUIHandler.postDelayed(this.mSendOnStopTask, 300L);
        super.onStop();
    }

    public void onDestroy() {
        this.mUIHandler.removeCallbacksAndMessages(null);
        super.onDestroy();
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == AndroidUtils.REQUEST_CODE) {
            int n = Math.min(permissions.length, grantResults.length);
            for (int i = 0; i < n; ++i) {
                this.processPermission(permissions[i], grantResults[i]);
            }
        }
    }

    @Override
    @RequiresApi(api=23)
    public void requestPermission(@NonNull String permission, int requestCode) throws IllegalStateException {
        this.requestPermissions(new String[]{permission}, requestCode);
    }

    @Override
    @RequiresApi(api=23)
    public void grantPermission(@NonNull String permission, int requestCode) throws IllegalStateException {
        Activity activity = this.getActivity();
        if (activity == null || activity.isFinishing()) {
            throw new IllegalStateException();
        }
        if (!AndroidUtils.hasPermission(activity, permission)) {
            if (this.shouldShowRequestPermissionRationale(permission)) {
                this.showRationale(permission, requestCode);
            } else {
                this.requestPermission(permission, requestCode);
            }
        } else {
            this.processPermission(permission, 0);
        }
    }

    private void showRationale(@NonNull String permission, int requestCode) {
        int idRequest = 0;
        switch (permission) {
            case "android.permission.CAMERA": {
                idRequest = R.string.permission_camera_request;
                break;
            }
            case "android.permission.INTERNET": {
                idRequest = R.string.permission_network_request;
                break;
            }
            case "android.permission.RECORD_AUDIO": {
                idRequest = R.string.permission_audio_recording_request;
                break;
            }
            case "android.permission.WRITE_EXTERNAL_STORAGE": 
            case "android.permission.READ_EXTERNAL_STORAGE": {
                idRequest = R.string.permission_ext_storage_request;
                break;
            }
            case "android.permission.ACCESS_COARSE_LOCATION": 
            case "android.permission.ACCESS_FINE_LOCATION": {
                idRequest = R.string.permission_location_request;
                break;
            }
            case "android.permission.BLUETOOTH": {
                idRequest = R.string.permission_location_request;
            }
        }
        MessageDialogAppFragment.showDialog(this, requestCode, R.string.permission_title, idRequest, new String[]{permission});
    }

    @Override
    public void onMessageDialogResult(@NonNull MessageDialogAppFragment dialog, int requestCode, @NonNull String[] permissions, boolean result) {
        if (result && BuildCheck.isMarshmallow()) {
            if (Build.VERSION.SDK_INT >= 23) {
                this.requestPermissions(permissions, requestCode);
            }
            return;
        }
        for (String permission : permissions) {
            this.processPermission(permission, PermissionCheck.checkSelfPermission((Context)this.getActivity(), (String)permission));
        }
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void processPermission(@NonNull String permission, int grantResult) {
        if (grantResult == 0) {
            this.sendCallbackMessage("OnPermissionGrant", permission);
        } else if (Build.VERSION.SDK_INT >= 23 && !this.shouldShowRequestPermissionRationale(permission)) {
            this.sendCallbackMessage("OnPermissionDenyAndNeverAskAgain", permission);
        } else {
            this.sendCallbackMessage("OnPermissionDeny", permission);
        }
    }

    private void sendCallbackMessage(@NonNull String event, @Nullable String args) {
        if (!TextUtils.isEmpty((CharSequence)this.mCallbackUnityObjName)) {
            try {
                UnityPlayer.UnitySendMessage((String)this.mCallbackUnityObjName, (String)event, (String)(args != null ? args : ""));
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        } else {
            Log.w((String)TAG, (String)"sendCallbackMessage:invalid callback unity object name");
        }
    }
}

